/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.starlibj;

import EDU.bmrb.starlibj.DataLoopNameListNode;
import EDU.bmrb.starlibj.LoopTableNode;
import EDU.bmrb.starlibj.RemoteInt;
import EDU.bmrb.starlibj.SkipTextHandler;
import EDU.bmrb.starlibj.StarNode;
import EDU.bmrb.starlibj.StarValidity;
import EDU.bmrb.starlibj.VectorCheckType;

public class DataLoopNode
extends StarNode
implements Cloneable {
    public SkipTextHandler skipper;
    protected DataLoopNameListNode myNames;
    protected LoopTableNode myVals;
    protected boolean parseMismatchFlag;

    public DataLoopNode() {
        this.myVals = new LoopTableNode();
        this.myNames = new DataLoopNameListNode();
        this.myVals.setParent(this);
        this.myNames.setParent(this);
        this.parseMismatchFlag = false;
        this.skipper = null;
    }

    public DataLoopNode(boolean tab) {
        this.myVals = new LoopTableNode();
        this.myNames = new DataLoopNameListNode();
        this.myVals.setTabFlag(tab);
        this.myVals.setParent(this);
        this.myNames.setParent(this);
        this.parseMismatchFlag = false;
        this.skipper = null;
    }

    public DataLoopNode(boolean tab, boolean indent, int rowsPerLine) {
        this.myVals = new LoopTableNode();
        this.myNames = new DataLoopNameListNode();
        this.myVals.setTabFlag(tab);
        this.myVals.setIndentFlag(indent);
        this.myVals.setRowsPerLine(rowsPerLine);
        this.myVals.setParent(this);
        this.myNames.setParent(this);
        this.parseMismatchFlag = false;
        this.skipper = null;
    }

    public DataLoopNode(DataLoopNameListNode names, LoopTableNode table) {
        this.myNames = names;
        this.myVals = table;
        this.myVals.setParent(this);
        this.myNames.setParent(this);
        this.parseMismatchFlag = false;
        this.skipper = null;
    }

    public DataLoopNode(DataLoopNode copyMe) {
        super(copyMe);
        this.myVals = (LoopTableNode)copyMe.getVals().clone();
        this.myVals.setParent(this);
        this.myNames = (DataLoopNameListNode)copyMe.getNames().clone();
        this.myNames.setParent(this);
        this.parseMismatchFlag = copyMe.parseMismatchFlag;
        this.skipper = new SkipTextHandler(copyMe.mySkips());
    }

    public Object clone() {
        return new DataLoopNode(this);
    }

    public LoopTableNode getVals() {
        return this.myVals;
    }

    public DataLoopNameListNode getNames() {
        return this.myNames;
    }

    public boolean getTabFlag() {
        return this.myVals.getTabFlag();
    }

    public void setTabFlag(boolean fl) {
        this.myVals.setTabFlag(fl);
    }

    public VectorCheckType searchByName(String searchFor) {
        VectorCheckType retVal = this.myNames.searchByName(searchFor);
        return retVal;
    }

    public VectorCheckType searchByTagValue(String tag, String value) {
        RemoteInt nestLvl = new RemoteInt();
        RemoteInt column = new RemoteInt();
        this.myNames.tagPositionDeep(tag, nestLvl, column);
        VectorCheckType retVal = this.myVals.searchForValsInColumn(nestLvl.num, column.num, value);
        return retVal;
    }

    public VectorCheckType searchForType(Class type, short delim) {
        VectorCheckType retVal = new VectorCheckType();
        short i = delim;
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            if (type.isInstance(this)) {
                retVal.addElement(this);
            }
            if (type == Class.forName(StarValidity.clsNameDataNameNode)) {
                retVal = this.myNames.searchForType(type, delim);
            } else if (type == Class.forName(StarValidity.clsNameDataValueNode)) {
                retVal = this.myVals.searchForType(type, delim);
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        return retVal;
    }

    public SkipTextHandler mySkips() {
        if (this.skipper != null) {
            return this.skipper;
        }
        this.skipper = new SkipTextHandler();
        return this.skipper;
    }
}

