/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.starlibj;

import EDU.bmrb.starlibj.DataLoopNode;
import EDU.bmrb.starlibj.DataValueNode;
import EDU.bmrb.starlibj.LoopTableNode;
import EDU.bmrb.starlibj.OperationCausesMismatchedLoopData;
import EDU.bmrb.starlibj.StarNode;
import EDU.bmrb.starlibj.StarValidity;
import EDU.bmrb.starlibj.VectorCheckType;

public class LoopRowNode
extends StarNode
implements Cloneable {
    StringBuffer myVal;
    int[] myStarts;
    LoopTableNode myInnerLoop;
    int mySize;

    public LoopRowNode() {
        this.myVal = new StringBuffer();
        this.myStarts = new int[0];
        this.mySize = 0;
    }

    public LoopRowNode(LoopRowNode copyMe) {
        super(copyMe);
        this.myVal = new StringBuffer(copyMe.myVal.toString());
        this.myInnerLoop = copyMe.myInnerLoop != null ? new LoopTableNode(copyMe.myInnerLoop) : null;
        this.mySize = copyMe.mySize;
        this.myStarts = new int[copyMe.myStarts.length];
        System.arraycopy(copyMe.myStarts, 0, this.myStarts, 0, this.myStarts.length);
    }

    public Object clone() {
        return new LoopRowNode(this);
    }

    public void ensureCapacity(int newCap) {
        if (this.myVal.capacity() < newCap) {
            this.myVal.ensureCapacity(newCap);
        }
    }

    public int capacity() {
        return this.myVal.capacity();
    }

    public int size() {
        return this.mySize;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public DataValueNode elementAt(int index) {
        char delimChar = this.myVal.charAt(this.myStarts[index]);
        DataValueNode retVal = new DataValueNode(this.myVal.toString().substring(this.myStarts[index] + 1, index < this.mySize - 1 ? this.myStarts[index + 1] : this.myVal.length()), delimChar == '\u0002' ? DataValueNode.SINGLE : (delimChar == '\u0003' ? DataValueNode.DOUBLE : (delimChar == '\u0004' ? DataValueNode.SEMICOLON : (delimChar == '\u0005' ? DataValueNode.FRAMECODE : DataValueNode.NON))));
        retVal.setParent(this);
        retVal.setLineNum(this.getLineNum());
        retVal.setColNum(this.getColNum());
        return retVal;
    }

    public String stringAt(int i) {
        if (i >= 0 && i < this.size()) {
            DataValueNode dvn = this.elementAt(i);
            if (dvn != null) {
                return dvn.getValue();
            }
            return null;
        }
        return null;
    }

    public DataValueNode firstElement() {
        return this.elementAt(0);
    }

    public DataValueNode lastElement() {
        return this.elementAt(this.mySize - 1);
    }

    public void setElementAt(DataValueNode val, int index) {
        StringBuffer insertStr = new StringBuffer();
        short delim = val.getDelimType();
        if (delim == DataValueNode.SINGLE) {
            insertStr.append('\u0002');
            insertStr.append(val.getValue());
        } else if (delim == DataValueNode.DOUBLE) {
            insertStr.append('\u0003');
            insertStr.append(val.getValue());
        } else if (delim == DataValueNode.SEMICOLON) {
            insertStr.append('\u0004');
            insertStr.append(val.getValue());
        } else if (delim == DataValueNode.FRAMECODE) {
            insertStr.append('\u0005');
            insertStr.append(val.getValue());
        } else {
            insertStr.append('\u0001');
            insertStr.append(val.getValue());
        }
        int offset = insertStr.length() - ((index < this.mySize - 1 ? this.myStarts[index + 1] : this.myVal.length()) - this.myStarts[index]);
        StringBuffer newMyVal = new StringBuffer();
        newMyVal.setLength(0);
        newMyVal.append(this.myVal.toString().substring(0, this.myStarts[index]));
        newMyVal.append(insertStr);
        newMyVal.append(index < this.mySize - 1 ? this.myVal.toString().substring(this.myStarts[index + 1]) : "");
        this.myVal = newMyVal;
        newMyVal = null;
        for (int i = index + 1; i < this.mySize; ++i) {
            this.myStarts[i] = this.myStarts[i] + offset;
        }
    }

    public void removeElementAt(int index) throws OperationCausesMismatchedLoopData {
        if (this.isInLoop() > 0) {
            throw new OperationCausesMismatchedLoopData();
        }
        this.privateRemoveElementAt(index);
    }

    private void privateRemoveElementAt(int index) throws OperationCausesMismatchedLoopData {
        int charsLost = (index < this.mySize - 1 ? this.myStarts[index + 1] : this.myVal.length()) - this.myStarts[index];
        StringBuffer newMyVal = new StringBuffer();
        newMyVal.setLength(0);
        newMyVal.append(this.myVal.toString().substring(0, this.myStarts[index]));
        newMyVal.append(index < this.mySize - 1 ? this.myVal.toString().substring(this.myStarts[index + 1]) : "");
        this.myVal = newMyVal;
        newMyVal = null;
        for (int i = index; i < this.mySize - 1; ++i) {
            this.myStarts[i] = this.myStarts[i + 1] - charsLost;
        }
        --this.mySize;
    }

    public void insertElementAt(DataValueNode val, int index) throws OperationCausesMismatchedLoopData {
        if (this.isInLoop() > 0) {
            throw new OperationCausesMismatchedLoopData();
        }
        this.privateInsertElementAt(val, index);
    }

    private void privateInsertElementAt(DataValueNode val, int index) {
        StringBuffer insertStr = new StringBuffer();
        short delim = val.getDelimType();
        if (delim == DataValueNode.SINGLE) {
            insertStr.append('\u0002');
            insertStr.append(val.getValue());
        } else if (delim == DataValueNode.DOUBLE) {
            insertStr.append('\u0003');
            insertStr.append(val.getValue());
        } else if (delim == DataValueNode.SEMICOLON) {
            insertStr.append('\u0004');
            insertStr.append(val.getValue());
        } else if (delim == DataValueNode.FRAMECODE) {
            insertStr.append('\u0005');
            insertStr.append(val.getValue());
        } else {
            insertStr.append('\u0001');
            insertStr.append(val.getValue());
        }
        int offset = insertStr.length();
        int oldSize = this.myVal.length();
        this.myVal.insert(index < this.mySize ? this.myStarts[index] : this.myVal.length(), (Object)insertStr);
        int[] tmp = new int[this.mySize + 1];
        if (this.mySize == 0) {
            tmp[0] = 0;
        } else {
            int i;
            for (i = 0; i <= index; ++i) {
                tmp[i] = i < this.mySize ? this.myStarts[i] : oldSize;
            }
            for (i = index + 1; i < tmp.length; ++i) {
                tmp[i] = this.myStarts[i - 1] + offset;
            }
        }
        this.myStarts = tmp;
        tmp = null;
        ++this.mySize;
    }

    public void addElement(DataValueNode val) throws OperationCausesMismatchedLoopData {
        this.privateInsertElementAt(val, this.mySize);
    }

    void insertColumnAtDepth(int depth, int columnIdx, DataValueNode val) {
        if (depth > 0) {
            if (this.getInnerLoop() != null) {
                this.getInnerLoop().insertColumnAtDepth(depth - 1, columnIdx, val);
            }
        } else {
            this.privateInsertElementAt(new DataValueNode(val), columnIdx);
        }
    }

    void removeColumnAtDepth(int depth, int columnIdx) {
        if (depth > 0) {
            if (this.getInnerLoop() != null) {
                this.getInnerLoop().removeColumnAtDepth(depth - 1, columnIdx);
            }
        } else {
            this.privateRemoveElementAt(columnIdx);
        }
    }

    public int isInLoop() {
        StarNode par = this;
        int retVal = 0;
        retVal = 0;
        for (par = this; par != null && !(par instanceof DataLoopNode); par = par.getParent()) {
            if (!(par instanceof LoopTableNode)) continue;
            ++retVal;
        }
        if (par == null) {
            return 0;
        }
        return retVal;
    }

    public LoopTableNode getInnerLoop() {
        return this.myInnerLoop;
    }

    public void setInnerLoop(LoopTableNode l) throws OperationCausesMismatchedLoopData {
        this.myInnerLoop = l;
        l.setParent(this);
    }

    public void removeInnerLoop() {
        this.myInnerLoop = null;
    }

    public VectorCheckType searchForType(Class type) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            if (type.isInstance(this)) {
                retVal.addElement(this);
            }
            for (int i = 0; i < this.size(); ++i) {
                VectorCheckType tmpVect = this.elementAt(i).searchForType(type, DataValueNode.DONT_CARE);
                for (int j = 0; j < tmpVect.size(); ++j) {
                    retVal.addElement(tmpVect.elementAt(j));
                }
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        return retVal;
    }

    public VectorCheckType searchForType(Class type, short delim) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            if (type.isInstance(this)) {
                retVal.addElement(this);
            }
            for (int i = 0; i < this.size(); ++i) {
                VectorCheckType tmpVect = this.elementAt(i).searchForType(type, delim);
                for (int j = 0; j < tmpVect.size(); ++j) {
                    retVal.addElement(tmpVect.elementAt(j));
                }
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        return retVal;
    }

    public void Unparse(int indent) {
    }
}

