/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.starlibj;

import EDU.bmrb.starlibj.DataLoopNode;
import EDU.bmrb.starlibj.DataValueNode;
import EDU.bmrb.starlibj.LoopRowNode;
import EDU.bmrb.starlibj.LoopRowsVector;
import EDU.bmrb.starlibj.OperationCausesMismatchedLoopData;
import EDU.bmrb.starlibj.StarNode;
import EDU.bmrb.starlibj.StarValidity;
import EDU.bmrb.starlibj.VectorCheckType;
import java.util.Enumeration;
import java.util.Vector;

public class LoopTableNode
extends StarNode
implements Cloneable {
    protected boolean myTabFlag;
    protected LoopRowsVector myRows = new LoopRowsVector();
    protected boolean myIndentFlag;
    protected int myRowsPerLine;

    public LoopTableNode() {
        this.myTabFlag = false;
        this.myIndentFlag = true;
        this.myRowsPerLine = 1;
    }

    public LoopTableNode(boolean tabFlag) {
        this.myTabFlag = tabFlag;
        this.myIndentFlag = true;
        this.myRowsPerLine = 1;
    }

    public LoopTableNode(boolean tabFlag, boolean indentFl, int rowsPerLn) {
        this.myTabFlag = tabFlag;
        this.myIndentFlag = indentFl;
        this.myRowsPerLine = rowsPerLn;
    }

    public LoopTableNode(LoopTableNode copyMe) {
        this.myTabFlag = copyMe.myTabFlag;
        this.myIndentFlag = copyMe.myIndentFlag;
        this.myRowsPerLine = copyMe.myRowsPerLine;
        for (int i = 0; i < copyMe.size(); ++i) {
            this.addElement((LoopRowNode)copyMe.elementAt(i).clone());
        }
    }

    public Object clone() {
        return new LoopTableNode(this);
    }

    public void setSize(int newSize) {
        this.myRows.setSize(newSize);
    }

    public int capacity() {
        return this.myRows.capacity();
    }

    public int size() {
        return this.myRows.size();
    }

    public boolean isEmpty() {
        return this.myRows.isEmpty();
    }

    public Enumeration elements() {
        return this.myRows.elements();
    }

    public boolean contains(LoopRowNode row) {
        return this.myRows.contains(row);
    }

    public int indexOf(LoopRowNode val) {
        return this.myRows.indexOf(val);
    }

    public int indexOf(LoopRowNode row, int index) {
        return this.myRows.indexOf(row, index);
    }

    public int lastIndexOf(LoopRowNode row) {
        return this.myRows.lastIndexOf(row);
    }

    public int lastIndexOf(LoopRowNode row, int index) {
        return this.myRows.lastIndexOf(row, index);
    }

    public LoopRowNode elementAt(int index) {
        return (LoopRowNode)this.myRows.elementAt(index);
    }

    public DataValueNode elementAt(int row, int col) {
        DataValueNode dvn = null;
        LoopRowNode lrn = null;
        if (row >= 0 && row < this.myRows.size()) {
            lrn = this.elementAt(row);
        }
        if (lrn != null) {
            // empty if block
        }
        return dvn;
    }

    public String stringAt(int row, int col) {
        DataValueNode dvn = this.elementAt(row, col);
        if (dvn != null) {
            return dvn.getValue();
        }
        return null;
    }

    public LoopRowNode firstElement() {
        return (LoopRowNode)this.myRows.firstElement();
    }

    public LoopRowNode lastElement() {
        return (LoopRowNode)this.myRows.lastElement();
    }

    public void setElementAt(LoopRowNode row, int index) throws OperationCausesMismatchedLoopData {
        int cols = this.privateNumColsAtMyDepth();
        if (cols >= 0 && cols != row.size()) {
            throw new OperationCausesMismatchedLoopData();
        }
        this.myRows.setElementAt(row, index);
        ((LoopRowNode)this.myRows.elementAt(index)).setParent(this);
    }

    public void removeElementAt(int index) {
        StarNode par;
        ((LoopRowNode)this.myRows.elementAt(index)).setParent(null);
        this.myRows.removeElementAt(index);
        if (this.size() == 0 && (par = this.getParent()) != null && par instanceof LoopRowNode) {
            ((LoopRowNode)par).removeInnerLoop();
        }
    }

    public void insertElementAt(LoopRowNode row, int index) {
        this.myRows.insertElementAt(row, index);
        ((LoopRowNode)this.myRows.elementAt(index)).setParent(this);
    }

    protected int privateNumColsAtMyDepth() {
        int depth = 0;
        StarNode par = null;
        try {
            for (par = this; par != null && !Class.forName(StarValidity.clsNameDataLoopNode).isInstance(par); par = par.getParent()) {
                if (!Class.forName(StarValidity.clsNameLoopRowNode).isInstance(par)) continue;
                ++depth;
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        if (par == null) {
            return -1;
        }
        return ((DataLoopNode)par).getNames().elementAt(depth).size();
    }

    public void addElement(LoopRowNode row) throws OperationCausesMismatchedLoopData {
        int cols = this.privateNumColsAtMyDepth();
        if (cols >= 0 && cols != row.size()) {
            throw new OperationCausesMismatchedLoopData();
        }
        this.myRows.addElement(row);
        ((LoopRowNode)this.myRows.lastElement()).setParent(this);
    }

    public boolean removeElement(LoopRowNode row) {
        StarNode par;
        row.setParent(null);
        boolean retVal = this.myRows.removeElement(row);
        if (this.size() == 0 && (par = this.getParent()) != null && par instanceof LoopRowNode) {
            ((LoopRowNode)par).removeInnerLoop();
        }
        return retVal;
    }

    void removeColumnAtDepth(int depth, int columnIdx) {
        for (int i = 0; i < this.myRows.size(); ++i) {
            ((LoopRowNode)this.myRows.elementAt(i)).removeColumnAtDepth(depth, columnIdx);
        }
    }

    void insertColumnAtDepth(int depth, int columnIdx, DataValueNode val) {
        for (int i = 0; i < this.myRows.size(); ++i) {
            ((LoopRowNode)this.myRows.elementAt(i)).insertColumnAtDepth(depth, columnIdx, val);
        }
    }

    public int isInLoop() {
        StarNode par = this;
        int retVal = 0;
        retVal = 0;
        for (par = this; par != null && !(par instanceof DataLoopNode); par = par.getParent()) {
            if (!(par instanceof LoopTableNode)) continue;
            ++retVal;
        }
        if (par == null) {
            return 0;
        }
        return retVal;
    }

    public void Unparse(int indent) {
    }

    public void setTabFlag(boolean tabFlag) {
        this.myTabFlag = tabFlag;
        for (int i = 0; i < this.size(); ++i) {
            LoopTableNode iLoop = this.elementAt(i).getInnerLoop();
            if (iLoop == null) continue;
            iLoop.setTabFlag(tabFlag);
        }
    }

    public boolean getTabFlag() {
        return this.myTabFlag;
    }

    public void setIndentFlag(boolean tabFlag) {
        this.myIndentFlag = tabFlag;
    }

    public boolean getIndentFlag() {
        return this.myIndentFlag;
    }

    public void setRowsPerLine(int setTo) {
        this.myRowsPerLine = setTo;
    }

    public int getRowsPerLine() {
        return this.myRowsPerLine;
    }

    public VectorCheckType searchForType(Class type) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            if (type.isInstance(this)) {
                retVal.addElement(this);
            }
            for (int i = 0; i < this.myRows.size(); ++i) {
                VectorCheckType tmpVect = ((LoopRowNode)this.myRows.elementAt(i)).searchForType(type);
                for (int j = 0; j < tmpVect.size(); ++j) {
                    retVal.addElement(tmpVect.elementAt(j));
                }
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        return retVal;
    }

    public VectorCheckType searchForType(Class type, short delim) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            if (type == this.getClass()) {
                retVal.addElement(this);
            }
            for (int i = 0; i < this.myRows.size(); ++i) {
                VectorCheckType tmpVect = ((LoopRowNode)this.myRows.elementAt(i)).searchForType(type, delim);
                for (int j = 0; j < tmpVect.size(); ++j) {
                    retVal.addElement(tmpVect.elementAt(j));
                }
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        return retVal;
    }

    protected int getMyDepth() {
        StarNode par;
        int retVal = -1;
        for (par = this; par != null && !(par instanceof DataLoopNode); par = par.getParent()) {
            if (!(par instanceof LoopTableNode)) continue;
            ++retVal;
        }
        if (par == null) {
            return -1;
        }
        return retVal;
    }

    protected int getMaxDepth() {
        StarNode par;
        int retVal = -1;
        for (par = this; par != null && !(par instanceof DataLoopNode); par = par.getParent()) {
        }
        if (par == null) {
            return -1;
        }
        return ((DataLoopNode)par).getNames().size() - 1;
    }

    protected void truncateNestLevel(int depth) {
        if (depth == 0) {
            while (this.myRows.size() > 0) {
                this.myRows.removeElementAt(0);
            }
        } else {
            for (int i = 0; i < this.myRows.size(); ++i) {
                if (((LoopRowNode)this.myRows.elementAt(i)).getInnerLoop() == null) continue;
                ((LoopRowNode)this.myRows.elementAt(i)).getInnerLoop().truncateNestLevel(depth - 1);
                if (depth != 1) continue;
                ((LoopRowNode)this.myRows.elementAt(i)).removeInnerLoop();
            }
        }
    }

    protected VectorCheckType searchForValsInColumn(int searchNest, int searchCol, String value) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            for (int i = 0; i < this.size(); ++i) {
                if (searchNest == 0) {
                    if (!this.elementAt(i).elementAt(searchCol).getValue().equals(value)) continue;
                    retVal.addElement(this.elementAt(i).elementAt(searchCol));
                    continue;
                }
                if (this.elementAt(i).getInnerLoop() == null) continue;
                VectorCheckType tmpVal = this.elementAt(i).getInnerLoop().searchForValsInColumn(searchNest - 1, searchCol, value);
                for (int j = 0; j < tmpVal.size(); ++j) {
                    retVal.addElement(tmpVal.elementAt(j));
                }
                tmpVal = null;
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        return retVal;
    }

    protected void calcPrintSizes(Vector preSizes, Vector postSizes, Vector nonQuotedFlags) {
        int numCols = 0;
        int curCol = 0;
        if (this.myRows.size() > 0) {
            numCols = this.elementAt(0).size();
        }
        if (numCols == 0) {
            return;
        }
        for (curCol = 0; curCol < numCols; ++curCol) {
            preSizes.addElement(new Integer(0));
            postSizes.addElement(new Integer(-1));
            nonQuotedFlags.addElement(new Boolean(true));
        }
        for (int outer_idx = 0; outer_idx < this.myRows.size(); ++outer_idx) {
            LoopRowNode curRow = this.elementAt(outer_idx);
            for (int inner_idx = 0; inner_idx < curRow.size(); ++inner_idx) {
                String curStr = curRow.elementAt(inner_idx).getValue();
                int curPre = curRow.elementAt(inner_idx).myLongestStr();
                if (curRow.elementAt(inner_idx).getDelimType() != DataValueNode.NON) {
                    nonQuotedFlags.setElementAt(new Boolean(false), inner_idx);
                }
                int curPost = -1;
                if (curRow.elementAt(inner_idx).getDelimType() == DataValueNode.NON) {
                    int curIdx;
                    String tmpStr = new String(curStr);
                    int sLen = tmpStr.length();
                    int dotIdx = -1;
                    for (curIdx = 0; curIdx < sLen && Character.isWhitespace(tmpStr.charAt(curIdx)); ++curIdx) {
                    }
                    if (curIdx < sLen && (tmpStr.charAt(curIdx) == '-' || tmpStr.charAt(curIdx) == '+')) {
                        ++curIdx;
                    }
                    while (curIdx < sLen && Character.isDigit(tmpStr.charAt(curIdx))) {
                        ++curIdx;
                    }
                    curPre = curIdx;
                    if (curIdx < sLen && tmpStr.charAt(curIdx) == '.') {
                        dotIdx = curIdx++;
                    }
                    curPost = 0;
                    while (curIdx < sLen && Character.isDigit(tmpStr.charAt(curIdx))) {
                        ++curPost;
                        ++curIdx;
                    }
                    while (curIdx < sLen && Character.isWhitespace(tmpStr.charAt(curIdx))) {
                        ++curIdx;
                    }
                    if (curIdx < sLen || tmpStr.equals(".")) {
                        curPost = -1;
                        curPre = curRow.elementAt(inner_idx).myLongestStr();
                    }
                } else if (curRow.elementAt(inner_idx).getDelimType() == DataValueNode.SEMICOLON) {
                    curPre = 0;
                }
                if ((Integer)preSizes.elementAt(inner_idx) < curPre) {
                    preSizes.setElementAt(new Integer(curPre), inner_idx);
                }
                if ((Integer)postSizes.elementAt(inner_idx) >= curPost) continue;
                postSizes.setElementAt(new Integer(curPost), inner_idx);
            }
        }
    }
}

