/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.starlibj;

import EDU.bmrb.starlibj.ASCII_CharStream;
import EDU.bmrb.starlibj.BlockNode;
import EDU.bmrb.starlibj.DataItemNode;
import EDU.bmrb.starlibj.DataLoopNameListNode;
import EDU.bmrb.starlibj.DataLoopNode;
import EDU.bmrb.starlibj.DataNameNode;
import EDU.bmrb.starlibj.DataValueNode;
import EDU.bmrb.starlibj.HomemadeStringBuffer;
import EDU.bmrb.starlibj.LoopNameListNode;
import EDU.bmrb.starlibj.LoopRowNode;
import EDU.bmrb.starlibj.LoopTableNode;
import EDU.bmrb.starlibj.ParseException;
import EDU.bmrb.starlibj.SaveFrameNode;
import EDU.bmrb.starlibj.StarFileNode;
import EDU.bmrb.starlibj.StarNode;
import EDU.bmrb.starlibj.StarParserConstants;
import EDU.bmrb.starlibj.StarParserTokenManager;
import EDU.bmrb.starlibj.Token;
import java.io.InputStream;
import java.io.Reader;
import java.util.Vector;

public class StarParser
implements StarParserConstants {
    private Vector stk = new Vector();
    private static int verbose = 0;
    private static Vector skipStrings;
    private static Vector skipLineNums;
    public static int prevLine;
    public static String symbolTinyAbsTypeName;
    public static String symbolDataValueNode;
    public static String symbolDataNameNode;
    public static String symbolDataItemNode;
    public static String symbolBlockNode;
    public static String symbolSaveFrameNode;
    public static String symbolHomemadeStringBuffer;
    public static String symbolLoopTableNode;
    public static String symbolDataLoopNameListNode;
    public static char lineDelim;
    public static char fieldDelim;
    public static char singleMarker;
    public static char doubleMarker;
    public static char semicolonMarker;
    public static char framecodeMarker;
    public static char nonMarker;
    private static boolean jj_initialized_once;
    public static StarParserTokenManager token_source;
    static ASCII_CharStream jj_input_stream;
    public static Token token;
    public static Token jj_nt;
    private static int jj_gen;
    private static final int[] jj_la1;
    private static final int[] jj_la1_0;
    private static Vector jj_expentries;
    private static int[] jj_expentry;
    private static int jj_kind;

    private void trunc(int idx) {
        if (verbose > 2) {
            System.out.println("parsedebug: trunc begin. size = " + new Integer(this.stk.size()).toString() + " idx to trunc at = " + new Integer(idx).toString());
        }
        while (idx + 1 < this.stk.size()) {
            this.stk.removeElementAt(idx + 1);
        }
        if (verbose > 2) {
            System.out.println("parsedebug: trunc done. size = " + new Integer(this.stk.size()).toString());
        }
    }

    private Object peek(int n) {
        if (verbose > 2) {
            System.out.println("parsedebug: peeking at " + new Integer(n).toString() + " from the top of a stack of size " + new Integer(this.size()).toString());
        }
        return this.stk.elementAt(this.size() - n);
    }

    private Object elementAt(int i) {
        if (verbose > 2) {
            System.out.println("parsedebug: peeking at " + new Integer(i).toString() + " from the botom of a stack of size " + new Integer(this.size()).toString());
        }
        return this.stk.elementAt(i);
    }

    private void push(Object o) {
        if (verbose > 2) {
            System.out.println("parsedebug: pushing onto a stack of size " + new Integer(this.size()).toString());
        }
        this.stk.addElement(o);
    }

    private int size() {
        return this.stk.size();
    }

    public StarNode popResult() {
        StarNode retVal = (StarNode)this.peek(1);
        this.trunc(-1);
        if (retVal.mySkips() != null) {
            retVal.mySkips().setSkipTexts(skipStrings, skipLineNums);
        }
        if (skipStrings != null) {
            skipStrings.clear();
        }
        if (skipLineNums != null) {
            skipLineNums.clear();
        }
        return retVal;
    }

    public StarNode endResult() {
        return this.popResult();
    }

    public void setVerbose(int verboseNum) {
        verbose = verboseNum;
    }

    public void trimToSize() {
        this.stk.trimToSize();
    }

    public int getNumValsInCurLoopAtLevel(int nest) {
        try {
            int i;
            int stackSize = this.size();
            for (i = 1; i <= stackSize && !Class.forName(symbolDataLoopNameListNode).isInstance(this.peek(i)); ++i) {
            }
            if (i > stackSize) {
                return 0;
            }
            DataLoopNameListNode node = (DataLoopNameListNode)this.peek(i);
            if (nest < 0 || nest >= node.size()) {
                return 0;
            }
            return node.elementAt(nest).size();
        }
        catch (ClassNotFoundException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return 0;
        }
    }

    public static void saveSkippedString(int l_num, StringBuffer s) {
        StringBuffer sb = new StringBuffer(s.length());
        Integer ln = new Integer(l_num);
        sb.append(s.toString());
        if (skipStrings == null) {
            skipStrings = new Vector();
        }
        skipStrings.add(sb);
        if (skipLineNums == null) {
            skipLineNums = new Vector();
        }
        skipLineNums.add(ln);
    }

    void dumpStack() {
        int sz = this.size();
        int verboseRemember = verbose;
        verbose = 0;
        System.out.println("           stack dump: ");
        for (int i = sz - 1; i >= 0; --i) {
            if (i == sz - 1) {
                System.out.print("   TOP->");
            } else if (i == 0) {
                System.out.print("BOTTOM->");
            } else {
                System.out.print("        ");
            }
            System.out.print(new Integer(i).toString() + " ");
            if (this.elementAt(i) == null) {
                System.out.print("(null)");
                continue;
            }
            try {
                Object obj = this.elementAt(i);
                System.out.print("type = " + obj.getClass().getName() + " ");
                if (Class.forName(symbolDataValueNode).isInstance(obj)) {
                    System.out.print("name = " + ((DataValueNode)obj).getValue());
                } else if (Class.forName(symbolDataNameNode).isInstance(obj)) {
                    System.out.print("name = " + ((DataNameNode)obj).getLabel());
                } else if (Class.forName(symbolDataItemNode).isInstance(obj)) {
                    System.out.print("name = " + ((DataItemNode)obj).getLabel() + " value = " + ((DataItemNode)obj).getValue());
                } else if (Class.forName(symbolBlockNode).isInstance(obj)) {
                    System.out.print("name = " + ((BlockNode)obj).getLabel());
                } else if (Class.forName(symbolSaveFrameNode).isInstance(obj)) {
                    System.out.print("name = " + ((SaveFrameNode)obj).getLabel());
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            System.out.println("");
        }
        verbose = verboseRemember;
    }

    public static final void EpsilonParse() throws ParseException {
    }

    public static final void StarFileNodeParse(StarParser p) throws ParseException {
        int stkStart = p.size() - 1;
        block3: while (true) {
            StarParser.BlockNodeParse(p);
            switch (StarParser.jj_nt.kind) {
                case 12: 
                case 15: {
                    continue block3;
                }
            }
            break;
        }
        StarParser.jj_la1[0] = jj_gen;
        int sz = p.size();
        StarFileNode me = new StarFileNode();
        for (int i = stkStart + 1; i < sz; ++i) {
            me.addElement((BlockNode)p.elementAt(i));
            if (i != stkStart + 1) continue;
            me.setLineNum(((StarNode)p.elementAt(i)).getLineNum());
            me.setColNum(((StarNode)p.elementAt(i)).getColNum());
        }
        p.trunc(stkStart);
        p.push(me);
        p.trimToSize();
    }

    public static final void BlockNodeParse(StarParser p) throws ParseException {
        Token t1 = StarParser.getToken(1);
        int stkStart = p.size() - 1;
        String t1_image = t1.image;
        int t1_beginLine = t1.beginLine;
        int t1_beginColumn = t1.beginColumn;
        t1 = null;
        switch (StarParser.jj_nt.kind) {
            case 15: {
                StarParser.jj_consume_token(15);
                break;
            }
            case 12: {
                StarParser.jj_consume_token(12);
                break;
            }
            default: {
                StarParser.jj_la1[1] = jj_gen;
                StarParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block7: while (true) {
            StarParser.DataNodeParse(p);
            switch (StarParser.jj_nt.kind) {
                case 11: 
                case 16: 
                case 18: {
                    continue block7;
                }
            }
            break;
        }
        StarParser.jj_la1[2] = jj_gen;
        int sz = p.size();
        BlockNode me = null;
        me = new BlockNode(t1_image);
        me.setLineNum(t1_beginLine);
        me.setColNum(t1_beginColumn);
        for (int i = stkStart + 1; i < sz; ++i) {
            me.addElement((StarNode)p.elementAt(i));
        }
        p.trunc(stkStart);
        p.push(me);
        p.trimToSize();
    }

    public static final void DataNodeParse(StarParser p) throws ParseException {
        switch (StarParser.jj_nt.kind) {
            case 18: {
                StarParser.DataItemNodeParse(p);
                break;
            }
            case 11: {
                StarParser.DataLoopNodeParse(p);
                break;
            }
            case 16: {
                StarParser.SaveFrameNodeParse(p);
                break;
            }
            default: {
                StarParser.jj_la1[3] = jj_gen;
                StarParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void DataItemNodeParse(StarParser p) throws ParseException {
        int stkStart = p.size() - 1;
        StarParser.DataNameNodeParse(p);
        StarParser.DataValueNodeParse(p);
        DataItemNode me = new DataItemNode((DataNameNode)p.peek(2), (DataValueNode)p.peek(1));
        me.setLineNum(((DataValueNode)p.peek(1)).getLineNum());
        me.setColNum(((DataValueNode)p.peek(1)).getColNum());
        p.trunc(stkStart);
        p.push(me);
    }

    public static final void DataNameNodeParse(StarParser p) throws ParseException {
        Token t1 = StarParser.getToken(1);
        String t1_image = t1.image;
        int t1_beginLine = t1.beginLine;
        int t1_beginColumn = t1.beginColumn;
        t1 = null;
        StarParser.jj_consume_token(18);
        DataNameNode me = new DataNameNode(t1_image);
        me.setLineNum(t1_beginLine);
        me.setColNum(t1_beginColumn);
        p.push(me);
    }

    public static final void TinyAbsDataValueNodeParse(StarParser p) throws ParseException {
        Token t1 = StarParser.getToken(1);
        int stkStart = p.size() - 1;
        String t1_image = t1.image;
        int t1_beginLine = t1.beginLine;
        int t1_beginColumn = t1.beginColumn;
        t1 = null;
        StarParser.DataValueNodeParse(p);
        try {
            HomemadeStringBuffer buf;
            DataValueNode meDVN = (DataValueNode)p.peek(1);
            p.trunc(stkStart);
            if (Class.forName(symbolHomemadeStringBuffer).isInstance(p.peek(1))) {
                buf = (HomemadeStringBuffer)p.peek(1);
            } else {
                buf = new HomemadeStringBuffer("");
                prevLine = -1;
                p.push(buf);
            }
            if (prevLine != t1_beginLine) {
                buf.append(lineDelim);
                buf.append(String.valueOf(t1_beginLine));
                prevLine = t1_beginLine;
            }
            buf.append(fieldDelim);
            buf.append(String.valueOf(t1_beginColumn));
            buf.append(fieldDelim);
            short delim = meDVN.getDelimType();
            if (delim == DataValueNode.SINGLE) {
                buf.append(singleMarker);
                buf.append(meDVN.getValue());
            } else if (delim == DataValueNode.DOUBLE) {
                buf.append(doubleMarker);
                buf.append(meDVN.getValue());
            } else if (delim == DataValueNode.SEMICOLON) {
                buf.append(semicolonMarker);
                buf.append(meDVN.getValue());
            } else if (delim == DataValueNode.FRAMECODE) {
                buf.append(framecodeMarker);
                buf.append(meDVN.getValue());
            } else {
                buf.append(nonMarker);
                buf.append(meDVN.getValue());
            }
            meDVN = null;
            buf = null;
        }
        catch (ClassNotFoundException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public static final void DataValueNodeParse(StarParser p) throws ParseException {
        Token t1 = StarParser.getToken(1);
        String t1_image = t1.image;
        int t1_beginLine = t1.beginLine;
        int t1_beginColumn = t1.beginColumn;
        t1 = null;
        switch (StarParser.jj_nt.kind) {
            case 20: {
                StarParser.jj_consume_token(20);
                DataValueNode me = new DataValueNode(t1_image, DataValueNode.NON);
                me.setLineNum(t1_beginLine);
                me.setColNum(t1_beginColumn);
                p.push(me);
                break;
            }
            case 17: {
                StarParser.jj_consume_token(17);
                DataValueNode me = new DataValueNode(t1_image.substring(1, t1_image.length()), DataValueNode.FRAMECODE);
                me.setLineNum(t1_beginLine);
                me.setColNum(t1_beginColumn);
                p.push(me);
                break;
            }
            case 22: {
                StarParser.jj_consume_token(22);
                int firstq = t1_image.indexOf(39);
                int lastq = t1_image.lastIndexOf(39);
                DataValueNode me = new DataValueNode(t1_image.substring(firstq + 1, lastq), DataValueNode.SINGLE);
                me.setLineNum(t1_beginLine);
                me.setColNum(t1_beginColumn);
                p.push(me);
                break;
            }
            case 25: {
                StarParser.jj_consume_token(25);
                int firstq = t1_image.indexOf(34);
                int lastq = t1_image.lastIndexOf(34);
                DataValueNode me = new DataValueNode(t1_image.substring(firstq + 1, lastq), DataValueNode.DOUBLE);
                me.setLineNum(t1_beginLine);
                me.setColNum(t1_beginColumn);
                p.push(me);
                break;
            }
            case 19: {
                StarParser.jj_consume_token(19);
                int firstq = t1_image.indexOf(59);
                int lastq = t1_image.lastIndexOf(59);
                if (t1_image.charAt(firstq + 1) == '\r') {
                    if (t1_image.charAt(firstq + 2) == '\n') {
                        ++firstq;
                    }
                    ++firstq;
                } else if (t1_image.charAt(firstq + 1) == '\n') {
                    if (t1_image.charAt(firstq + 2) == '\r') {
                        ++firstq;
                    }
                    ++firstq;
                }
                DataValueNode me = new DataValueNode(t1_image.substring(firstq + 1, lastq), DataValueNode.SEMICOLON);
                me.setLineNum(t1_beginLine);
                me.setColNum(t1_beginColumn);
                p.push(me);
                break;
            }
            default: {
                StarParser.jj_la1[4] = jj_gen;
                StarParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void SaveFrameNodeParse(StarParser p) throws ParseException {
        Token t1 = StarParser.getToken(1);
        int stkStart = p.size() - 1;
        String t1_image = t1.image;
        int t1_beginLine = t1.beginLine;
        int t1_beginColumn = t1.beginColumn;
        t1 = null;
        StarParser.jj_consume_token(16);
        block3: while (true) {
            switch (StarParser.jj_nt.kind) {
                case 11: 
                case 18: {
                    break;
                }
                default: {
                    StarParser.jj_la1[5] = jj_gen;
                    break block3;
                }
            }
            StarParser.SaveDataNodeParse(p);
        }
        StarParser.jj_consume_token(14);
        int sz = p.size();
        SaveFrameNode me = null;
        me = new SaveFrameNode(t1_image);
        me.setLineNum(t1_beginLine);
        me.setColNum(t1_beginColumn);
        for (int i = stkStart + 1; i < sz; ++i) {
            me.addElement((StarNode)p.elementAt(i));
        }
        p.trunc(stkStart);
        p.push(me);
        p.trimToSize();
    }

    public static final void SaveDataNodeParse(StarParser p) throws ParseException {
        switch (StarParser.jj_nt.kind) {
            case 18: {
                StarParser.DataItemNodeParse(p);
                break;
            }
            case 11: {
                StarParser.DataLoopNodeParse(p);
                break;
            }
            default: {
                StarParser.jj_la1[6] = jj_gen;
                StarParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void LoopValuesParse(StarParser p) throws ParseException {
        block9: while (true) {
            StarParser.DataValueNodeParse(p);
            switch (StarParser.jj_nt.kind) {
                case 17: 
                case 19: 
                case 20: 
                case 22: 
                case 25: {
                    continue block9;
                }
            }
            break;
        }
        StarParser.jj_la1[7] = jj_gen;
        block10: while (true) {
            switch (StarParser.jj_nt.kind) {
                case 13: {
                    break;
                }
                default: {
                    StarParser.jj_la1[8] = jj_gen;
                    break block10;
                }
            }
            StarParser.StopParse(p);
            while (true) {
                switch (StarParser.jj_nt.kind) {
                    case 17: 
                    case 19: 
                    case 20: 
                    case 22: 
                    case 25: {
                        break;
                    }
                    default: {
                        StarParser.jj_la1[9] = jj_gen;
                        continue block10;
                    }
                }
                StarParser.DataValueNodeParse(p);
            }
            break;
        }
    }

    public static final void StopParse(StarParser p) throws ParseException {
        StarParser.jj_consume_token(13);
        p.push(new Integer(999));
    }

    public static final void OptionalStopParse(StarParser p) throws ParseException {
        switch (StarParser.jj_nt.kind) {
            case 13: {
                StarParser.jj_consume_token(13);
                break;
            }
            default: {
                StarParser.jj_la1[10] = jj_gen;
                StarParser.EpsilonParse();
            }
        }
    }

    public static final void LoopTableNodeParse(StarParser p, int nest) throws ParseException {
        int stkStart = p.size() - 1;
        LoopTableNode me = new LoopTableNode();
        switch (StarParser.jj_nt.kind) {
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 25: {
                block7: while (true) {
                    StarParser.LoopRowNodeParse(p, me, nest);
                    switch (StarParser.jj_nt.kind) {
                        case 17: 
                        case 19: 
                        case 20: 
                        case 22: 
                        case 25: {
                            continue block7;
                        }
                    }
                    break;
                }
                StarParser.jj_la1[11] = jj_gen;
                StarParser.OptionalStopParse(p);
                p.push(me);
                break;
            }
            case 13: {
                StarParser.jj_consume_token(13);
                p.push(null);
                break;
            }
            default: {
                StarParser.jj_la1[12] = jj_gen;
                StarParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void LoopRowNodeParse(StarParser p, LoopTableNode tbl, int nest) throws ParseException {
        int stkStart = p.size() - 1;
        int n = p.getNumValsInCurLoopAtLevel(nest);
        StarParser.DataValueNodeParse(p);
        StarParser.RestOfLoopRowNodeParse(p, nest, n - 1);
        LoopRowNode me = (LoopRowNode)p.peek(1);
        me.setElementAt((DataValueNode)p.peek(2), 0);
        p.trunc(stkStart);
        tbl.addElement(me);
        boolean someOnSameLine = false;
        for (int valNum = 1; valNum < me.size(); ++valNum) {
            int thisLineNum;
            int prevLineNum = me.elementAt(valNum - 1).getLineNum();
            if (prevLineNum == (thisLineNum = me.elementAt(valNum - 1).getLineNum())) {
                someOnSameLine = true;
            }
            if (someOnSameLine && prevLineNum == thisLineNum) continue;
        }
    }

    static void RestOfLoopRowNodeParse(StarParser p, int nest, int remainingVals) throws ParseException {
        LoopRowNode me = new LoopRowNode();
        int stkStart = p.size() - 1;
        me.setLineNum(((DataValueNode)p.peek(1)).getLineNum());
        me.setColNum(((DataValueNode)p.peek(1)).getColNum());
        me.addElement(new DataValueNode("ParseDummy", DataValueNode.NON));
        for (int i = 0; i < remainingVals; ++i) {
            StarParser.DataValueNodeParse(p);
            me.addElement((DataValueNode)p.peek(1));
        }
        int n = p.getNumValsInCurLoopAtLevel(nest + 1);
        if (n > 0) {
            StarParser.LoopTableNodeParse(p, nest + 1);
            if (p.peek(1) != null) {
                me.setInnerLoop((LoopTableNode)p.peek(1));
            }
        }
        p.trunc(stkStart);
        p.push(me);
    }

    public static final void DataLoopNodeParse(StarParser p) throws ParseException {
        int stkStart = p.size() - 1;
        StarParser.DataLoopNameListNodeParse(p);
        StarParser.LoopTableNodeParse(p, 0);
        LoopTableNode myValues = new LoopTableNode();
        DataLoopNameListNode myNames = (DataLoopNameListNode)p.peek(2);
        myValues = (LoopTableNode)p.peek(1);
        DataLoopNode me = new DataLoopNode(myNames, myValues);
        me.setTabFlag(false);
        if (me.getVals().size() > 0) {
            int prev_line = -9999;
            for (int i = 0; i < me.getVals().elementAt(0).size(); ++i) {
                if (prev_line == me.getVals().elementAt(0).elementAt(i).getLineNum()) {
                    me.setTabFlag(true);
                    break;
                }
                prev_line = me.getVals().elementAt(0).elementAt(i).getLineNum();
            }
        }
        p.trunc(stkStart);
        me.setLineNum(myNames.getLineNum());
        me.setColNum(myNames.getColNum());
        p.push(me);
        p.trimToSize();
    }

    public static final void DataLoopNameListNodeParse(StarParser p) throws ParseException {
        int stkStart = p.size() - 1;
        block3: while (true) {
            StarParser.jj_consume_token(11);
            StarParser.LoopNameListNodeParse(p);
            switch (StarParser.jj_nt.kind) {
                case 11: {
                    continue block3;
                }
            }
            break;
        }
        StarParser.jj_la1[13] = jj_gen;
        int sz = p.size();
        DataLoopNameListNode me = new DataLoopNameListNode();
        for (int i = stkStart + 1; i < sz; ++i) {
            me.addElement((LoopNameListNode)p.elementAt(i));
            if (i != stkStart + 1) continue;
            me.setLineNum(((LoopNameListNode)p.elementAt(i)).getLineNum());
            me.setColNum(((LoopNameListNode)p.elementAt(i)).getColNum());
        }
        p.trunc(stkStart);
        p.push(me);
    }

    public static final void LoopNameListNodeParse(StarParser p) throws ParseException {
        int stkStart = p.size() - 1;
        block3: while (true) {
            StarParser.DataNameNodeParse(p);
            switch (StarParser.jj_nt.kind) {
                case 18: {
                    continue block3;
                }
            }
            break;
        }
        StarParser.jj_la1[14] = jj_gen;
        int sz = p.size();
        LoopNameListNode me = new LoopNameListNode();
        for (int i = stkStart + 1; i < sz; ++i) {
            me.addElement((DataNameNode)p.elementAt(i));
            if (i != stkStart + 1) continue;
            me.setLineNum(((DataNameNode)p.elementAt(i)).getLineNum());
            me.setColNum(((DataNameNode)p.elementAt(i)).getColNum());
        }
        p.trunc(stkStart);
        p.push(me);
    }

    public StarParser(InputStream stream) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  You must");
            System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new ASCII_CharStream(stream, 1, 1);
        token_source = new StarParserTokenManager(jj_input_stream);
        token = new Token();
        StarParser.token.next = jj_nt = token_source.getNextToken();
        jj_gen = 0;
        for (int i = 0; i < 15; ++i) {
            StarParser.jj_la1[i] = -1;
        }
    }

    public static void ReInit(InputStream stream) {
        ASCII_CharStream.ReInit(stream, 1, 1);
        StarParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        StarParser.token.next = jj_nt = token_source.getNextToken();
        jj_gen = 0;
        for (int i = 0; i < 15; ++i) {
            StarParser.jj_la1[i] = -1;
        }
    }

    public StarParser(Reader stream) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  You must");
            System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new ASCII_CharStream(stream, 1, 1);
        token_source = new StarParserTokenManager(jj_input_stream);
        token = new Token();
        StarParser.token.next = jj_nt = token_source.getNextToken();
        jj_gen = 0;
        for (int i = 0; i < 15; ++i) {
            StarParser.jj_la1[i] = -1;
        }
    }

    public static void ReInit(Reader stream) {
        ASCII_CharStream.ReInit(stream, 1, 1);
        StarParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        StarParser.token.next = jj_nt = token_source.getNextToken();
        jj_gen = 0;
        for (int i = 0; i < 15; ++i) {
            StarParser.jj_la1[i] = -1;
        }
    }

    public StarParser(StarParserTokenManager tm) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  You must");
            System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        token_source = tm;
        token = new Token();
        StarParser.token.next = jj_nt = token_source.getNextToken();
        jj_gen = 0;
        for (int i = 0; i < 15; ++i) {
            StarParser.jj_la1[i] = -1;
        }
    }

    public void ReInit(StarParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        StarParser.token.next = jj_nt = token_source.getNextToken();
        jj_gen = 0;
        for (int i = 0; i < 15; ++i) {
            StarParser.jj_la1[i] = -1;
        }
    }

    private static final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = token;
        token = jj_nt;
        jj_nt = StarParser.token.next != null ? StarParser.jj_nt.next : (StarParser.jj_nt.next = token_source.getNextToken());
        if (StarParser.token.kind == kind) {
            ++jj_gen;
            oldToken.next = null;
            oldToken.specialToken = null;
            return token;
        }
        jj_nt = token;
        token = oldToken;
        jj_kind = kind;
        throw StarParser.generateParseException();
    }

    public static final Token getNextToken() {
        token = jj_nt;
        jj_nt = StarParser.token.next != null ? StarParser.jj_nt.next : (StarParser.jj_nt.next = token_source.getNextToken());
        ++jj_gen;
        return token;
    }

    public static final Token getToken(int index) {
        Token t = token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = token_source.getNextToken());
        }
        return t;
    }

    public static final ParseException generateParseException() {
        int i;
        jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[31];
        for (i = 0; i < 31; ++i) {
            la1tokens[i] = false;
        }
        if (jj_kind >= 0) {
            la1tokens[StarParser.jj_kind] = true;
            jj_kind = -1;
        }
        for (i = 0; i < 15; ++i) {
            if (jj_la1[i] != jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 31; ++i) {
            if (!la1tokens[i]) continue;
            jj_expentry = new int[1];
            StarParser.jj_expentry[0] = i;
            jj_expentries.addElement(jj_expentry);
        }
        int[][] exptokseq = new int[jj_expentries.size()][];
        for (int i2 = 0; i2 < jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])jj_expentries.elementAt(i2);
        }
        return new ParseException(token, exptokseq, StarParserConstants.tokenImage);
    }

    public static final void enable_tracing() {
    }

    public static final void disable_tracing() {
    }

    static {
        prevLine = -1;
        symbolTinyAbsTypeName = "EDU.bmrb.starlibj.TinyAbsDataValueNode";
        symbolDataValueNode = "EDU.bmrb.starlibj.DataValueNode";
        symbolDataNameNode = "EDU.bmrb.starlibj.DataNameNode";
        symbolDataItemNode = "EDU.bmrb.starlibj.DataItemNode";
        symbolBlockNode = "EDU.bmrb.starlibj.BlockNode";
        symbolSaveFrameNode = "EDU.bmrb.starlibj.SaveFrameNode";
        symbolHomemadeStringBuffer = "EDU.bmrb.starlibj.HomemadeStringBuffer";
        symbolLoopTableNode = "EDU.bmrb.starlibj.LoopTableNode";
        symbolDataLoopNameListNode = "EDU.bmrb.starlibj.DataLoopNameListNode";
        lineDelim = '\u0001';
        fieldDelim = (char)2;
        singleMarker = (char)21;
        doubleMarker = (char)22;
        semicolonMarker = (char)23;
        framecodeMarker = (char)24;
        nonMarker = (char)25;
        jj_initialized_once = false;
        jj_la1 = new int[15];
        jj_la1_0 = new int[]{36864, 36864, 329728, 329728, 39452672, 264192, 264192, 39452672, 8192, 39452672, 8192, 39452672, 39460864, 2048, 262144};
        jj_expentries = new Vector();
        jj_kind = -1;
    }
}

