/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.starlibj;

import EDU.bmrb.starlibj.BlockNode;
import EDU.bmrb.starlibj.DataItemNode;
import EDU.bmrb.starlibj.DataLoopNameListNode;
import EDU.bmrb.starlibj.DataLoopNode;
import EDU.bmrb.starlibj.DataNameNode;
import EDU.bmrb.starlibj.DataValueNode;
import EDU.bmrb.starlibj.InternalException;
import EDU.bmrb.starlibj.LoopNameListNode;
import EDU.bmrb.starlibj.LoopRowNode;
import EDU.bmrb.starlibj.LoopTableNode;
import EDU.bmrb.starlibj.SaveFrameNode;
import EDU.bmrb.starlibj.SkipTextHandler;
import EDU.bmrb.starlibj.StarFileNode;
import EDU.bmrb.starlibj.StarNode;
import EDU.bmrb.starlibj.StarValidity;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;

public class StarUnparser
implements Cloneable {
    protected int indentSize;
    protected int extraColumnSpaces;
    protected boolean formatting;
    protected PrintWriter oWrit;
    protected SkipTextHandler skips;
    protected int prevCheckLineNum;
    protected boolean suppressStops;

    public StarUnparser(OutputStream out) {
        this.oWrit = new PrintWriter(out);
        this.indentSize = 4;
        this.formatting = true;
        this.suppressStops = false;
        this.extraColumnSpaces = 2;
    }

    public StarUnparser(OutputStream out, boolean autoFlush) {
        this.oWrit = new PrintWriter(out, autoFlush);
        this.indentSize = 4;
        this.formatting = true;
        this.suppressStops = false;
        this.extraColumnSpaces = 2;
    }

    protected void finalize() {
        this.oWrit.flush();
    }

    public StarUnparser(StarUnparser copyMe) {
        this.indentSize = copyMe.indentSize;
        this.formatting = copyMe.formatting;
        this.oWrit = copyMe.oWrit;
        this.extraColumnSpaces = copyMe.extraColumnSpaces;
    }

    public StarUnparser clone(StarUnparser copyMe) {
        return new StarUnparser(copyMe);
    }

    public void writeSkipped(int thisLineNum) {
        StringBuffer writeMe = new StringBuffer();
        if (this.skips != null) {
            boolean firstTime = true;
            while (firstTime || writeMe.length() > 0) {
                firstTime = false;
                writeMe = new StringBuffer();
                int skipLineNum = this.skips.getSkipTextBetween(this.prevCheckLineNum + 1, thisLineNum, writeMe);
                if (writeMe.length() > 0) {
                    this.oWrit.println();
                    this.oWrit.print(writeMe);
                    this.prevCheckLineNum = skipLineNum;
                    continue;
                }
                if (thisLineNum <= 0) continue;
                this.prevCheckLineNum = thisLineNum;
            }
        }
    }

    public void writeOut(StarNode node, int indentLvl) {
        this.writeOut(node, indentLvl, -1, false);
    }

    protected void writeOut(StarNode node, int indentLvl, int longest) {
        this.writeOut(node, indentLvl, longest, false);
    }

    protected void writeOut(StarNode node, int indentLvl, boolean internal) {
        this.writeOut(node, indentLvl, -1, internal);
    }

    protected void writeOut(StarNode node, int indentLvl, int longest, boolean internal) {
        if (!internal) {
            this.skips = node.mySkips();
            this.prevCheckLineNum = node.getLineNum();
        }
        try {
            if (Class.forName(StarValidity.clsNameDataValueNode).isInstance(node)) {
                this.writeDataValueNode((DataValueNode)node, indentLvl, -99, -99);
            } else if (Class.forName(StarValidity.clsNameDataNameNode).isInstance(node)) {
                this.writeDataNameNode((DataNameNode)node, indentLvl);
            } else if (Class.forName(StarValidity.clsNameLoopRowNode).isInstance(node)) {
                this.writeLoopRowNode((LoopRowNode)node, indentLvl, null, null);
            } else if (Class.forName(StarValidity.clsNameLoopTableNode).isInstance(node)) {
                this.writeLoopTableNode((LoopTableNode)node, indentLvl);
            } else if (Class.forName(StarValidity.clsNameDataItemNode).isInstance(node)) {
                this.writeDataItemNode((DataItemNode)node, indentLvl, longest);
            } else if (Class.forName(StarValidity.clsNameLoopNameListNode).isInstance(node)) {
                this.writeLoopNameListNode((LoopNameListNode)node, indentLvl);
            } else if (Class.forName(StarValidity.clsNameDataLoopNameListNode).isInstance(node)) {
                this.writeDataLoopNameListNode((DataLoopNameListNode)node, indentLvl);
            } else if (Class.forName(StarValidity.clsNameDataLoopNode).isInstance(node)) {
                this.writeDataLoopNode((DataLoopNode)node, indentLvl);
            } else if (Class.forName(StarValidity.clsNameSaveFrameNode).isInstance(node)) {
                this.writeSaveFrameNode((SaveFrameNode)node, indentLvl);
            } else if (Class.forName(StarValidity.clsNameBlockNode).isInstance(node)) {
                this.writeBlockNode((BlockNode)node, indentLvl);
            } else if (Class.forName(StarValidity.clsNameStarFileNode).isInstance(node)) {
                this.writeStarFileNode((StarFileNode)node, indentLvl);
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        this.oWrit.flush();
    }

    protected void writeIndent(int indentLvl) {
        if (this.formatting) {
            int numChars = indentLvl * this.indentSize;
            for (int i = 1; i <= numChars; ++i) {
                this.oWrit.print(' ');
            }
        }
    }

    protected void writePreComment(String cmt, int indentLvl) {
        if (cmt != null && cmt.length() > 0) {
            if (this.formatting) {
                this.writeIndent(indentLvl);
            }
            for (int idx = 0; idx < cmt.length(); ++idx) {
                char ch = cmt.charAt(idx);
                this.oWrit.print(ch);
                if (Character.getType(ch) != 13 || !this.formatting) continue;
                this.writeIndent(indentLvl);
            }
        }
    }

    protected void writeDataValueNode(DataValueNode node, int indentLvl, int preSize, int postSize) {
        this.writeDataValueNode(node, indentLvl, preSize, postSize, false);
    }

    protected void writeDataValueNode(DataValueNode node, int indentLvl, int preSize, int postSize, boolean nonQuotedFlag) {
        if (!this.formatting || preSize == -99 || postSize == -99) {
            if (node.getDelimType() == DataValueNode.NON) {
                this.oWrit.print(node.getValue());
                this.oWrit.print(' ');
            } else if (node.getDelimType() == DataValueNode.SINGLE) {
                this.oWrit.print("'" + node.getValue() + "'");
                this.oWrit.print(' ');
            } else if (node.getDelimType() == DataValueNode.DOUBLE) {
                this.oWrit.print("\"" + node.getValue() + "\"");
                this.oWrit.print(' ');
            } else if (node.getDelimType() == DataValueNode.FRAMECODE) {
                this.oWrit.print("$" + node.getValue());
                this.oWrit.print(' ');
            } else if (node.getDelimType() == DataValueNode.SEMICOLON) {
                this.oWrit.println();
                this.oWrit.println(";");
                char firstChar = node.getValue().charAt(0);
                String thisVal = node.getValue();
                String printVal = "";
                boolean afterEoln = true;
                for (int idx = 0; idx < thisVal.length(); ++idx) {
                    char ch = thisVal.charAt(idx);
                    if (afterEoln && ch == ';') {
                        printVal = printVal + ' ';
                    }
                    afterEoln = ch == '\n' || ch == '\r';
                    printVal = printVal + ch;
                }
                this.oWrit.print(printVal);
                char lastChar = node.getValue().charAt(node.getValue().length() - 1);
                if (lastChar != '\n' && lastChar != '\r') {
                    this.oWrit.println();
                }
                this.oWrit.println(";");
            }
        } else {
            int i;
            this.writeSkipped(node.getLineNum());
            this.writePreComment(node.getPreComment(), indentLvl);
            String thisVal = node.getValue();
            if (node.getDelimType() == DataValueNode.NON) {
                if (!nonQuotedFlag) {
                    this.oWrit.print(' ');
                }
                if (postSize >= 0 && this.isItNumeric(thisVal)) {
                    String tmpStr = "";
                    int dotIdx = thisVal.indexOf(46);
                    if (dotIdx == -1) {
                        dotIdx = thisVal.length();
                    }
                    for (i = 0; i < preSize - dotIdx; ++i) {
                        this.oWrit.print(' ');
                    }
                    this.oWrit.print(thisVal.substring(0, dotIdx));
                    if (dotIdx < thisVal.length()) {
                        this.oWrit.print(thisVal.substring(dotIdx, thisVal.length()));
                        for (i = thisVal.length() - dotIdx; i < postSize + 1; ++i) {
                            this.oWrit.print(' ');
                        }
                    } else {
                        if (postSize >= 0) {
                            for (i = 1; i <= postSize; ++i) {
                                this.oWrit.print(' ');
                            }
                        }
                        if (postSize >= 1) {
                            this.oWrit.print(' ');
                        }
                    }
                } else {
                    this.oWrit.print(thisVal);
                    for (i = thisVal.length(); i < preSize; ++i) {
                        this.oWrit.print(' ');
                    }
                    if (postSize >= 0) {
                        for (i = 0; i < postSize; ++i) {
                            this.oWrit.print(' ');
                        }
                    }
                    if (postSize >= 1) {
                        this.oWrit.print(' ');
                    }
                }
            } else if (node.getDelimType() == DataValueNode.SINGLE) {
                this.oWrit.print("'" + thisVal + "'");
                for (i = thisVal.length() + 1; i < preSize; ++i) {
                    this.oWrit.print(' ');
                }
            } else if (node.getDelimType() == DataValueNode.DOUBLE) {
                this.oWrit.print("\"" + thisVal + "\"");
                for (i = thisVal.length() + 1; i < preSize; ++i) {
                    this.oWrit.print(' ');
                }
            } else if (node.getDelimType() == DataValueNode.SEMICOLON) {
                this.oWrit.println();
                this.oWrit.println(';');
                String printVal = "";
                boolean afterEoln = true;
                for (int idx = 0; idx < thisVal.length(); ++idx) {
                    char ch = thisVal.charAt(idx);
                    if (afterEoln && ch == ';') {
                        printVal = printVal + ' ';
                    }
                    afterEoln = ch == '\n' || ch == '\r';
                    printVal = printVal + ch;
                }
                this.oWrit.print(printVal);
                if (thisVal.charAt(thisVal.length() - 1) != '\n' && thisVal.charAt(thisVal.length() - 1) != '\r') {
                    this.oWrit.println();
                }
                this.oWrit.println(';');
            } else if (node.getDelimType() == DataValueNode.FRAMECODE) {
                this.oWrit.print("$" + thisVal);
                for (i = thisVal.length(); i < preSize; ++i) {
                    this.oWrit.print(' ');
                }
            }
            if (node.getDelimType() != DataValueNode.NON && postSize >= 0) {
                for (i = 1; i <= preSize; ++i) {
                    this.oWrit.print(' ');
                }
                if (postSize >= 1) {
                    this.oWrit.print(' ');
                }
            }
        }
    }

    protected void writeDataNameNode(DataNameNode node, int indentLvl) {
        if (!this.formatting) {
            this.oWrit.print(node.getLabel() + " ");
        } else {
            this.writeSkipped(node.getLineNum());
            this.writePreComment(node.getPreComment(), indentLvl);
            this.writeIndent(indentLvl);
            this.oWrit.print(node.getLabel() + " ");
        }
    }

    protected void writeDataItemNode(DataItemNode node, int indentLvl, int longest) {
        if (!this.formatting) {
            this.writeDataNameNode(node.getNameNode(), 0);
            this.writeDataValueNode(node.getValueNode(), 0, -99, -99);
            this.oWrit.println();
        } else {
            this.writeSkipped(node.getLineNum());
            this.writePreComment(node.getPreComment(), indentLvl);
            this.writeDataNameNode(node.getNameNode(), indentLvl);
            for (int i = node.getLabel().length(); i < longest; ++i) {
                this.oWrit.print(' ');
            }
            if (node.getValueNode().getDelimType() == DataValueNode.NON) {
                this.oWrit.print(' ');
            }
            this.writeDataValueNode(node.getValueNode(), indentLvl, -99, -99);
            this.oWrit.println();
        }
    }

    protected void writeDataLoopNode(DataLoopNode node, int indentLvl) {
        int ind;
        if (this.formatting) {
            this.writeSkipped(node.getLineNum());
            this.writePreComment(node.getPreComment(), indentLvl);
            ind = indentLvl + 1;
        } else {
            ind = 0;
        }
        this.writeDataLoopNameListNode(node.getNames(), indentLvl);
        this.writeLoopTableNode(node.getVals(), ind);
        this.oWrit.println();
    }

    protected void writeDataLoopNameListNode(DataLoopNameListNode node, int indentLvl) {
        this.writeSkipped(node.getLineNum());
        this.writePreComment(node.getPreComment(), indentLvl);
        this.oWrit.println();
        for (int i = 0; i < node.size(); ++i) {
            this.writeLoopNameListNode(node.elementAt(i), indentLvl + i);
        }
    }

    protected void writeLoopNameListNode(LoopNameListNode node, int indentLvl) {
        this.writeSkipped(node.getLineNum());
        this.writePreComment(node.getPreComment(), indentLvl);
        this.writeIndent(indentLvl);
        this.oWrit.println("loop_");
        for (int i = 0; i < node.size(); ++i) {
            this.writeDataNameNode(node.elementAt(i), indentLvl + 1);
            this.oWrit.println();
            if (!node.elementAt(i).getLabel().equals("_Saveframe_category")) continue;
            this.oWrit.println();
        }
    }

    protected void writeLoopTableNode(LoopTableNode node, int indentLvl) {
        try {
            if (!this.formatting) {
                for (int i = 0; i < node.size(); ++i) {
                    this.writeLoopRowNode(node.elementAt(i), 0, null, null);
                    this.oWrit.println();
                }
                if (node.getParent() != null && Class.forName(StarValidity.pkgName() + ".DataLoopNode").isInstance(node.getParent())) {
                    if (!this.suppressStops) {
                        this.oWrit.println("stop_");
                    }
                } else {
                    this.oWrit.println("stop_");
                }
            } else {
                Vector preSizes = new Vector();
                Vector postSizes = new Vector();
                Vector nonQuotedFlags = new Vector();
                this.writeSkipped(node.getLineNum());
                this.writePreComment(node.getPreComment(), node.getIndentFlag() ? indentLvl : 0);
                node.calcPrintSizes(preSizes, postSizes, nonQuotedFlags);
                for (int rowIdx = 0; rowIdx < node.size(); ++rowIdx) {
                    if (rowIdx % node.getRowsPerLine() == 0 || rowIdx == 0) {
                        this.oWrit.println();
                        this.writeIndent(node.getIndentFlag() ? indentLvl : 0);
                    } else {
                        this.oWrit.print(" ");
                    }
                    this.writeLoopRowNode(node.elementAt(rowIdx), indentLvl, preSizes, postSizes, nonQuotedFlags);
                }
                this.oWrit.println();
                this.writeIndent(indentLvl > 0 && node.getIndentFlag() ? indentLvl - 1 : 0);
                if (node.getParent() != null && Class.forName(StarValidity.pkgName() + ".DataLoopNode").isInstance(node.getParent())) {
                    if (!this.suppressStops) {
                        this.oWrit.println("stop_");
                    }
                } else {
                    this.oWrit.println("stop_");
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new InternalException(e.getMessage());
        }
    }

    protected void writeLoopRowNode(LoopRowNode node, int indentLvl, Vector preSizes, Vector postSizes) {
        this.writeLoopRowNode(node, indentLvl, preSizes, postSizes, null);
    }

    protected void writeLoopRowNode(LoopRowNode node, int indentLvl, Vector preSizes, Vector postSizes, Vector nonQuotedFlags) {
        if (!this.formatting || preSizes == null || postSizes == null) {
            for (int i = 0; i < node.size(); ++i) {
                this.writeDataValueNode(node.elementAt(i), 0, -99, -99);
            }
        } else {
            this.writeSkipped(node.getLineNum());
            this.writePreComment(node.getPreComment(), indentLvl);
            for (int idx = 0; idx < node.size(); ++idx) {
                this.writeDataValueNode(node.elementAt(idx), indentLvl, (Integer)preSizes.elementAt(idx), (Integer)postSizes.elementAt(idx), (Boolean)nonQuotedFlags.elementAt(idx));
                if (node.getParent() != null && ((LoopTableNode)node.getParent()).getTabFlag()) {
                    this.oWrit.print(" ");
                    for (int i = 0; i < this.extraColumnSpaces; ++i) {
                        this.oWrit.print(' ');
                    }
                    continue;
                }
                this.oWrit.println();
                this.writeIndent(indentLvl);
            }
        }
        if (node.getInnerLoop() != null) {
            this.writeLoopTableNode(node.getInnerLoop(), this.formatting ? indentLvl + 1 : 0);
        }
    }

    protected void writeSaveFrameNode(SaveFrameNode node, int indentLvl) {
        int i;
        int longestValLength = -1;
        if (indentLvl > 0) {
            --indentLvl;
        }
        this.writeSkipped(node.getLineNum());
        this.writePreComment(node.getPreComment(), indentLvl);
        if (this.formatting) {
            this.writeIndent(indentLvl);
        }
        this.oWrit.println();
        this.oWrit.println(node.getLabel());
        if (this.formatting) {
            try {
                for (i = 0; i < node.size(); ++i) {
                    int len;
                    if (!Class.forName(StarValidity.clsNameDataItemNode).isInstance(node.elementAt(i)) || (len = ((DataItemNode)node.elementAt(i)).getLabel().length()) <= longestValLength) continue;
                    longestValLength = len;
                }
            }
            catch (ClassNotFoundException e) {
                throw new InternalException(e.getMessage());
            }
        }
        for (i = 0; i < node.size(); ++i) {
            this.writeOut(node.elementAt(i), indentLvl + (this.formatting ? 1 : 0), longestValLength, true);
        }
        if (this.formatting) {
            this.writeIndent(indentLvl);
        }
        this.oWrit.println("save_");
        this.oWrit.println();
    }

    protected void writeBlockNode(BlockNode node, int indentLvl) {
        int i;
        int longestValLength = -1;
        this.writeSkipped(node.getLineNum());
        this.writePreComment(node.getPreComment(), indentLvl);
        this.oWrit.println(node.getLabel());
        this.oWrit.println();
        if (this.formatting) {
            try {
                for (i = 0; i < node.size(); ++i) {
                    int len;
                    if (!Class.forName(StarValidity.clsNameDataItemNode).isInstance(node.elementAt(i)) || (len = ((DataItemNode)node.elementAt(i)).getLabel().length()) <= longestValLength) continue;
                    longestValLength = len;
                }
            }
            catch (ClassNotFoundException e) {
                throw new InternalException(e.getMessage());
            }
        }
        for (i = 0; i < node.size(); ++i) {
            this.writeOut(node.elementAt(i), indentLvl + (this.formatting ? 1 : 0), longestValLength, true);
        }
        this.oWrit.println();
    }

    protected void writeStarFileNode(StarFileNode node, int indentLvl) {
        this.writeSkipped(node.getLineNum());
        this.writePreComment(node.getPreComment(), indentLvl);
        for (int i = 0; i < node.size(); ++i) {
            this.writeOut((StarNode)node.elementAt(i), indentLvl, true);
        }
        this.oWrit.println();
    }

    public void setIndentSize(int s) {
        this.indentSize = s;
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    public void setExtraColumnSpaces(int numExtra) {
        this.extraColumnSpaces = numExtra;
    }

    public int getExtraColumnSpaces() {
        return this.extraColumnSpaces;
    }

    public void setFormatting(boolean isOn) {
        this.formatting = isOn;
    }

    public boolean getFormatting() {
        return this.formatting;
    }

    public void setSuppressStops(boolean isOn) {
        this.suppressStops = isOn;
    }

    public boolean getSuppressStops() {
        return this.suppressStops;
    }

    protected boolean isItNumeric(String str) {
        int idx;
        for (idx = 0; idx < str.length() && Character.isWhitespace(str.charAt(idx)); ++idx) {
        }
        if (idx < str.length() && (str.charAt(idx) == '+' || str.charAt(idx) == '-')) {
            ++idx;
        }
        while (idx < str.length() && Character.isDigit(str.charAt(idx))) {
            ++idx;
        }
        if (idx < str.length() && str.charAt(idx) == '.') {
            ++idx;
        }
        while (idx < str.length() && Character.isDigit(str.charAt(idx))) {
            ++idx;
        }
        while (idx < str.length() && Character.isWhitespace(str.charAt(idx))) {
            ++idx;
        }
        return idx == str.length();
    }
}

