/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.valdb;

import EDU.bmrb.lib.CreateDBSchema;
import EDU.bmrb.lib.ErrorList;
import EDU.bmrb.nmrstar.utils.StarToDb;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class LoadRefData {
    public static final String DEF_PROPFILE = "validator.properties";
    public static final String DRIVER_KEY = "DB.Driver";
    public static final String DBURL_KEY = "DB.Url";
    public static final String DBUSER_KEY = "DB.User";
    public static final String DBPASSWD_KEY = "DB.Password";
    public static final String SCHEMA_KEY = "Refdata.schema";
    public static final String CONSTRAINTS_KEY = "Refdata.constraints";

    public static void load(Properties props, BufferedReader in, PrintWriter out, ErrorList errs) throws ClassNotFoundException, SQLException, IOException {
        String drv = props.getProperty(DRIVER_KEY);
        if (drv == null) {
            throw new NullPointerException("Error in properties file: missing db driver");
        }
        String url = props.getProperty(DBURL_KEY);
        if (url == null) {
            throw new NullPointerException("Error in properties file: missing JDBC URL");
        }
        Class.forName(drv);
        Connection conn = DriverManager.getConnection(url, props.getProperty(DBUSER_KEY), props.getProperty(DBPASSWD_KEY));
        conn.setAutoCommit(false);
        CreateDBSchema.runScript(conn, props.getProperty(SCHEMA_KEY), out);
        StarToDb ldr = new StarToDb(conn, out, errs);
        ldr.load(in);
        CreateDBSchema.runScript(conn, props.getProperty(CONSTRAINTS_KEY), out);
        conn.commit();
        conn.close();
    }

    public static void usage() {
        System.out.print("Usage: java EDU.bmrb.valdb.LoadRefData [-h] [-c FILE] ");
        System.out.println("[-i FILE] [-o FILE]");
        System.out.print("-c FILE: use config FILE (default: ");
        System.out.print(System.getProperty("user.home"));
        System.out.print(File.separatorChar);
        System.out.print(DEF_PROPFILE);
        System.out.println(')');
        System.out.println("-i FILE: input file (default: stdin)");
        System.out.println("-o FILE: print SQL statements to FILE (use dash '-' for stdout)");
        System.out.println("-h: print usage summary");
    }

    public static void main(String[] args) {
        int opt;
        Getopt g = new Getopt("EDU.bmrb.valdb.LoadRefData", args, "hc:i:o:");
        String conffile = null;
        String infile = null;
        String outfile = null;
        block7: while ((opt = g.getopt()) != -1) {
            switch (opt) {
                case 99: {
                    conffile = g.getOptarg();
                    continue block7;
                }
                case 105: {
                    infile = g.getOptarg();
                    continue block7;
                }
                case 111: {
                    outfile = g.getOptarg();
                    continue block7;
                }
            }
            LoadRefData.usage();
            return;
        }
        if (conffile == null) {
            conffile = System.getProperty("user.home") + File.separator + DEF_PROPFILE;
        }
        try {
            Properties props = new Properties();
            FileInputStream pin = new FileInputStream(conffile);
            props.load(pin);
            pin.close();
            BufferedReader in = infile == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(infile));
            PrintWriter out = null;
            if (outfile != null) {
                out = outfile.equals("-") ? new PrintWriter(System.out) : new PrintWriter(new FileOutputStream(outfile));
            }
            LoadRefData.load(props, in, out, null);
            if (out != null) {
                out.close();
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

