/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.valdb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MemDB {
    private static final boolean DEBUG = false;
    private static final String DB_DRIVER = "org.hsqldb.jdbcDriver";
    private static final String DB_URL = "jdbc:hsqldb:mem:temp";
    private static final String DB_USER = "sa";
    private Connection fConn = null;
    private PreparedStatement fLastId = null;

    public void connect() throws ClassNotFoundException, SQLException {
        Class.forName(DB_DRIVER);
        this.fConn = DriverManager.getConnection(DB_URL, DB_USER, "");
        this.fConn.setAutoCommit(false);
    }

    public void disconnect() throws SQLException {
        if (this.fLastId != null) {
            this.fLastId.close();
        }
        this.fConn.commit();
        this.fConn.close();
    }

    public Connection getConnection() throws SQLException {
        return this.fConn;
    }

    public Statement getQuery() throws SQLException {
        return this.fConn.createStatement(1003, 1007);
    }

    public PreparedStatement prepareQuery(String sql) throws SQLException {
        return this.fConn.prepareStatement(sql, 1003, 1007);
    }

    public PreparedStatement prepareQuery(StringBuffer sql) throws SQLException {
        return this.fConn.prepareStatement(sql.toString(), 1003, 1007);
    }

    public Statement getStatement() throws SQLException {
        return this.fConn.createStatement();
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.fConn.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(StringBuffer sql) throws SQLException {
        return this.fConn.prepareStatement(sql.toString());
    }

    public void createTables() throws SQLException {
        Statement stat = this.fConn.createStatement();
        stat.executeUpdate("CREATE TABLE NOMENCLATURES (ID INTEGER IDENTITY PRIMARY KEY,NAME VARCHAR(127))");
        stat.executeUpdate("CREATE TABLE RESTYPES (ID INTEGER IDENTITY PRIMARY KEY,NAME VARCHAR(127))");
        stat.executeUpdate("CREATE TABLE RESIDUES (ID INTEGER IDENTITY PRIMARY KEY,TYPEID INTEGER NOT NULL,LABEL VARCHAR(5) NOT NULL,CODE VARCHAR(5) NOT NULL,NAME VARCHAR(127),NOMID INTEGER NOT NULL,FOREIGN KEY(TYPEID) REFERENCES RESTYPES(ID),FOREIGN KEY(NOMID) REFERENCES NOMENCLATURES(ID))");
        stat.executeUpdate("CREATE TABLE ATOMS (ID INTEGER IDENTITY PRIMARY KEY,RESID INTEGER NOT NULL,NAME VARCHAR(5) NOT NULL,TYPE VARCHAR(5),PSEUDO VARCHAR(1),NOMID INTEGER NOT NULL,FOREIGN KEY(RESID) REFERENCES RESIDUES(ID),FOREIGN KEY(NOMID) REFERENCES NOMENCLATURES(ID))");
        stat.executeUpdate("CREATE TABLE CHEMSHIFTS(ATOMID INTEGER NOT NULL,SHIFTAVG DOUBLE NOT NULL,SHIFTSTD DOUBLE NOT NULL,SHIFTMIN DOUBLE NOT NULL,SHIFTMAX DOUBLE NOT NULL,UNIQUE(ATOMID),FOREIGN KEY(ATOMID) REFERENCES ATOMS(ID))");
        stat.executeUpdate("CREATE TABLE ISOTOPES(TYPE VARCHAR(5) NOT NULL,ISOTOPE INTEGER NOT NULL)");
        stat.executeUpdate("CREATE TABLE AMBICODES(ATOMID INTEGER NOT NULL,AMBICODE INTEGER NOT NULL)");
        stat.executeUpdate("CREATE TABLE PSEUDOS(ID INTEGER NOT NULL,ATOMID INTEGER NOT NULL)");
        stat.executeUpdate("CREATE TABLE ATOMNOM(BMRBID INTEGER NOT NULL,ATOMID INTEGER NOT NULL)");
        stat.executeUpdate("CREATE TABLE AMBIREPLACE(RESID INTEGER NOT NULL,ATOMID1 INTEGER NOT NULL,ATOMID2 INTEGER NOT NULL,ORGCODE INTEGER,NEWCODE INTEGER NOT NULL)");
        stat.executeUpdate("CREATE TABLE STAR3TO2(TYPEID INTEGER NOT NULL,RESLABEL VARCHAR(5) NOT NULL,ATOM30 VARCHAR(5) NOT NULL,ATOM21 VARCHAR(5) NOT NULL)");
        stat.executeUpdate("CREATE TABLE METHYLENES(TYPEID INTEGER NOT NULL,RESLABEL VARCHAR(5) NOT NULL,ATOM1 VARCHAR(5) NOT NULL,ATOM2 VARCHAR(5) NOT NULL,NEW1 VARCHAR(5) NOT NULL,NEW2 VARCHAR(5) NOT NULL)");
        this.fConn.commit();
    }

    public int lastId() throws SQLException {
        if (this.fLastId == null) {
            this.fLastId = this.prepareStatement("CALL IDENTITY()");
        }
        ResultSet rs = this.fLastId.executeQuery();
        rs.next();
        int rc = rs.getInt(1);
        rs.close();
        return rc;
    }

    public static void main(String[] args) {
        try {
            MemDB d = new MemDB();
            d.connect();
            d.createTables();
            d.disconnect();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }
}

