/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.valdb;

import EDU.bmrb.valdb.CsvReader;
import EDU.bmrb.valdb.MemDB;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class Pseudos {
    private static final boolean DEBUG = true;

    public static void flagPseudoAtoms(CsvReader src, MemDB tgt) throws SQLException {
        PreparedStatement nomid_query = tgt.prepareQuery("SELECT ID FROM NOMENCLATURES WHERE NAME=?");
        int nomid = -1;
        PreparedStatement typeid_query = tgt.prepareQuery("SELECT ID FROM RESTYPES WHERE NAME=?");
        int typeid = -1;
        PreparedStatement resid_query = tgt.prepareQuery("SELECT ID FROM RESIDUES WHERE TYPEID=? AND LABEL=?");
        int resid = -1;
        PreparedStatement atomid_query = tgt.prepareQuery("SELECT ID FROM ATOMS WHERE RESID=? AND NAME=? AND NOMID=?");
        ResultSet rs1 = null;
        PreparedStatement pa_istat = tgt.prepareStatement("INSERT INTO ATOMS (RESID,NAME,PSEUDO,NOMID) VALUES (?,?,'Y',?)");
        PreparedStatement pa_ustat = tgt.prepareStatement("UPDATE ATOMS SET PSEUDO='Y' WHERE ID=?");
        Statement query = src.getQuery();
        ResultSet rs = query.executeQuery("SELECT RESTYPE,RESLABEL,PSEUDO,NOMENCLATURE FROM pseudoexp");
        while (rs.next()) {
            nomid_query.setString(1, rs.getString(4));
            rs1 = nomid_query.executeQuery();
            if (rs1.next()) {
                nomid = rs1.getInt(1);
                if (rs1.wasNull()) {
                    nomid = -1;
                }
            }
            if (nomid < 0) {
                System.err.println("No record for nomenclature: " + rs.getString(4));
                continue;
            }
            typeid_query.setString(1, rs.getString(1));
            rs1 = typeid_query.executeQuery();
            if (rs1.next()) {
                typeid = rs1.getInt(1);
                if (rs1.wasNull()) {
                    typeid = -1;
                }
            }
            if (typeid < 0) {
                System.err.println("No record for residue type: " + rs.getString(1));
                continue;
            }
            resid_query.setInt(1, typeid);
            resid_query.setString(2, rs.getString(2));
            rs1 = resid_query.executeQuery();
            if (rs1.next()) {
                resid = rs1.getInt(1);
                if (rs1.wasNull()) {
                    resid = -1;
                }
            }
            if (resid < 0) {
                System.err.println("No record for residue: " + rs.getString(1));
                continue;
            }
            atomid_query.setInt(1, resid);
            atomid_query.setString(2, rs.getString(3));
            atomid_query.setInt(3, nomid);
            rs1 = atomid_query.executeQuery();
            if (rs1.next()) {
                pa_ustat.setInt(1, rs1.getInt(1));
                System.err.println(pa_ustat);
                pa_ustat.executeUpdate();
                continue;
            }
            pa_istat.setInt(1, resid);
            pa_istat.setString(2, rs.getString(3));
            pa_istat.setInt(3, nomid);
            System.err.println(pa_istat);
            pa_istat.executeUpdate();
        }
        pa_istat.getConnection().commit();
        pa_ustat.getConnection().commit();
        pa_istat.close();
        pa_ustat.close();
        if (rs1 != null) {
            rs1.close();
        }
        rs.close();
        atomid_query.close();
        resid_query.close();
        typeid_query.close();
        nomid_query.close();
        query.close();
    }

    public static void expandPseudoAtoms(CsvReader src, MemDB tgt) throws SQLException {
        PreparedStatement nomid_query = tgt.prepareQuery("SELECT ID FROM NOMENCLATURES WHERE NAME=?");
        int nomid = -1;
        PreparedStatement typeid_query = tgt.prepareQuery("SELECT ID FROM RESTYPES WHERE NAME=?");
        int typeid = -1;
        PreparedStatement resid_query = tgt.prepareQuery("SELECT ID FROM RESIDUES WHERE TYPEID=? AND LABEL=?");
        int resid = -1;
        PreparedStatement atomid_query = tgt.prepareQuery("SELECT ID FROM ATOMS WHERE RESID=? AND NAME=? AND NOMID=?");
        int atomid = -1;
        int pseudoid = -1;
        ResultSet rs1 = null;
        PreparedStatement istat = tgt.prepareStatement("INSERT INTO ATOMS (RESID,NAME,PSEUDO,NOMID) VALUES (?,?,'N',?)");
        PreparedStatement pstat = tgt.prepareStatement("INSERT INTO PSEUDOS (ID,ATOMID) VALUES (?,?)");
        Object last = null;
        Statement query = src.getQuery();
        ResultSet rs = query.executeQuery("SELECT RESTYPE,RESLABEL,PSEUDO,NOMENCLATURE,ATOM FROM pseudoexp");
        while (rs.next()) {
            nomid_query.setString(1, rs.getString(4));
            rs1 = nomid_query.executeQuery();
            if (rs1.next()) {
                nomid = rs1.getInt(1);
                if (rs1.wasNull()) {
                    nomid = -1;
                }
            }
            if (nomid < 0) {
                System.err.println("No record for nomenclature: " + rs.getString(4));
                continue;
            }
            typeid_query.setString(1, rs.getString(1));
            rs1 = typeid_query.executeQuery();
            if (rs1.next()) {
                typeid = rs1.getInt(1);
                if (rs1.wasNull()) {
                    typeid = -1;
                }
            }
            if (typeid < 0) {
                System.err.println("No record for residue type: " + rs.getString(1));
                continue;
            }
            resid_query.setInt(1, typeid);
            resid_query.setString(2, rs.getString(2));
            rs1 = resid_query.executeQuery();
            if (rs1.next()) {
                resid = rs1.getInt(1);
                if (rs1.wasNull()) {
                    resid = -1;
                }
            }
            if (resid < 0) {
                System.err.println("No record for residue: " + rs.getString(1));
                continue;
            }
            atomid_query.setInt(1, resid);
            atomid_query.setString(2, rs.getString(3));
            atomid_query.setInt(3, nomid);
            rs1 = atomid_query.executeQuery();
            if (rs1.next()) {
                pseudoid = rs1.getInt(1);
                if (rs1.wasNull()) {
                    pseudoid = -1;
                }
            }
            if (pseudoid < 0) {
                System.err.println("No record for pseudoatom: " + rs.getString(1));
                continue;
            }
            atomid_query.setInt(1, resid);
            atomid_query.setString(2, rs.getString(5));
            atomid_query.setInt(3, nomid);
            rs1 = atomid_query.executeQuery();
            if (rs1.next()) {
                atomid = rs1.getInt(1);
            } else if (rs.getString(4).equals("BMRB")) {
                istat.setInt(1, resid);
                istat.setString(2, rs.getString(5));
                istat.setInt(3, nomid);
                System.err.println(istat);
                istat.executeUpdate();
                rs1 = atomid_query.executeQuery();
                rs1.next();
                atomid = rs1.getInt(1);
            } else {
                atomid = -1;
            }
            if (atomid < 0) continue;
            pstat.setInt(1, pseudoid);
            pstat.setInt(2, atomid);
            pstat.executeUpdate();
        }
        istat.getConnection().commit();
        pstat.getConnection().commit();
        istat.close();
        pstat.close();
        if (rs1 != null) {
            rs1.close();
        }
        rs.close();
        atomid_query.close();
        resid_query.close();
        typeid_query.close();
        nomid_query.close();
        query.close();
    }

    public static void addPseudoAtomMap(CsvReader src, MemDB tgt) throws SQLException {
        PreparedStatement pstat = tgt.prepareStatement("INSERT INTO ATOMNOM (BMRBID,ATOMID) VALUES (?,?)");
        PreparedStatement atomid_query = tgt.prepareQuery("SELECT a.ID,n.ID FROM ATOMS a,RESIDUES r,RESTYPES t,NOMENCLATURES n WHERE a.NAME=? AND r.LABEL=? AND t.NAME=? AND n.NAME=? AND r.TYPEID=t.ID AND a.RESID=r.ID AND a.NOMID=n.ID");
        int atomid = -1;
        int nomid = -1;
        ResultSet rs1 = null;
        Statement query = src.getQuery();
        ResultSet rs = query.executeQuery("SELECT RESTYPE,RESLABEL,NOMENCLATURE,ATOM,BMRBATOM FROM atommap");
        while (rs.next()) {
            atomid_query.setString(1, rs.getString(4));
            atomid_query.setString(2, rs.getString(2));
            atomid_query.setString(3, rs.getString(1));
            atomid_query.setString(4, rs.getString(3));
            rs1 = atomid_query.executeQuery();
            if (!rs1.next()) {
                System.err.print("No record for: ");
                System.err.print(rs.getString(1));
                System.err.print(", ");
                System.err.print(rs.getString(2));
                System.err.print(", ");
                System.err.print(rs.getString(3));
                System.err.print(", ");
                System.err.println(rs.getString(4));
                continue;
            }
            atomid = rs1.getInt(1);
            nomid = rs1.getInt(2);
            atomid_query.setString(1, rs.getString(5));
            atomid_query.setString(4, "BMRB");
            System.err.println(atomid_query);
            rs1 = atomid_query.executeQuery();
            if (!rs1.next()) {
                System.err.print("No record for: ");
                System.err.print(rs.getString(1));
                System.err.print(", ");
                System.err.print(rs.getString(2));
                System.err.print(", BMRB, ");
                System.err.print(rs.getString(4));
                System.err.print(", ");
                System.err.println(rs.getString(5));
                continue;
            }
            pstat.setInt(1, rs1.getInt(1));
            pstat.setInt(2, atomid);
            pstat.executeUpdate();
        }
        pstat.getConnection().commit();
        pstat.close();
        if (rs1 != null) {
            rs1.close();
        }
        rs.close();
        atomid_query.close();
        query.close();
    }

    public static void addMethylShifts(MemDB tgt) throws SQLException {
        PreparedStatement pstat = tgt.prepareStatement("INSERT INTO CHEMSHIFTS(ATOMID,SHIFTAVG,SHIFTSTD,SHIFTMIN,SHIFTMAX) VALUES (?,?,?,?,?)");
        PreparedStatement pquery = tgt.prepareQuery("SELECT ATOMID FROM PSEUDOS WHERE ID=?");
        ResultSet rs1 = null;
        Statement query = tgt.getQuery();
        ResultSet rs = query.executeQuery("SELECT s.ATOMID,s.SHIFTAVG,s.SHIFTSTD,s.SHIFTMIN,s.SHIFTMAX FROM CHEMSHIFTS s,ATOMS a WHERE a.PSEUDO='Y' AND s.ATOMID=a.ID");
        while (rs.next()) {
            pquery.setInt(1, rs.getInt(1));
            rs1 = pquery.executeQuery();
            while (rs1.next()) {
                pstat.setInt(1, rs1.getInt(1));
                pstat.setFloat(2, rs.getFloat(2));
                pstat.setFloat(3, rs.getFloat(3));
                pstat.setFloat(4, rs.getFloat(4));
                pstat.setFloat(5, rs.getFloat(5));
                pstat.executeUpdate();
            }
        }
        pstat.getConnection().commit();
        if (rs1 != null) {
            rs1.close();
        }
        pquery.close();
        rs.close();
        query.close();
    }
}

