/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator;

import EDU.bmrb.lib.CreateDBSchema;
import EDU.bmrb.nmrstar.utils.StarToDb;
import EDU.bmrb.stardb.AddDictionaryInfo;
import EDU.bmrb.stardb.LoadEntry;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.stardb.UnparseToStarlib;
import EDU.bmrb.starlibj.BlockNode;
import EDU.bmrb.starlibj.StarUnparser;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.functions.AddRowIndexes;
import EDU.bmrb.validator.functions.EditResidueLabels;
import EDU.bmrb.validator.functions.FixFramecodes;
import EDU.bmrb.validator.functions.InsertDataSetCount;
import EDU.bmrb.validator.functions.InsertEntryID;
import EDU.bmrb.validator.functions.InsertLocalIDs;
import EDU.bmrb.validator.functions.InsertResidueLoop;
import EDU.bmrb.validator.functions.InsertShiftReference;
import EDU.bmrb.validator.functions.InsertValues;
import EDU.bmrb.validator.functions.MarkFramecodeValues;
import EDU.bmrb.validator.functions.TrimAditDeposition;
import EDU.bmrb.validator.functions.TrimValues;
import EDU.bmrb.validator.functions.UpdateRelatedTags;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

public class ADITPostProcess {
    private static final boolean DEBUG = false;
    public static final String DICT_SCHEMA = "Dictionary.schema";
    public static final String DICT_CONSTR = "Dictionary.constraints";
    public static final String REFDB_SCHEMA = "Refdata.schema";
    public static final String REFDB_CONSTR = "Refdata.constraints";

    public static void usage() {
        System.out.print("Usage: java EDU.bmrb.validator.ADITPostProcess <-d FILE> ");
        System.out.println("<-r FILE> [-c FILE] [-i FILE] [-o FILE] [-l FILE] [-h]");
        System.out.println(" -d FILE: dictionary FILE");
        System.out.println(" -r FILE: reference data FILE");
        System.out.print(" -c FILE: config FILE, default: ~/");
        System.out.println("validator.properties");
        System.out.println(" -i FILE: input FILE, default: stdin");
        System.out.println(" -o FILE: output FILE, use dash for stdout");
        System.out.println(" -l FILE: log FILE, use dash for stdout");
        System.out.println(" -h: print this message and exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        boolean rc;
        PrintStream log;
        ErrorList errs;
        Stardb star;
        long now;
        block119: {
            block118: {
                block117: {
                    block116: {
                        block115: {
                            block114: {
                                block113: {
                                    block112: {
                                        long total = now = System.currentTimeMillis();
                                        star = null;
                                        errs = null;
                                        log = null;
                                        rc = true;
                                        try {
                                            try {
                                                String str;
                                                int opt;
                                                Getopt g = new Getopt("ADITPostProcess", args, "d:c:i:l:o:r:h");
                                                String dictfile = null;
                                                String reffile = null;
                                                String conffile = null;
                                                String infile = null;
                                                String outfile = null;
                                                String logfile = null;
                                                block12: while ((opt = g.getopt()) != -1) {
                                                    switch (opt) {
                                                        case 99: {
                                                            conffile = g.getOptarg();
                                                            continue block12;
                                                        }
                                                        case 100: {
                                                            dictfile = g.getOptarg();
                                                            continue block12;
                                                        }
                                                        case 105: {
                                                            infile = g.getOptarg();
                                                            continue block12;
                                                        }
                                                        case 108: {
                                                            logfile = g.getOptarg();
                                                            continue block12;
                                                        }
                                                        case 111: {
                                                            outfile = g.getOptarg();
                                                            continue block12;
                                                        }
                                                        case 114: {
                                                            reffile = g.getOptarg();
                                                            continue block12;
                                                        }
                                                    }
                                                    ADITPostProcess.usage();
                                                    Object var32_16 = null;
                                                    if (star != null) {
                                                        star.disconnect();
                                                    }
                                                    break block112;
                                                }
                                                if (dictfile == null) {
                                                    System.err.println("No dictionary");
                                                    ADITPostProcess.usage();
                                                    break block113;
                                                }
                                                if (reffile == null) {
                                                    System.err.println("No reference data");
                                                    ADITPostProcess.usage();
                                                    break block114;
                                                }
                                                Config cf = conffile == null ? new Config() : new Config(conffile);
                                                star = new Star_DB(cf.getProperties());
                                                errs = new ErrorList(true);
                                                star.connect(false);
                                                Connection conn = star.getConnection();
                                                if (logfile != null) {
                                                    log = logfile.equals("-") ? System.err : new PrintStream(new FileOutputStream(logfile, true));
                                                }
                                                if (log != null) {
                                                    log.println("DB open: " + (System.currentTimeMillis() - now));
                                                    now = System.currentTimeMillis();
                                                }
                                                if ((str = star.getProperty(DICT_SCHEMA)) == null) {
                                                    if (log != null) {
                                                        log.println("Error in properties file: no dictionary SQL script. Terminating");
                                                    }
                                                    System.err.println("Error in properties file: no dictionary SQL script");
                                                    break block115;
                                                }
                                                CreateDBSchema.runScript(conn, str, null);
                                                BufferedReader din = new BufferedReader(new FileReader(dictfile));
                                                StarToDb dl = new StarToDb(conn, null, errs);
                                                dl.load(din);
                                                din.close();
                                                din = null;
                                                dl = null;
                                                str = star.getProperty(DICT_CONSTR);
                                                if (str == null) {
                                                    if (log != null) {
                                                        log.println("Error in properties file: no dictionary SQL (constraints) script. Terminating");
                                                    }
                                                    System.err.println("Error in properties file: no dictionary (constraints) SQL script");
                                                    break block116;
                                                }
                                                CreateDBSchema.runScript(conn, str, null);
                                                if (log != null) {
                                                    log.println("Dictionary loaded: " + (System.currentTimeMillis() - now));
                                                    now = System.currentTimeMillis();
                                                }
                                                if ((str = star.getProperty(REFDB_SCHEMA)) == null) {
                                                    if (log != null) {
                                                        log.println("Error in properties file: no refdb SQL script. Terminating");
                                                    }
                                                    System.err.println("Error in properties file: no refdb SQL script");
                                                    break block117;
                                                }
                                                CreateDBSchema.runScript(conn, str, null);
                                                din = new BufferedReader(new FileReader(reffile));
                                                dl = new StarToDb(conn, null, errs);
                                                dl.load(din);
                                                din.close();
                                                din = null;
                                                dl = null;
                                                str = star.getProperty(REFDB_CONSTR);
                                                if (str == null) {
                                                    if (log != null) {
                                                        log.println("Error in properties file: no refdb SQL (constraints) script. Terminating");
                                                    }
                                                    System.err.println("Error in properties file: no refdb (constraints) SQL script");
                                                    break block118;
                                                }
                                                CreateDBSchema.runScript(conn, str, null);
                                                InputStreamReader in = infile == null ? new InputStreamReader(System.in, "ISO-8859-15") : new InputStreamReader((InputStream)new FileInputStream(infile), "ISO-8859-15");
                                                LoadEntry ldr = new LoadEntry(star, errs);
                                                rc = ldr.load(in, true);
                                                if (rc) {
                                                    EditingFunction fn;
                                                    star.getConnection().commit();
                                                    if (log != null) {
                                                        log.println("Entry loaded: " + (System.currentTimeMillis() - now));
                                                        now = System.currentTimeMillis();
                                                    }
                                                    AddDictionaryInfo.addDictionaryInfo(star);
                                                    if (!AddDictionaryInfo.checkVersion(star, null)) {
                                                        errs.add(new Error(false, -1, -1, 0, "NMR-STAR versions don't match!"));
                                                    }
                                                    if (log != null) {
                                                        log.println("Added dictionary overrides: " + (System.currentTimeMillis() - now));
                                                        now = System.currentTimeMillis();
                                                    }
                                                    if (!(fn = new InsertShiftReference(errs, cf, star)).edit(false)) {
                                                        rc = false;
                                                    }
                                                    if (!(fn = new TrimAditDeposition(errs, cf, star)).edit(false)) {
                                                        rc = false;
                                                    }
                                                    if (!(fn = new TrimValues(errs, cf, star)).edit(false)) {
                                                        rc = false;
                                                    }
                                                    if (!(fn = new FixFramecodes(errs, cf, star)).edit(false)) {
                                                        rc = false;
                                                    }
                                                    if (!(fn = new MarkFramecodeValues(errs, cf, star)).edit(false)) {
                                                        rc = false;
                                                    }
                                                    if (!(fn = new InsertValues(errs, cf, star)).edit(false)) {
                                                        rc = false;
                                                    }
                                                    if (!(fn = new InsertLocalIDs(errs, cf, star)).edit(false)) {
                                                        rc = false;
                                                    }
                                                    ArrayList<Integer> list = new ArrayList<Integer>();
                                                    Statement stat = star.getStatement();
                                                    ResultSet rs = stat.executeQuery("SELECT DISTINCT LOOPID FROM ENTRYTAGS WHERE NAME LIKE '_Entity_comp_index.%'");
                                                    while (rs.next()) {
                                                        list.add(new Integer(rs.getInt(1)));
                                                    }
                                                    rs.close();
                                                    stat.executeUpdate("DELETE FROM ENTRYTAGS WHERE NAME LIKE '_Entity_comp_index.%'");
                                                    for (int i = 0; i < list.size(); ++i) {
                                                        stat.executeUpdate("DELETE FROM ENTRYLOOPS WHERE ID=" + ((Integer)list.get(i)).toString());
                                                    }
                                                    if (!stat.getConnection().getAutoCommit()) {
                                                        stat.getConnection().commit();
                                                    }
                                                    stat.close();
                                                    fn = new InsertResidueLoop(errs, cf, star);
                                                    if (!fn.edit(false)) {
                                                        rc = false;
                                                    }
                                                    if (!(fn = new EditResidueLabels(errs, cf, star)).edit(false)) {
                                                        rc = false;
                                                    }
                                                    if (!(fn = new InsertLocalIDs(errs, cf, star)).edit(false)) {
                                                        rc = false;
                                                    }
                                                    if (!(fn = new InsertEntryID(errs, cf, star)).edit(false)) {
                                                        rc = false;
                                                    }
                                                    if (!(fn = new UpdateRelatedTags(errs, cf, star)).edit(false)) {
                                                        rc = false;
                                                    }
                                                    if (!(fn = new InsertDataSetCount(errs, cf, star)).edit(false)) {
                                                        rc = false;
                                                    }
                                                    if (!(fn = new AddRowIndexes(errs, cf, star)).edit(false)) {
                                                        rc = false;
                                                    }
                                                    fn = null;
                                                    if (log != null) {
                                                        log.println("Edited: " + (System.currentTimeMillis() - now));
                                                        now = System.currentTimeMillis();
                                                    }
                                                    PrintWriter out = null;
                                                    out = outfile == null ? new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "ISO-8859-15")) : new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outfile), "ISO-8859-15"));
                                                    star.setSortTags(true);
                                                    star.setReindexLoops(true);
                                                    BlockNode data = UnparseToStarlib.createDataNode(star, true);
                                                    star.disconnect();
                                                    StarUnparser unp = outfile == null ? new StarUnparser(System.out) : new StarUnparser(new FileOutputStream(outfile));
                                                    unp.writeOut(data, 0);
                                                    if (log != null) {
                                                        log.println("Unparse finished: " + (System.currentTimeMillis() - now));
                                                        now = System.currentTimeMillis();
                                                    }
                                                }
                                                star.disconnect();
                                                if (log != null) {
                                                    log.println("Total time: " + (System.currentTimeMillis() - total));
                                                }
                                                break block119;
                                            }
                                            catch (Exception e) {
                                                System.err.println(e);
                                                e.printStackTrace();
                                                if (log != null) {
                                                    log.println(e);
                                                    e.printStackTrace(log);
                                                }
                                                rc = false;
                                                Object var32_24 = null;
                                                if (star != null) {
                                                    star.disconnect();
                                                }
                                                if (log != null) {
                                                    log.println("DB closed: " + (System.currentTimeMillis() - now));
                                                }
                                                if (errs != null && errs.size() > 0) {
                                                    if (log != null) {
                                                        errs.printErrors(log);
                                                    } else {
                                                        errs.printErrors(System.out);
                                                    }
                                                }
                                                if (log != null) {
                                                    log.flush();
                                                    log.close();
                                                }
                                                if (rc) return;
                                                System.exit(1);
                                                return;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var32_25 = null;
                                            if (star != null) {
                                                star.disconnect();
                                            }
                                            if (log != null) {
                                                log.println("DB closed: " + (System.currentTimeMillis() - now));
                                            }
                                            if (errs != null && errs.size() > 0) {
                                                if (log != null) {
                                                    errs.printErrors(log);
                                                } else {
                                                    errs.printErrors(System.out);
                                                }
                                            }
                                            if (log != null) {
                                                log.flush();
                                                log.close();
                                            }
                                            if (rc) throw throwable;
                                            System.exit(1);
                                            throw throwable;
                                        }
                                    }
                                    if (log != null) {
                                        log.println("DB closed: " + (System.currentTimeMillis() - now));
                                    }
                                    if (errs != null && errs.size() > 0) {
                                        if (log != null) {
                                            errs.printErrors(log);
                                        } else {
                                            errs.printErrors(System.out);
                                        }
                                    }
                                    if (log != null) {
                                        log.flush();
                                        log.close();
                                    }
                                    if (rc) return;
                                    System.exit(1);
                                    return;
                                }
                                Object var32_17 = null;
                                if (star != null) {
                                    star.disconnect();
                                }
                                if (log != null) {
                                    log.println("DB closed: " + (System.currentTimeMillis() - now));
                                }
                                if (errs != null && errs.size() > 0) {
                                    if (log != null) {
                                        errs.printErrors(log);
                                    } else {
                                        errs.printErrors(System.out);
                                    }
                                }
                                if (log != null) {
                                    log.flush();
                                    log.close();
                                }
                                if (rc) return;
                                System.exit(1);
                                return;
                            }
                            Object var32_18 = null;
                            if (star != null) {
                                star.disconnect();
                            }
                            if (log != null) {
                                log.println("DB closed: " + (System.currentTimeMillis() - now));
                            }
                            if (errs != null && errs.size() > 0) {
                                if (log != null) {
                                    errs.printErrors(log);
                                } else {
                                    errs.printErrors(System.out);
                                }
                            }
                            if (log != null) {
                                log.flush();
                                log.close();
                            }
                            if (rc) return;
                            System.exit(1);
                            return;
                        }
                        Object var32_19 = null;
                        if (star != null) {
                            star.disconnect();
                        }
                        if (log != null) {
                            log.println("DB closed: " + (System.currentTimeMillis() - now));
                        }
                        if (errs != null && errs.size() > 0) {
                            if (log != null) {
                                errs.printErrors(log);
                            } else {
                                errs.printErrors(System.out);
                            }
                        }
                        if (log != null) {
                            log.flush();
                            log.close();
                        }
                        if (rc) return;
                        System.exit(1);
                        return;
                    }
                    Object var32_20 = null;
                    if (star != null) {
                        star.disconnect();
                    }
                    if (log != null) {
                        log.println("DB closed: " + (System.currentTimeMillis() - now));
                    }
                    if (errs != null && errs.size() > 0) {
                        if (log != null) {
                            errs.printErrors(log);
                        } else {
                            errs.printErrors(System.out);
                        }
                    }
                    if (log != null) {
                        log.flush();
                        log.close();
                    }
                    if (rc) return;
                    System.exit(1);
                    return;
                }
                Object var32_21 = null;
                if (star != null) {
                    star.disconnect();
                }
                if (log != null) {
                    log.println("DB closed: " + (System.currentTimeMillis() - now));
                }
                if (errs != null && errs.size() > 0) {
                    if (log != null) {
                        errs.printErrors(log);
                    } else {
                        errs.printErrors(System.out);
                    }
                }
                if (log != null) {
                    log.flush();
                    log.close();
                }
                if (rc) return;
                System.exit(1);
                return;
            }
            Object var32_22 = null;
            if (star != null) {
                star.disconnect();
            }
            if (log != null) {
                log.println("DB closed: " + (System.currentTimeMillis() - now));
            }
            if (errs != null && errs.size() > 0) {
                if (log != null) {
                    errs.printErrors(log);
                } else {
                    errs.printErrors(System.out);
                }
            }
            if (log != null) {
                log.flush();
                log.close();
            }
            if (rc) return;
            System.exit(1);
            return;
        }
        Object var32_23 = null;
        if (star != null) {
            star.disconnect();
        }
        if (log != null) {
            log.println("DB closed: " + (System.currentTimeMillis() - now));
        }
        if (errs != null && errs.size() > 0) {
            if (log != null) {
                errs.printErrors(log);
            } else {
                errs.printErrors(System.out);
            }
        }
        if (log != null) {
            log.flush();
            log.close();
        }
        if (rc) return;
        System.exit(1);
    }
}

