/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    public static final String DEF_PROPFILE = "validator.properties";
    public static final String PROPKEY_DBDRIVER = "DB.Driver";
    public static final String PROPKEY_DBURL = "DB.Url";
    public static final String PROPKEY_DBUSER = "DB.User";
    public static final String PROPKEY_DBPASSWD = "DB.Password";
    public static final String PROPKEY_SCHEMA = "Validator.schema";
    public static final String PROPKEY_SHIFTSTATS = "Validator.shiftstats";
    public static final String PROPKEY_MAXERRORS = "Validator.maxerrors";
    public static final String PROPKEY_SELFUNCS = "Validator.functions";
    public static final String PROPKEY_WORKDIR = "Validator.workdir";
    public static final String PROPKEY_DICTBTNNAME = "Validator.button.dictionary.name";
    public static final String PROPKEY_DICTBTNTIP = "Validator.button.dictionary.tip";
    public static final String PROPKEY_SELBTNNAME = "Validator.button.select.name";
    public static final String PROPKEY_SELBTNTIP = "Validator.button.select.tip";
    public static final String PROPKEY_CLRBTNNAME = "Validator.button.clear.name";
    public static final String PROPKEY_CLRBTNTIP = "Validator.button.clear.tip";
    public static final String PROPKEY_RUNBTNNAME = "Validator.button.run.name";
    public static final String PROPKEY_RUNBTNTIP = "Validator.button.run.tip";
    public static final String PROPKEY_POPUPCATS = "Validator.popup.cats.name";
    public static final String PROPKEY_FUNCCATPREFIX = "Validator.func.category";
    public static final String PROPKEY_FUNCDESCRPREFIX = "Validator.func.description";
    private Properties fProps = null;
    private String fFile = null;

    public Config() {
        this.fProps = new Properties();
        String conffile = System.getProperty("validator.config");
        if (conffile == null) {
            conffile = DEF_PROPFILE;
        }
        this.fFile = System.getProperty("user.home") + File.separatorChar + conffile;
        this.load();
    }

    public Config(String name) {
        this.fProps = new Properties();
        this.fFile = name;
        this.load();
    }

    public Config(Properties props) {
        this.fProps = props;
    }

    public boolean load(String file) {
        this.fFile = file;
        return this.load();
    }

    public boolean load() {
        try {
            FileInputStream in = new FileInputStream(this.fFile);
            this.fProps.load(in);
        }
        catch (Exception e) {
            System.err.println("Cannot load configuraton file " + this.fFile);
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean save() {
        try {
            FileOutputStream out = new FileOutputStream(this.fFile);
            this.fProps.store(out, "Validator properties");
        }
        catch (Exception e) {
            System.err.println("Cannot save configuraton file " + this.fFile);
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public Properties getProperties() {
        return this.fProps;
    }

    public String getFilename() {
        return this.fFile;
    }

    public String get(String key) {
        return this.fProps.getProperty(key);
    }

    public void set(String key, String val) {
        this.fProps.setProperty(key, val);
    }

    public void print() {
        System.out.println("Properties: ");
        Enumeration<?> e = this.fProps.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            System.out.println(key + ": " + this.fProps.getProperty(key));
        }
    }

    public String getChemShiftsFile() {
        return this.fProps.getProperty(PROPKEY_SHIFTSTATS);
    }

    public int getMaxErrors() {
        int rc = -1;
        try {
            rc = Integer.parseInt(this.fProps.getProperty(PROPKEY_MAXERRORS));
        }
        catch (Exception e) {
            System.err.println("Error in properties file: Validator.maxerrors");
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
        }
        return rc - 1;
    }

    public List<Integer> listSelectedFunctions() {
        String str = this.fProps.getProperty(PROPKEY_SELFUNCS);
        if (str == null || str.trim().length() < 1) {
            return null;
        }
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        String[] nums = str.split("\\s+");
        for (int i = 0; i < nums.length; ++i) {
            try {
                tmp.add(new Integer(nums[i]));
                continue;
            }
            catch (Exception e) {
                System.err.println("Error in properties file: Validator.functions");
                System.err.println(e);
                e.printStackTrace();
                return null;
            }
        }
        if (tmp.size() < 1) {
            return null;
        }
        return tmp;
    }

    public Integer[] getSelectedFunctions() {
        List<Integer> tmp = this.listSelectedFunctions();
        if (tmp == null) {
            return null;
        }
        Integer[] rc = null;
        boolean i = false;
        rc = new Integer[tmp.size()];
        rc = tmp.toArray(rc);
        tmp.clear();
        tmp = null;
        return rc;
    }

    public int[] getSelectedFuncs() {
        List<Integer> tmp = this.listSelectedFunctions();
        if (tmp == null) {
            return null;
        }
        int[] rc = new int[tmp.size()];
        int i = 0;
        Iterator<Integer> i$ = tmp.iterator();
        while (i$.hasNext()) {
            int v;
            rc[i] = v = i$.next().intValue();
            ++i;
        }
        return rc;
    }

    public String getSelectButtonName() {
        return this.fProps.getProperty(PROPKEY_SELBTNNAME);
    }

    public String getSelectButtonTip() {
        return this.fProps.getProperty(PROPKEY_SELBTNTIP);
    }

    public static void main(String[] args) {
        Config c = args.length > 0 ? new Config(args[0]) : new Config();
        c.print();
    }
}

