/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator;

import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.Severity;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorList
implements Iterable<Error>,
EDU.bmrb.lib.ErrorList {
    protected ArrayList<Error> fErrs = null;
    protected Severity fVerb = Severity.INFO;
    protected boolean fVerbose = true;
    protected OutputStream fOut = System.err;
    protected int fNumErrs = 0;
    protected int fNumWarns = 0;

    public ErrorList() {
        this.fErrs = new ArrayList();
    }

    public ErrorList(boolean verbose) {
        this.fErrs = new ArrayList();
        this.fVerb = verbose ? Severity.INFO : Severity.ERR;
    }

    public ErrorList(boolean verbose, OutputStream out) {
        this.fErrs = new ArrayList();
        this.fVerb = verbose ? Severity.INFO : Severity.ERR;
        this.fOut = out;
    }

    @Override
    public Iterator<Error> iterator() {
        return this.fErrs.iterator();
    }

    public int size() {
        return this.fErrs.size();
    }

    public void clear() {
        this.fErrs.clear();
    }

    public int numErrors(Severity svr) {
        int rc = 0;
        for (Error e : this.fErrs) {
            if (!e.getSeverity().equals((Object)svr)) continue;
            ++rc;
        }
        return rc;
    }

    public void setVerbose(Severity svr) {
        this.fVerb = svr;
    }

    public Severity getVerbose() {
        return this.fVerb;
    }

    public boolean add(Error err) {
        if (err == null) {
            return false;
        }
        if (this.fErrs.size() < 1) {
            return this.fErrs.add(err);
        }
        int pos = Collections.binarySearch(this.fErrs, err);
        if (pos >= 0) {
            return false;
        }
        this.fErrs.add(Math.abs(pos) - 1, err);
        return true;
    }

    public void print(PrintWriter out) {
        if (out == null) {
            throw new NullPointerException("Outpuut stream is null");
        }
        int fnum = -1;
        int errnum = -1;
        Severity svr = null;
        for (Error e : this.fErrs) {
            if (fnum < 0) {
                fnum = e.getFuncNum();
            }
            if (errnum < 0) {
                errnum = e.getErrNum();
            }
            if (svr == null) {
                svr = e.getSeverity();
            }
            if (!e.getSeverity().equals((Object)svr)) {
                svr = e.getSeverity();
                out.println();
            } else if (e.getFuncNum() != fnum) {
                fnum = e.getFuncNum();
                out.println();
            } else if (e.getErrNum() != errnum) {
                errnum = e.getErrNum();
                out.println();
            }
            out.printf("%s:%d:%d-%d %s\n", e.getSeverity().name(), e.getLineNum(), e.getFuncNum(), e.getErrNum(), e.getMessage());
        }
        out.flush();
    }

    public void print(PrintWriter out, boolean summary) {
        this.print(out);
        if (summary) {
            out.println();
            out.println("Summary:");
            block6: for (Severity s : Severity.values()) {
                int num = this.numErrors(s);
                if (num > 0) {
                    out.print(num);
                }
                switch (s) {
                    case CRIT: {
                        if (num > 1) {
                            out.println(" critical errors");
                            continue block6;
                        }
                        if (num <= 0) continue block6;
                        out.println(" critical error");
                        continue block6;
                    }
                    case ERR: {
                        if (num > 1) {
                            out.println(" errors");
                            continue block6;
                        }
                        if (num <= 0) continue block6;
                        out.println(" error");
                        continue block6;
                    }
                    case WARN: {
                        if (num > 1) {
                            out.println(" warnings");
                            continue block6;
                        }
                        if (num <= 0) continue block6;
                        out.println(" warning");
                        continue block6;
                    }
                    case INFO: {
                        if (num > 1) {
                            out.println(" notices");
                            continue block6;
                        }
                        if (num <= 0) continue block6;
                        out.println(" notice");
                    }
                }
            }
        }
        out.flush();
    }

    public int numErrors() {
        return this.numErrors(Severity.ERR);
    }

    public int numWarnings() {
        return this.numErrors(Severity.WARN);
    }

    public void setVerbose(boolean verbose) {
        this.fVerb = verbose ? Severity.INFO : Severity.ERR;
    }

    public boolean isVerbose() {
        return this.fVerb.equals((Object)Severity.INFO);
    }

    public OutputStream setOutputStream(OutputStream out) {
        OutputStream rc = this.fOut;
        this.fOut = out;
        return rc;
    }

    @Override
    public void add(boolean iserr, int func, int num, int line, String msg) {
        this.add(new Error(iserr, func, num, line, msg));
    }

    public void sort() {
    }

    public void printErrors(Writer out, boolean sum) {
        this.print(out);
        try {
            if (sum) {
                out.write("\nSummary: ");
                out.write(this.fNumErrs);
                out.write(" errors, ");
                out.write(this.fNumWarns);
                out.write(" warnings\n");
            }
            out.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void print(Writer out) {
        if (out == null) {
            return;
        }
        try {
            int fno = -1;
            int eno = -1;
            int oldfno = -1;
            int oldeno = -1;
            boolean iserr = true;
            out.write("\n");
            for (int i = 0; i < this.fErrs.size(); ++i) {
                Error err = this.fErrs.get(i);
                fno = err.getFuncNum();
                if (oldfno == -1) {
                    oldfno = fno;
                }
                eno = err.getErrNum();
                if (oldeno == -1) {
                    oldeno = eno;
                }
                if (fno > oldfno) {
                    out.write("\n");
                    oldfno = fno;
                } else if (eno > oldeno) {
                    out.write("\n");
                    oldeno = eno;
                }
                if (iserr && !err.isError()) {
                    out.write("\n");
                    iserr = false;
                }
                out.write(err.toString());
                out.write("\n");
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void printErrors(Writer out) {
        this.printErrors(out, true);
    }

    public void printErrors(OutputStream out) {
        this.printErrors(out, true);
    }

    public void printErrors(OutputStream out, boolean sum) {
        this.print(out);
        String nl = "\n";
        try {
            if (sum) {
                out.write(nl.getBytes());
                out.write("Summary: ".getBytes());
                out.write(Integer.toString(this.fNumErrs).getBytes());
                out.write(" errors, ".getBytes());
                out.write(Integer.toString(this.fNumWarns).getBytes());
                out.write(" warnings\n".getBytes());
            }
            out.flush();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void print(OutputStream out) {
        if (out == null) {
            return;
        }
        String nl = "\n";
        int fno = -1;
        int oldfno = -1;
        int eno = -1;
        int oldeno = -1;
        boolean iserr = true;
        try {
            out.write(nl.getBytes());
            for (int i = 0; i < this.fErrs.size(); ++i) {
                Error err = this.fErrs.get(i);
                fno = err.getFuncNum();
                if (oldfno == -1) {
                    oldfno = fno;
                }
                eno = err.getErrNum();
                if (oldeno == -1) {
                    oldeno = eno;
                }
                if (fno > oldfno) {
                    out.write(nl.getBytes());
                    oldfno = fno;
                } else if (eno > oldeno) {
                    out.write(nl.getBytes());
                    oldeno = eno;
                }
                if (iserr && !err.isError()) {
                    out.write(nl.getBytes());
                    iserr = false;
                }
                out.write(err.toString().getBytes());
                out.write(nl.getBytes());
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void printErrors() {
        if (this.fOut == null) {
            this.printErrors(System.err);
        } else {
            this.printErrors(this.fOut);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.fErrs.size(); ++i) {
            sb.append(this.fErrs.get(i).toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        ErrorList errs = new ErrorList();
        errs.add(new Error(true, 0, 0, 0, "0, added first"));
        errs.add(new Error(true, 0, 2, 0, "2, added second"));
        errs.add(new Error(true, 0, 1, 1, "1, added third"));
        errs.printErrors();
    }
}

