/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator;

import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.ErrorList;

public abstract class Function
implements Comparable {
    public static final String PROPKEY_FUNCCATPREFIX = "Validator.func.category";
    public static final String PROPKEY_FUNCDESCRPREFIX = "Validator.func.description";
    protected Integer fNum = null;
    protected String fName = null;
    protected String fDescr = null;
    protected String fCat = null;
    protected boolean fSelected = false;
    protected Config fConf = null;
    protected ErrorList fErrs = null;

    public Function(ErrorList errs, Config conf) {
        if (conf == null) {
            throw new NullPointerException("Parameter missing");
        }
        this.fConf = conf;
        this.fErrs = errs;
    }

    protected void init(int num) {
        this.fDescr = this.fConf.get(PROPKEY_FUNCDESCRPREFIX + num);
        if (this.fDescr == null || this.fDescr.equals("")) {
            this.fDescr = "";
        }
        this.fCat = this.fConf.get(PROPKEY_FUNCCATPREFIX + num);
        if (this.fCat == null || this.fCat.equals("")) {
            throw new NullPointerException("Error in properties file: no category for function " + num);
        }
        int i = 0;
        int[] sel = this.fConf.getSelectedFuncs();
        if (i < sel.length && sel[i] == num) {
            this.fSelected = true;
        }
    }

    public int hashCode() {
        return this.fNum;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            return ((Function)obj).getNumber().intValue() == this.fNum.intValue();
        }
        return false;
    }

    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (obj == null) {
            return 1;
        }
        return this.fNum - ((Function)obj).getNumber();
    }

    protected static String className(String str) {
        int dot = str.lastIndexOf(46);
        return str.substring(dot + 1);
    }

    public String toString() {
        return this.fNum + ": " + this.fName + " - " + this.fDescr + " (" + this.fCat + ")";
    }

    public Integer getNumber() {
        return this.fNum;
    }

    public String getName() {
        return this.fName;
    }

    public String getDescription() {
        return this.fDescr;
    }

    public String getCategory() {
        return this.fCat;
    }

    public boolean isSelected() {
        return this.fSelected;
    }

    public void setSelected(boolean selected) {
        this.fSelected = selected;
    }
}

