/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Validator;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class Main {
    public static void usage() {
        System.err.println("Usage: java EDU.bmrb.validator.Validator [-c FILE] [-i FILE] [-o FILE] [-n] [-e] [-f NUM [-f NUM ...]] [-h] [-hfuncs]");
        System.err.println("  -c FILE: use config FILE instead of ~/validator.conf");
        System.err.println("  -i FILE: input file name (default: stdin)");
        System.err.println("  -n: validate current database contents (-i is ignored if present)");
        System.err.println("  -o FILE: output file name (default: stdout)");
        System.err.println("  -f NUM: validation function to run.");
        System.err.print("     Multiple -f's are allowed. If omitted, apply functions");
        System.err.println("     selected in config file. If no functions are selected,");
        System.err.println("     read the input and print any parse errors/warnings");
        System.err.println("  -e: run editing functions (default: run validation functions)");
        System.err.println("  -d NUM: data validation function to run (overrides -e and -f).");
        System.err.println("  -x NUM: stop after NUM errors (default: 50).");
        System.err.println("  -v: verbose");
        System.err.println("  -h: print this message");
        System.err.println("  -hfuncs: list available validation functions");
        System.err.println("  -hcats: list available function catgories");
    }

    public static void main(String[] args) {
        long now = System.currentTimeMillis();
        try {
            int opt;
            Getopt g = new Getopt("validator", args, "nevsc:x:i:o:f:d:h::");
            String arg = null;
            String conffile = null;
            String infile = null;
            String outfile = null;
            Integer num = null;
            boolean verbose = false;
            boolean load = true;
            int maxerrs = -1;
            boolean printfuncs = false;
            boolean printcats = false;
            boolean interactive = true;
            boolean edit = false;
            int data_function = -1;
            Vector<Integer> list = new Vector<Integer>();
            block21: while ((opt = g.getopt()) != -1) {
                switch (opt) {
                    case 104: {
                        arg = g.getOptarg();
                        if (arg != null) {
                            if (arg.toLowerCase().equals("funcs")) {
                                printfuncs = true;
                                continue block21;
                            }
                            if (arg.toLowerCase().equals("cats")) {
                                printcats = true;
                                continue block21;
                            }
                        }
                        Main.usage();
                        return;
                    }
                    case 102: {
                        arg = g.getOptarg();
                        try {
                            num = new Integer(arg);
                        }
                        catch (NumberFormatException e) {
                            num = null;
                        }
                        if (num == null) {
                            System.err.println("Invalid option: -f " + arg);
                            Main.usage();
                            return;
                        }
                        list.addElement(num);
                        continue block21;
                    }
                    case 100: {
                        arg = g.getOptarg();
                        try {
                            num = new Integer(arg);
                        }
                        catch (NumberFormatException e) {
                            num = null;
                        }
                        if (num == null) {
                            System.err.println("Invalid option: -d " + arg);
                            Main.usage();
                            return;
                        }
                        data_function = num;
                        continue block21;
                    }
                    case 101: {
                        edit = true;
                        continue block21;
                    }
                    case 110: {
                        load = false;
                        continue block21;
                    }
                    case 120: {
                        arg = g.getOptarg();
                        try {
                            num = new Integer(arg);
                        }
                        catch (NumberFormatException e) {
                            num = null;
                        }
                        if (num == null) {
                            System.err.println("Invalid option: -e " + arg);
                            Main.usage();
                            return;
                        }
                        maxerrs = num;
                        continue block21;
                    }
                    case 99: {
                        conffile = g.getOptarg();
                        if (conffile != null) continue block21;
                        System.err.println("Invalid option: -c " + conffile);
                        return;
                    }
                    case 105: {
                        infile = g.getOptarg();
                        if (infile != null) continue block21;
                        System.err.println("Invalid option: -i " + infile);
                        return;
                    }
                    case 111: {
                        outfile = g.getOptarg();
                        if (outfile != null) continue block21;
                        System.err.println("Invalid option: -i " + outfile);
                        return;
                    }
                    case 115: {
                        interactive = false;
                        continue block21;
                    }
                    case 118: {
                        verbose = true;
                        continue block21;
                    }
                }
                return;
            }
            if (data_function >= 0 && load && infile == null) {
                System.err.println("Must specify input file or '-n' to run data validation functions");
                System.exit(1);
            }
            Config c = conffile != null ? new Config(conffile) : new Config();
            Integer[] nums = null;
            if (list.size() < 1) {
                nums = c.getSelectedFunctions();
            } else {
                nums = new Integer[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    nums[i] = (Integer)list.elementAt(i);
                }
            }
            list.clear();
            list = null;
            ErrorList errs = new ErrorList();
            Star_DB star = new Star_DB(c.getProperties());
            Validator v = new Validator(errs, c, star);
            v.setInteractive(interactive);
            String[] names = null;
            if (printfuncs) {
                names = v.listFunctions();
                System.out.println("Available functions:");
                if (names != null) {
                    for (int i = 0; i < names.length; ++i) {
                        System.out.println(names[i]);
                    }
                }
                return;
            }
            if (printcats) {
                names = v.listCategories();
                System.out.println("Function categories:");
                if (names != null) {
                    for (int i = 0; i < names.length; ++i) {
                        System.out.println(names[i]);
                    }
                }
                return;
            }
            if (nums.length > 0) {
                v.deselectAll();
                for (int i = 0; i < nums.length; ++i) {
                    if (v.select(nums[i])) continue;
                    System.err.println("No such function: " + nums[i]);
                }
            }
            v.setVerbose(verbose);
            if (!star.connect(false)) {
                System.err.println("Failed to open database");
                errs.add(new Error(true, -1, -1, -1, "Failed to open database"));
                return;
            }
            if (verbose) {
                System.err.print("Database open: ");
                System.err.println(System.currentTimeMillis() - now);
                now = System.currentTimeMillis();
            }
            boolean abort = false;
            InputStream sin = null;
            BufferedReader in = null;
            if (load || data_function >= 0) {
                sin = infile == null ? System.in : new FileInputStream(infile);
                in = new BufferedReader(new InputStreamReader(sin));
                if (load) {
                    if (verbose) {
                        System.err.println("Loading");
                    }
                    if (data_function >= 0) {
                        abort = !v.loadMetadata(in);
                    } else {
                        boolean bl = abort = !v.load(in);
                    }
                }
            }
            if (verbose) {
                System.err.print("DB loaded: ");
                System.err.println(System.currentTimeMillis() - now);
                now = System.currentTimeMillis();
            }
            if (!abort) {
                if (data_function != -1) {
                    if (load) {
                        in = new BufferedReader(new InputStreamReader(new FileInputStream(infile)));
                    }
                    v.validateData(data_function, in);
                } else if (edit) {
                    v.edit();
                } else {
                    v.validate();
                }
            }
            if (verbose) {
                System.err.print("validated: ");
                System.err.println(System.currentTimeMillis() - now);
                now = System.currentTimeMillis();
            }
            star.disconnect();
            if (verbose) {
                System.err.print("DB closed: ");
                System.err.println(System.currentTimeMillis() - now);
                now = System.currentTimeMillis();
            }
            if (outfile == null) {
                errs.printErrors(System.out);
            } else {
                FileOutputStream out = new FileOutputStream(outfile);
                errs.printErrors(out);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

