/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator;

import EDU.bmrb.stardb.AddDictionaryInfo;
import EDU.bmrb.stardb.LoadEntry;
import EDU.bmrb.stardb.LoadMetadata;
import EDU.bmrb.stardb.LoopTable;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.stardb.Unparse;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.DataValidationFunction;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Function;
import EDU.bmrb.validator.ValidationFunction;
import EDU.bmrb.validator.functions.AddComments;
import EDU.bmrb.validator.functions.AddRowIndexes;
import EDU.bmrb.validator.functions.CheckAmbiguityCodes;
import EDU.bmrb.validator.functions.CheckCharset;
import EDU.bmrb.validator.functions.CheckDataTypes;
import EDU.bmrb.validator.functions.CheckDataValues;
import EDU.bmrb.validator.functions.CheckEmptyRows;
import EDU.bmrb.validator.functions.CheckFrameCodes;
import EDU.bmrb.validator.functions.CheckInvalidTags;
import EDU.bmrb.validator.functions.CheckLocalIds;
import EDU.bmrb.validator.functions.CheckMandatoryTags;
import EDU.bmrb.validator.functions.CheckRelatedTags;
import EDU.bmrb.validator.functions.CheckResidueSequence;
import EDU.bmrb.validator.functions.CheckRowIndexes;
import EDU.bmrb.validator.functions.CheckSampleSaveframe;
import EDU.bmrb.validator.functions.CheckSaveFrames;
import EDU.bmrb.validator.functions.CheckShiftLoop;
import EDU.bmrb.validator.functions.CheckShiftStats;
import EDU.bmrb.validator.functions.CheckTagOrder;
import EDU.bmrb.validator.functions.CheckXlinkBond;
import EDU.bmrb.validator.functions.EditResidueLabels;
import EDU.bmrb.validator.functions.ExpandExperimentList;
import EDU.bmrb.validator.functions.ExpandSpectrometerList;
import EDU.bmrb.validator.functions.ExtractResidueSequence;
import EDU.bmrb.validator.functions.FixFramecodes;
import EDU.bmrb.validator.functions.InsertDataSetCount;
import EDU.bmrb.validator.functions.InsertEntryID;
import EDU.bmrb.validator.functions.InsertLocalIDs;
import EDU.bmrb.validator.functions.InsertMandatoryTags;
import EDU.bmrb.validator.functions.InsertResidueLoop;
import EDU.bmrb.validator.functions.InsertResidueSequence;
import EDU.bmrb.validator.functions.InsertSaveFrame;
import EDU.bmrb.validator.functions.InsertShiftReference;
import EDU.bmrb.validator.functions.InsertValues;
import EDU.bmrb.validator.functions.MarkFramecodeValues;
import EDU.bmrb.validator.functions.RemoveComments;
import EDU.bmrb.validator.functions.SortTags;
import EDU.bmrb.validator.functions.TrimValues;
import EDU.bmrb.validator.functions.UpdateRelatedTags;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class Validator {
    private Stardb fStar = null;
    private LoadEntry fLdr = null;
    private Config fConf = null;
    private ErrorList fErrs = null;
    private Map fFuncs = null;
    private Map fNames = null;
    private Reader fIn = null;
    private boolean fInteractive = true;
    private boolean fVerbose = false;

    public Validator() {
        this.fErrs = new ErrorList();
        this.fConf = new Config();
        this.fStar = new Star_DB(this.fConf.getProperties());
        this.init();
        this.init_functions();
    }

    public Validator(ErrorList errs, Stardb star) {
        this.fErrs = errs;
        this.fStar = star;
        this.fConf = new Config();
        this.init();
        this.init_functions();
    }

    public Validator(ErrorList errs, Config conf, Stardb star) {
        this.fErrs = errs;
        this.fConf = conf;
        this.fStar = star;
        this.init();
        this.init_functions();
    }

    private void init() {
        this.fFuncs = new TreeMap();
        this.fNames = new HashMap();
        if (!this.fStar.isConnected()) {
            this.fStar.connect(false);
        }
    }

    private void init_functions() {
        this.add(new CheckSaveFrames(this.fErrs, this.fConf));
        this.add(new CheckInvalidTags(this.fErrs, this.fConf));
        this.add(new CheckMandatoryTags(this.fErrs, this.fConf));
        this.add(new CheckTagOrder(this.fErrs, this.fConf));
        this.add(new CheckFrameCodes(this.fErrs, this.fConf));
        this.add(new CheckDataTypes(this.fErrs, this.fConf));
        this.add(new CheckDataValues(this.fErrs, this.fConf));
        this.add(new CheckRelatedTags(this.fErrs, this.fConf));
        this.add(new CheckLocalIds(this.fErrs, this.fConf));
        this.add(new CheckEmptyRows(this.fErrs, this.fConf));
        this.add(new CheckRowIndexes(this.fErrs, this.fConf));
        this.add(new CheckCharset(this.fErrs, this.fConf));
        this.add(new CheckShiftStats(this.fErrs, this.fConf));
        this.add(new CheckShiftLoop(this.fErrs, this.fConf));
        this.add(new CheckAmbiguityCodes(this.fErrs, this.fConf));
        this.add(new ExtractResidueSequence(this.fErrs, this.fConf));
        this.add(new CheckXlinkBond(this.fErrs, this.fConf));
        this.add(new CheckResidueSequence(this.fErrs, this.fConf));
        this.add(new CheckSampleSaveframe(this.fErrs, this.fConf));
        this.add(new InsertValues(this.fErrs, this.fConf, this.fStar));
        this.add(new MarkFramecodeValues(this.fErrs, this.fConf, this.fStar));
        this.add(new TrimValues(this.fErrs, this.fConf, this.fStar));
        this.add(new FixFramecodes(this.fErrs, this.fConf, this.fStar));
        this.add(new SortTags(this.fErrs, this.fConf, this.fStar));
        this.add(new AddRowIndexes(this.fErrs, this.fConf, this.fStar));
        this.add(new InsertShiftReference(this.fErrs, this.fConf, this.fStar));
        this.add(new InsertDataSetCount(this.fErrs, this.fConf, this.fStar));
        this.add(new RemoveComments(this.fErrs, this.fConf, this.fStar));
        this.add(new ExpandSpectrometerList(this.fErrs, this.fConf, this.fStar));
        this.add(new ExpandExperimentList(this.fErrs, this.fConf, this.fStar));
        this.add(new InsertResidueLoop(this.fErrs, this.fConf, this.fStar));
        this.add(new EditResidueLabels(this.fErrs, this.fConf, this.fStar));
        this.add(new InsertEntryID(this.fErrs, this.fConf, this.fStar));
        this.add(new InsertLocalIDs(this.fErrs, this.fConf, this.fStar));
        this.add(new UpdateRelatedTags(this.fErrs, this.fConf, this.fStar));
        this.add(new InsertMandatoryTags(this.fErrs, this.fConf, this.fStar));
        this.add(new InsertResidueSequence(this.fErrs, this.fConf, this.fStar));
        this.add(new AddComments(this.fErrs, this.fConf, this.fStar));
    }

    public boolean load() {
        return this.load(this.fIn);
    }

    public boolean load(Reader in) {
        if (this.fVerbose) {
            System.out.println("Loading entry into DB");
        }
        if (!this.fStar.isConnected()) {
            this.fStar.connect(false);
        }
        if (this.fLdr == null) {
            this.fLdr = new LoadEntry(this.fStar, this.fErrs);
        }
        try {
            if (!this.fLdr.load(in, true)) {
                return false;
            }
            this.fStar.getConnection().commit();
            AddDictionaryInfo.addDictionaryInfo(this.fStar);
            AddDictionaryInfo.checkVersion(this.fStar, this.fErrs);
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean loadMetadata(Reader in) {
        if (this.fVerbose) {
            System.out.println("Loading entry into DB");
        }
        if (!this.fStar.isConnected()) {
            this.fStar.connect(false);
        }
        LoadMetadata ldr = new LoadMetadata(this.fStar, this.fErrs);
        try {
            if (!ldr.load(in, true)) {
                return false;
            }
            this.fStar.getConnection().commit();
            AddDictionaryInfo.addDictionaryInfo(this.fStar);
            AddDictionaryInfo.checkVersion(this.fStar, this.fErrs);
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean unparse(PrintWriter out) {
        if (!this.fStar.isConnected()) {
            this.fStar.connect(false);
        }
        try {
            LoopTable lt = new LoopTable(this.fStar);
            Unparse unp = new Unparse(lt);
            unp.unparse(out);
        }
        catch (Exception e) {
            this.fErrs.add(new Error(true, -1, -1, 0, "Exception during unparse, check error output"));
            return false;
        }
        out.flush();
        return true;
    }

    public void loadDictionary(Reader in) throws Exception {
    }

    public void add(Function func) {
        this.fFuncs.put(func.getNumber(), func);
        this.fNames.put(func.getName(), func);
    }

    public Function get(String name) {
        return (Function)this.fNames.get(name);
    }

    public Function get(Integer num) {
        return (Function)this.fFuncs.get(num);
    }

    public Function get(int num) {
        return (Function)this.fFuncs.get(new Integer(num));
    }

    public String[] listFunctions() {
        int i = 0;
        String[] rc = new String[this.fNames.size()];
        Iterator itr = this.fNames.keySet().iterator();
        while (itr.hasNext()) {
            rc[i] = (String)itr.next();
            ++i;
        }
        return rc;
    }

    public String[] listFunctionsByCategory(String name) {
        ArrayList<String> tmp = new ArrayList<String>(this.fFuncs.size());
        for (Function func : this.fFuncs.values()) {
            if (!func.getCategory().equals(name)) continue;
            tmp.add(func.getName());
        }
        String[] rc = null;
        if (tmp.size() > 0) {
            rc = new String[tmp.size()];
            for (int i = 0; i < tmp.size(); ++i) {
                rc[i] = (String)tmp.get(i);
            }
        }
        tmp.clear();
        tmp = null;
        return rc;
    }

    public String[] listCategories() {
        ArrayList<String> tmp = new ArrayList<String>(this.fFuncs.size());
        Iterator itr = this.fFuncs.values().iterator();
        while (itr.hasNext()) {
            String cat = ((Function)itr.next()).getCategory();
            if (tmp.contains(cat)) continue;
            tmp.add(cat);
        }
        String[] rc = null;
        if (tmp.size() > 0) {
            rc = new String[tmp.size()];
            for (int i = 0; i < tmp.size(); ++i) {
                rc[i] = (String)tmp.get(i);
            }
        }
        tmp.clear();
        tmp = null;
        return rc;
    }

    public boolean select(String name) {
        Function func = (Function)this.fNames.get(name);
        if (func == null) {
            return false;
        }
        func.setSelected(true);
        return true;
    }

    public boolean select(Integer num) {
        Function func = (Function)this.fFuncs.get(num);
        if (func == null) {
            return false;
        }
        func.setSelected(true);
        return true;
    }

    public boolean select(int num) {
        Function func = (Function)this.fFuncs.get(new Integer(num));
        if (func == null) {
            return false;
        }
        func.setSelected(true);
        return true;
    }

    public boolean selectCategory(String name) {
        Function func2 = null;
        boolean rc = false;
        for (Function func2 : this.fFuncs.values()) {
            if (!func2.getCategory().equals(name)) continue;
            rc = true;
            func2.setSelected(true);
        }
        return rc;
    }

    public void selectAll() {
        Iterator i = this.fFuncs.values().iterator();
        while (i.hasNext()) {
            ((Function)i.next()).setSelected(true);
        }
    }

    public void deselect(String name) {
        Function func = (Function)this.fNames.get(name);
        if (func != null) {
            func.setSelected(false);
        }
    }

    public void deselect(Integer num) {
        Function func = (Function)this.fFuncs.get(num);
        if (func != null) {
            func.setSelected(false);
        }
    }

    public void deselect(int num) {
        Function func = (Function)this.fFuncs.get(new Integer(num));
        if (func != null) {
            func.setSelected(false);
        }
    }

    public void deselectAll() {
        Iterator i = this.fFuncs.values().iterator();
        while (i.hasNext()) {
            ((Function)i.next()).setSelected(false);
        }
    }

    public void validate(boolean reload) {
        this.validate();
    }

    public void validate() {
        if (this.fErrs == null) {
            throw new NullPointerException("No error list");
        }
        boolean rc = true;
        Iterator i = this.fFuncs.values().iterator();
        Function func = null;
        while (i.hasNext()) {
            if (this.fErrs.size() > this.fConf.getMaxErrors()) {
                this.fErrs.add(new Error(true, -1, -1, 32000, "Too many previous errors"));
                break;
            }
            func = (Function)i.next();
            if (!(func instanceof ValidationFunction) || !func.isSelected()) continue;
            if (this.fVerbose) {
                System.out.print("Running ");
                System.out.println(func.getName());
            }
            if (((ValidationFunction)func).validate(this.fStar.getConnection())) continue;
            rc = false;
        }
    }

    public void validateData(int num, Reader in) {
        if (this.fErrs == null) {
            throw new NullPointerException("No error list");
        }
        DataValidationFunction func = (DataValidationFunction)this.get(num);
        if (func == null) {
            throw new NullPointerException("No such function: " + num);
        }
        if (this.fVerbose) {
            System.out.print("Running ");
            System.out.println(func.getName());
        }
        func.validate(this.fStar.getConnection(), in);
    }

    public void validate(FileInputStream in, long offset) throws IOException {
        if (this.fErrs == null) {
            throw new NullPointerException("No error list");
        }
        for (Function func : this.fFuncs.values()) {
            if (this.fErrs.size() > this.fConf.getMaxErrors()) {
                this.fErrs.add(new Error(true, -1, -1, 32000, "Too many previous errors"));
                return;
            }
            if (func instanceof ValidationFunction) {
                if (!func.isSelected()) continue;
                System.out.print("Running ");
                System.out.println(func.getName());
                ((ValidationFunction)func).validate(this.fStar.getConnection());
                continue;
            }
            if (!(func instanceof DataValidationFunction) || !func.isSelected()) continue;
            System.out.print("Running ");
            System.out.println(func.getName());
            ((DataValidationFunction)func).validate(this.fStar.getConnection(), new InputStreamReader((InputStream)in, "ISO-8859-1"));
            in.getChannel().position(offset);
        }
    }

    public void edit(boolean reload) {
        this.edit();
    }

    public void edit() {
        if (this.fErrs == null) {
            throw new NullPointerException("No error list");
        }
        Iterator i = this.fFuncs.values().iterator();
        Function func = null;
        while (i.hasNext() && this.fErrs.size() <= this.fConf.getMaxErrors()) {
            func = (Function)i.next();
            if (!(func instanceof EditingFunction) || !func.isSelected()) continue;
            ((EditingFunction)func).edit(this.fInteractive);
        }
    }

    public boolean insertSaveFrame(String sfcat) {
        InsertSaveFrame fn = new InsertSaveFrame(this.fErrs, this.fConf, this.fStar);
        boolean rc = fn.setSaveframeCategory(sfcat);
        if (rc) {
            rc = fn.edit(true);
        }
        return rc;
    }

    public Stardb getStar() {
        return this.fStar;
    }

    public boolean isInteractive() {
        return this.fInteractive;
    }

    public void setInteractive(boolean flag) {
        this.fInteractive = flag;
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean flag) {
        this.fVerbose = flag;
    }

    public ErrorList getErrorList() {
        return this.fErrs;
    }

    public void setErrorList(ErrorList errs) {
        this.fErrs = errs;
    }

    public void setInputStream(Reader in) {
        this.fIn = in;
    }

    public Config getConfig() {
        return this.fConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        Config conf = new Config();
        Star_DB star = new Star_DB(conf.getProperties());
        Validator v = new Validator(errs, conf, star);
        if (!star.connect(false)) {
            errs.add(new Error(true, -1, -1, -1, "Failed to open database"));
            return;
        }
        InputStreamReader in = null;
        try {
            in = args.length < 1 ? new InputStreamReader(System.in) : new FileReader(args[0]);
            if (!v.load(in)) {
                errs.add(new Error(true, -1, -1, -1, "Error parsing input"));
            }
            System.err.println("DB loaded: " + (System.currentTimeMillis() - start));
            Integer[] funcs = conf.getSelectedFunctions();
            for (int i = 0; i < funcs.length; ++i) {
                v.select(funcs[i]);
            }
            v.validate();
            System.err.println("Validated: " + (System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            errs.add(new Error(true, -1, -1, -1, "Error opening input"));
            return;
        }
        finally {
            star.disconnect();
            if (errs.size() > 0) {
                errs.sort();
                errs.printErrors(System.out);
            }
        }
        System.err.println("Elapsed total: " + (System.currentTimeMillis() - start));
    }
}

