/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class AddRowIndexes
extends EditingFunction {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 85;

    public AddRowIndexes(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(85);
        this.fName = AddRowIndexes.className(this.getClass().getName());
        this.init(85);
    }

    public boolean edit(boolean interactive) {
        try {
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery("SELECT ID FROM ENTRYLOOPS ORDER BY ID");
            while (rs.next()) {
                this.reindexLoop(rs.getInt(1));
            }
            rs.close();
            query.close();
            return true;
        }
        catch (SQLException e) {
            this.fErrs.add(new Error(true, 85, -1, -1, "DB exception, check error output"));
            System.err.println(e);
            e.printStackTrace();
            return true;
        }
    }

    public void reindexLoop(int loopid) throws SQLException {
        StringBuffer sql = new StringBuffer("SELECT v.TAGID FROM ENTRYVALS v,ENTRYTAGS t,TAGS d WHERE v.LOOPID=");
        sql.append(loopid);
        sql.append(" AND (v.VAL IS NULL OR v.VAL='.' OR v.VAL='?') AND d.ROWIDXFLAG='Y' AND t.SEQ=d.SEQ AND v.TAGID=t.ID");
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(sql.toString());
        if (!rs.next()) {
            rs.close();
            query.close();
            return;
        }
        sql.setLength(0);
        sql.append("UPDATE ENTRYVALS SET VAL=? WHERE TAGID=");
        sql.append(rs.getInt(1));
        sql.append(" AND LOOPROW=?");
        int row = 1;
        PreparedStatement pstat = this.fStar.getPreparedStatement(sql.toString());
        sql.setLength(0);
        sql.append("SELECT DISTINCT LOOPROW FROM ENTRYVALS WHERE LOOPID=");
        sql.append(loopid);
        sql.append(" ORDER BY LOOPROW");
        rs = query.executeQuery(sql.toString());
        while (rs.next()) {
            pstat.setInt(1, row);
            pstat.setInt(2, rs.getInt(1));
            pstat.executeUpdate();
            ++row;
        }
        pstat.getConnection().commit();
        pstat.close();
        rs.close();
        query.close();
    }

    public void setSelected(boolean selected) {
        this.fSelected = selected;
        this.fStar.setReindexLoops(selected);
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.AddRowIndexes [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        AddRowIndexes fn = new AddRowIndexes(errs, conf, star);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        boolean rc = fn.edit(false);
        System.err.println("Edited: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        if (!rc) {
            System.exit(1);
        }
    }
}

