/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.ValidationFunction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CheckAtoms
extends ValidationFunction {
    public static final int NUMBER = 21;
    public static final String TAG_POLYTYPE = "_Entity.Polymer_type";
    public static final String TAG_ENTITYID = "_Atom_chem_shift.Entity_ID";
    public static final String TAG_RESLABEL = "_Atom_chem_shift.Comp_ID";
    public static final String TAG_ATOMNAME = "_Atom_chem_shift.Atom_ID";
    public static final String TAG_ATOMTYPE = "_Atom_chem_shift.Atom_type";
    public static final String TAG_AMBICODE = "_Atom_chem_shift.Chem_shift_ambiguity_code";
    public static final String[] ERRS = new String[]{"Missing residue type (Entity_ID)", "Unknown residue type: ", "No residue label", "Unknown residue: ", "No atom name", "Unknown atom: ", "No atom type", "Invalid atom type: ", "No shift ambiguity code", "Invalid shift ambiguity code: "};
    private StringBuffer fBuf = null;

    public CheckAtoms(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = new Integer(21);
        this.fName = CheckAtoms.className(this.getClass().getName());
        this.init(21);
        this.fBuf = new StringBuffer();
    }

    public boolean validate(Connection conn) {
        boolean rc = true;
        try {
            Statement query = conn.createStatement(1004, 1007);
            this.fBuf.setLength(0);
            this.fBuf.append("SELECT DISTINCT LOOPID FROM ENTRYTAGS WHERE NAME='");
            this.fBuf.append(TAG_ATOMNAME);
            this.fBuf.append("' ORDER BY LOOPID");
            ResultSet rs = query.executeQuery(this.fBuf.toString());
            while (rs.next()) {
                if (this.checkLoop(conn, rs.getInt(1))) continue;
                rc = false;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(true, 21, -1, -1, "DB exception, check error output"));
            return false;
        }
        return rc;
    }

    public boolean checkLoop(Connection conn, int loopid) throws SQLException {
        boolean rc = true;
        PreparedStatement resTypeStat = conn.prepareStatement("SELECT ID FROM RESTYPES WHERE NAME=?", 1004, 1007);
        PreparedStatement resLabelStat = conn.prepareStatement("SELECT ID FROM RESIDUES WHERE TYPEID=? AND LABEL=?", 1004, 1007);
        PreparedStatement atmNameStat = conn.prepareStatement("SELECT ID FROM ATOMS WHERE RESID=? AND NAME=?", 1004, 1007);
        PreparedStatement atmTypeStat = conn.prepareStatement("SELECT TYPE FROM ATOMS WHERE ID=?", 1004, 1007);
        ResultSet refrs = null;
        Statement query = conn.createStatement(1004, 1007);
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT DISTINCT v.LINE,r.ENTITY,res.VAL,atm.VAL,typ.VAL ");
        this.fBuf.append("FROM ENTRYVALS v,ENTRYTAGS t,ENTRYVALS res,ENTRYTAGS tr,");
        this.fBuf.append("ENTRYVALS atm,ENTRYTAGS ta,ENTRYVALS typ,ENTRYTAGS ts,");
        this.fBuf.append("ENTRYVALS amb,ENTRYTAGS tb,ENTRYRESTYPES r WHERE v.LOOPID=");
        this.fBuf.append(loopid);
        this.fBuf.append(" AND t.NAME='");
        this.fBuf.append(TAG_ENTITYID);
        this.fBuf.append("' AND res.LOOPID=");
        this.fBuf.append(loopid);
        this.fBuf.append(" AND tr.NAME='");
        this.fBuf.append(TAG_RESLABEL);
        this.fBuf.append("' AND atm.LOOPID=");
        this.fBuf.append(loopid);
        this.fBuf.append(" AND ta.NAME='");
        this.fBuf.append(TAG_ATOMNAME);
        this.fBuf.append("' AND typ.LOOPID=");
        this.fBuf.append(loopid);
        this.fBuf.append(" AND ts.NAME='");
        this.fBuf.append(TAG_ATOMTYPE);
        this.fBuf.append("' AND amb.LOOPID=");
        this.fBuf.append(loopid);
        this.fBuf.append(" AND tb.NAME='");
        this.fBuf.append(TAG_AMBICODE);
        this.fBuf.append("' AND v.TAGID=t.ID AND res.TAGID=tr.ID AND atm.TAGID=ta.ID");
        this.fBuf.append(" AND typ.TAGID=ts.ID AND amb.TAGID=tb.ID AND v.LOOPROW=res.LOOPROW");
        this.fBuf.append(" AND v.LOOPROW=atm.LOOPROW AND v.LOOPROW=typ.LOOPROW AND");
        this.fBuf.append(" v.LOOPROW=amb.LOOPROW AND r.EID=v.VAL ORDER BY v.LINE");
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        while (rs.next()) {
            int id = -1;
            String tmp = rs.getString(2);
            if (rs.wasNull()) {
                this.fErrs.add(new Error(true, 21, 0, rs.getInt(1), ERRS[0]));
                rc = false;
            } else {
                if (tmp.toLowerCase().indexOf("polypeptide") >= 0) {
                    tmp = "polypeptide";
                }
                resTypeStat.setString(1, tmp);
                refrs = resTypeStat.executeQuery();
                if (refrs.next()) {
                    id = refrs.getInt(1);
                    if (refrs.wasNull()) {
                        id = -1;
                    }
                }
                if (id < 0) {
                    this.fErrs.add(new Error(true, 21, 1, rs.getInt(1), ERRS[1] + tmp));
                    rc = false;
                }
            }
            tmp = rs.getString(3);
            if (rs.wasNull()) {
                this.fErrs.add(new Error(true, 21, 2, rs.getInt(1), ERRS[2]));
                rc = false;
            } else {
                resLabelStat.setInt(1, id);
                resLabelStat.setString(2, tmp);
                refrs = resLabelStat.executeQuery();
                id = -1;
                if (refrs.next()) {
                    id = refrs.getInt(1);
                    if (refrs.wasNull()) {
                        id = -1;
                    }
                }
                if (id < 0) {
                    this.fErrs.add(new Error(true, 21, 3, rs.getInt(1), ERRS[3] + tmp));
                    rc = false;
                }
            }
            tmp = rs.getString(4);
            if (rs.wasNull()) {
                this.fErrs.add(new Error(true, 21, 4, rs.getInt(1), ERRS[4]));
                rc = false;
            } else {
                atmNameStat.setInt(1, id);
                atmNameStat.setString(2, tmp);
                refrs = atmNameStat.executeQuery();
                id = -1;
                if (refrs.next()) {
                    id = refrs.getInt(1);
                    if (refrs.wasNull()) {
                        id = -1;
                    }
                }
                if (id < 0) {
                    this.fErrs.add(new Error(true, 21, 5, rs.getInt(1), ERRS[5] + tmp));
                    rc = false;
                }
            }
            if (id < 0) continue;
            tmp = rs.getString(5);
            if (rs.wasNull()) {
                this.fErrs.add(new Error(true, 21, 6, rs.getInt(1), ERRS[6]));
                rc = false;
                continue;
            }
            atmTypeStat.setInt(1, id);
            refrs = atmTypeStat.executeQuery();
            id = 0;
            if (refrs.next()) {
                refrs.getString(1);
                if (refrs.wasNull()) {
                    id = -1;
                } else if (refrs.getString(1).toUpperCase().charAt(0) != tmp.toUpperCase().charAt(0)) {
                    id = -1;
                }
            }
            if (id >= 0) continue;
            this.fErrs.add(new Error(true, 21, 7, rs.getInt(1), ERRS[7] + tmp));
            rc = false;
        }
        refrs.close();
        resTypeStat.close();
        resLabelStat.close();
        atmNameStat.close();
        atmTypeStat.close();
        rs.close();
        query.close();
        return rc;
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.CheckAtoms [config file]");
                System.err.println("Error messages:");
                for (int i = 0; i < ERRS.length; ++i) {
                    System.err.println(ERRS[i]);
                }
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        CheckAtoms chk = new CheckAtoms(errs, conf);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        chk.validate(star.getConnection());
        System.err.println("Validated: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
            System.out.flush();
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
    }
}

