/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Severity;
import EDU.bmrb.validator.ValidationFunction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckCharset
extends ValidationFunction {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 19;

    public CheckCharset(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = 19;
        this.fName = CheckCharset.className(this.getClass().getName());
        this.init(19);
    }

    public boolean validate(Connection conn) {
        boolean rc = true;
        try {
            Pattern p = Pattern.compile("\\P{InBasicLatin}");
            Matcher m = null;
            Statement query = conn.createStatement(1003, 1007);
            ResultSet rs = query.executeQuery("SELECT LINE,VAL FROM ENTRYVALS WHERE VAL IS NOT NULL");
            while (rs.next()) {
                if (m == null) {
                    m = p.matcher(rs.getString(2));
                } else {
                    m.reset(rs.getString(2));
                }
                if (!m.find()) continue;
                this.fErrs.add(new Error(Severity.ERR, 19, 1, rs.getInt(1), "Non-ASCII character in %s", rs.getString(2)));
                rc = false;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 19, 4, -1, "Caught exception, check error output"));
            rc = false;
        }
        return rc;
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.CheckCharset [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        CheckCharset chk = new CheckCharset(errs, conf);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        chk.validate(star.getConnection());
        System.err.println("Validated: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
    }
}

