/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.ValidationFunction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

public class CheckDataValues
extends ValidationFunction {
    public static final int NUMBER = 12;
    public static final String[] ERRS = new String[]{"Enumerated value is not in the list: "};

    public CheckDataValues(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = new Integer(12);
        this.fName = CheckDataValues.className(this.getClass().getName());
        this.init(12);
    }

    public boolean validate(Connection conn) {
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        boolean rc = true;
        StringBuffer sql = new StringBuffer();
        try {
            Statement stat1 = conn.createStatement(1004, 1007);
            Statement stat2 = conn.createStatement(1004, 1007);
            sql.append("SELECT v.LINE,v.VAL,t.SEQ,t.NAME,d.ENUMCLOSEDFLAG ");
            sql.append("FROM TAGS d,ENTRYTAGS t,ENTRYVALS v ");
            sql.append("WHERE t.SEQ IS NOT NULL AND d.SEQ=t.SEQ ");
            sql.append("AND v.VAL IS NOT NULL AND v.VAL<>'?' AND v.TAGID=t.ID ");
            sql.append("ORDER BY v.LINE");
            rs1 = stat1.executeQuery(sql.toString());
            while (rs1.next()) {
                sql.setLength(0);
                sql.append("SELECT VAL FROM VALENUMS WHERE SEQ=");
                sql.append(rs1.getInt(3));
                rs2 = stat2.executeQuery(sql.toString());
                boolean found = false;
                boolean has_list = false;
                while (rs2.next()) {
                    has_list = true;
                    if (!rs2.getString(1).equals(rs1.getString(2))) continue;
                    found = true;
                    break;
                }
                if (!has_list || found) continue;
                sql.setLength(0);
                sql.append(ERRS[0]);
                sql.append(rs1.getString(2));
                sql.append(" (");
                sql.append(rs1.getString(4));
                sql.append(')');
                rs1.getString(5);
                if (!rs1.wasNull()) {
                    if (rs1.getString(5).trim().charAt(0) != 'Y' && !rs1.getString(2).toLowerCase().equals("other")) {
                        // empty if block
                    }
                } else {
                    this.fErrs.add(new Error(true, 12, 0, rs1.getInt(1), sql.toString()));
                }
                rc = false;
            }
            stat1.close();
            stat2.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(false, 12, -1, -1, "DB exception, check error output"));
            return false;
        }
        return rc;
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.CheckDataValues [config file]");
                System.err.println("Error messages:");
                for (int i = 0; i < ERRS.length; ++i) {
                    System.err.println(ERRS[i]);
                }
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        CheckDataValues chk = new CheckDataValues(errs, conf);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        chk.validate(star.getConnection());
        System.err.println("Validated: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
    }
}

