/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.Dictionary;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Severity;
import EDU.bmrb.validator.ValidationFunction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

public class CheckInvalidTags
extends ValidationFunction {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 1;

    public CheckInvalidTags(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = 1;
        this.fName = CheckInvalidTags.className(this.getClass().getName());
        this.init(1);
    }

    private boolean checkInvalidTags(Statement query, ResultSet rs) {
        boolean rc = false;
        try {
            rs = query.executeQuery("SELECT LINE,NAME FROM ENTRYTAGS WHERE SEQ IS NULL ORDER BY LINE");
            while (rs.next()) {
                this.fErrs.add(new Error(Severity.ERR, 1, 0, rs.getInt(1), "Unknown tag %s", rs.getString(2)));
                rc = false;
            }
            rs = query.executeQuery("SELECT e.LINE,e.NAME,t.MANDATORY,e.SFID,s.CATEGORY,e.SEQ,t.LOOPMANDATORY FROM ENTRYTAGS e JOIN ENTRYSFS s ON s.ID=e.SFID JOIN TAGS t ON t.SEQ=e.SEQ WHERE e.SEQ IS NOT NULL ORDER BY e.LINE");
            while (rs.next()) {
                char mandatory = Dictionary.checkOverride(query.getConnection(), rs.getString(5), rs.getInt(4), rs.getInt(6));
                if (mandatory == '\u0000') {
                    mandatory = rs.getString(3).charAt(0);
                }
                if (mandatory != 'I') continue;
                rs.getString(7);
                if (!rs.wasNull() && rs.getString(7).charAt(0) == 'Y') {
                    mandatory = Dictionary.checkLoopMandatory(query.getConnection(), rs.getInt(4), rs.getString(2));
                }
                if (mandatory != 'I') continue;
                this.fErrs.add(new Error(Severity.ERR, 1, 6, rs.getInt(1), "Invalid tag: %s", rs.getString(2)));
                rc = false;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 1, -1, -1, "Caught exception, check error output"));
            return false;
        }
        return rc;
    }

    private boolean checkLoopTags(Statement query, ResultSet rs) {
        boolean rc = false;
        try {
            rs = query.executeQuery("SELECT DISTINCT t.LINE,t.NAME FROM ENTRYTAGS t JOIN TAGS d ON d.SEQ=t.SEQ WHERE d.LOOPFLAG='Y'AND t.SEQ IS NOT NULL AND t.LOOPID IS NULL ORDER BY t.LINE");
            while (rs.next()) {
                this.fErrs.add(new Error(Severity.ERR, 1, 1, rs.getInt(1), "Tag not in loop: %s", rs.getString(2)));
                rc = false;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 1, -1, -1, "Caught exception, check error output"));
            return false;
        }
        return rc;
    }

    private boolean checkFreeTags(Statement query, ResultSet rs) {
        boolean rc = false;
        try {
            rs = query.executeQuery("SELECT DISTINCT t.LINE,t.NAME FROM ENTRYTAGS t JOIN TAGS d ON d.SEQ=t.SEQ WHERE d.LOOPFLAG='N' AND t.SEQ IS NOT NULL AND t.LOOPID IS NOT NULL ORDER BY t.LINE");
            while (rs.next()) {
                this.fErrs.add(new Error(Severity.ERR, 1, 2, rs.getInt(1), "Free tag in loop: %s", rs.getString(2)));
                rc = false;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 1, -1, -1, "Caught exception, check error output"));
            return false;
        }
        return rc;
    }

    private boolean checkTagCategories(Statement query, ResultSet rs) {
        boolean rc = true;
        try {
            rs = query.executeQuery("SELECT DISTINCT NAME,LINE FROM ENTRYTAGS WHERE NAME NOT LIKE '%.%'");
            while (rs.next()) {
                this.fErrs.add(new Error(Severity.ERR, 1, 3, rs.getInt(2), "Tag without category: %s", rs.getString(1)));
                rc = false;
            }
            ArrayList<String> loops = new ArrayList<String>();
            PreparedStatement pquery = query.getConnection().prepareStatement("SELECT NAME,LINE FROM ENTRYTAGS WHERE LOOPID=?", 1003, 1007);
            rs = query.executeQuery("SELECT DISTINCT LOOPID FROM ENTRYTAGS WHERE LOOPID IS NOT NULL ORDER BY LOOPID");
            while (rs.next()) {
                loops.add(rs.getString(1));
            }
            String cat = null;
            for (String s : loops) {
                pquery.setInt(1, Integer.parseInt(s));
                rs = pquery.executeQuery();
                while (rs.next()) {
                    String name = rs.getString(1);
                    int pos = name.indexOf(46);
                    if (cat == null) {
                        cat = name.substring(0, pos);
                        continue;
                    }
                    if (name.length() > cat.length() && cat.equals(name.substring(0, cat.length()))) continue;
                    this.fErrs.add(new Error(Severity.ERR, 1, 4, rs.getInt(2), "Tag category changed, was: %s", cat));
                    cat = null;
                    rc = false;
                }
                cat = null;
            }
            loops.clear();
            pquery.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 1, -1, -1, "Caught exception, check error output"));
            return false;
        }
        return rc;
    }

    private boolean checkDuplicateTags(Statement query, ResultSet rs) {
        boolean rc = false;
        try {
            rs = query.executeQuery("SELECT b.LINE,a.LINE,b.NAME FROM ENTRYTAGS a JOIN ENTRYTAGS b ON a.NAME=b.NAME AND a.SFID=b.SFID WHERE a.ID<>b.ID");
            while (rs.next()) {
                this.fErrs.add(new Error(Severity.ERR, 1, 5, rs.getInt(1), "Duplicate tag: %s (also in line %d)", rs.getString(3), rs.getInt(2)));
                rc = false;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 1, -1, -1, "Caught exception, check error output"));
            return false;
        }
        return rc;
    }

    public boolean validate(Connection conn) {
        try {
            ResultSet rs = null;
            Statement stat = conn.createStatement(1004, 1007);
            boolean rc = this.checkInvalidTags(stat, rs);
            if (!this.checkLoopTags(stat, rs)) {
                rc = false;
            }
            if (!this.checkFreeTags(stat, rs)) {
                rc = false;
            }
            if (!this.checkTagCategories(stat, rs)) {
                rc = false;
            }
            if (!this.checkDuplicateTags(stat, rs)) {
                rc = false;
            }
            if (rs != null) {
                rs.close();
            }
            stat.close();
            return rc;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 1, -1, -1, "Caught exception, check error output"));
            return false;
        }
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.CheckInvalidTags [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        CheckInvalidTags chk = new CheckInvalidTags(errs, conf);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        chk.validate(star.getConnection());
        System.err.println("Validated: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
    }
}

