/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.sansj.ContentHandler;
import EDU.bmrb.sansj.DataItemNode;
import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.STARLexer;
import EDU.bmrb.sansj.SansParser;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.DataValidationFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Severity;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class CheckLocalIds
extends DataValidationFunction
implements ErrorHandler,
ContentHandler {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 14;
    private String fLocalId = null;
    private PreparedStatement fLocalIdQuery = null;
    private PreparedStatement fTagQuery = null;
    private PreparedStatement fSfCatQuery = null;
    private ResultSet fRs = null;
    private ArrayList<String> fTags = null;

    public CheckLocalIds(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = 14;
        this.fName = CheckLocalIds.className(this.getClass().getName());
        this.init(14);
        this.fTags = new ArrayList();
    }

    public boolean validate(Connection conn, Reader in) {
        try {
            this.fLocalIdQuery = conn.prepareStatement("SELECT v.VAL FROM ENTRYVALS v JOIN ENTRYTAGS e ON e.ID=v.TAGID JOIN ENTRYSFS s ON s.ID=e.SFID JOIN TAGS d ON d.TAGNAME=e.NAME WHERE s.NAME=? AND d.LOCALIDFLAG='Y' AND d.LOOPFLAG='N'", 1003, 1007);
            this.fSfCatQuery = conn.prepareStatement("SELECT CATEGORY FROM ENTRYSFS WHERE NAME=?", 1003, 1007);
            this.fTagQuery = conn.prepareStatement("SELECT e.NAME FROM ENTRYTAGS e JOIN ENTRYSFS s ON s.ID=e.SFID JOIN TAGS d ON d.TAGNAME=e.NAME WHERE s.NAME=? AND d.LOCALIDFLAG='Y' AND d.LOOPFLAG='Y'", 1003, 1007);
            STARLexer lex = new STARLexer(in);
            SansParser p = new SansParser(lex, this, this);
            p.parse();
            if (this.fRs != null) {
                this.fRs.close();
            }
            this.fLocalIdQuery.close();
            this.fTagQuery.close();
            this.fSfCatQuery.close();
            this.fTags.clear();
            return true;
        }
        catch (SQLException e) {
            System.err.println(e);
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 14, -1, -1, "DB exception, check error output"));
            return false;
        }
    }

    public void error(int param, int param1, String str) {
        this.fErrs.add(new Error(Severity.CRIT, 14, -1, param, str));
        System.err.printf("Parse error in line %d, col %d: %s\n", param, param1, str);
    }

    public boolean warning(int param, int param1, String str) {
        this.fErrs.add(new Error(Severity.ERR, 14, -1, param, str));
        System.err.printf("Parse warning in line %d, col %d: %s\n", param, param1, str);
        return false;
    }

    public boolean startSaveFrame(int line, String name) {
        try {
            this.fLocalIdQuery.setString(1, name);
            this.fRs = this.fLocalIdQuery.executeQuery();
            if (this.fRs.next()) {
                this.fLocalId = this.fRs.getString(1);
                if (this.fRs.wasNull()) {
                    this.fLocalId = null;
                }
            } else {
                this.fSfCatQuery.setString(1, name);
                this.fRs = this.fSfCatQuery.executeQuery();
                if (this.fRs.next() && "entry_information".equals(this.fRs.getString(1))) {
                    return false;
                }
                this.fErrs.add(new Error(Severity.ERR, 14, 1, line, "Invalid saveframe: no local ID tag in dictionary"));
            }
            if (this.fLocalId != null) {
                this.fTagQuery.setString(1, name);
                this.fRs = this.fTagQuery.executeQuery();
                while (this.fRs.next()) {
                    this.fTags.add(this.fRs.getString(1));
                }
            }
            if (this.fLocalId == null || this.fLocalId.equals(".") || this.fLocalId.equals("?")) {
                this.fErrs.add(new Error(Severity.ERR, 14, 2, line, "Invalid local ID"));
            }
            return false;
        }
        catch (SQLException e) {
            this.fErrs.add(new Error(Severity.CRIT, 14, 0, line, "Cannot fetch saveframe local ID: DB exception"));
            return true;
        }
    }

    public boolean endSaveFrame(int line, String name) {
        this.fLocalId = null;
        this.fTags.clear();
        return false;
    }

    public boolean data(DataItemNode node) {
        if (this.fLocalId == null || this.fTags.size() < 1) {
            return false;
        }
        for (String s : this.fTags) {
            if (!s.equals(node.getName()) || this.fLocalId.equals(node.getValue())) continue;
            if (this.fLocalId.equals(".") || this.fLocalId.equals("?")) {
                this.fErrs.add(new Error(Severity.CRIT, 14, 3, node.getValueLine(), "No local ID in saveframe"));
                continue;
            }
            this.fErrs.add(new Error(Severity.CRIT, 14, 3, node.getValueLine(), "Invalid local ID %s, should be %s", node.getValue(), this.fLocalId));
        }
        return false;
    }

    public boolean comment(int i, String string) {
        return false;
    }

    public boolean startData(int i, String string) {
        return false;
    }

    public void endData(int i, String string) {
    }

    public boolean startLoop(int line) {
        return false;
    }

    public boolean endLoop(int line) {
        return false;
    }
}

