/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.sansj.ContentHandler;
import EDU.bmrb.sansj.DataItemNode;
import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.STARLexer;
import EDU.bmrb.sansj.SansParser;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.DataValidationFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Severity;
import EDU.bmrb.validator.Triple;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class CheckRelatedTags
extends DataValidationFunction
implements ErrorHandler,
ContentHandler {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 13;
    private ResultSet fRs = null;
    private PreparedStatement fTagQuery = null;
    private PreparedStatement fValQuery = null;
    private PreparedStatement fCacheQuery = null;
    private ArrayList<Triple<String, String, ArrayList<String>>> fLoopCache = null;

    public CheckRelatedTags(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = 13;
        this.fName = CheckRelatedTags.className(this.getClass().getName());
        this.init(13);
        this.fLoopCache = new ArrayList();
    }

    public boolean validate(Connection conn, Reader in) {
        try {
            this.fTagQuery = conn.prepareStatement("SELECT r.PRNTSEQ,d.TAGNAME FROM ENTRYTAGS t JOIN TAGRELS r ON r.CHLDSEQ=t.SEQ JOIN TAGS d ON d.SEQ=r.PRNTSEQ WHERE t.NAME=? AND d.LOCALIDFLAG<>'Y'", 1003, 1007);
            this.fValQuery = conn.prepareStatement("SELECT t.NAME FROM ENTRYTAGS t JOIN ENTRYVALS v ON v.TAGID=t.ID WHERE t.SEQ=? AND v.VAL=?", 1003, 1007);
            this.fCacheQuery = conn.prepareStatement("SELECT v.VAL FROM ENTRYTAGS t JOIN ENTRYVALS v ON v.TAGID=t.ID WHERE t.SEQ=?", 1003, 1007);
            STARLexer lex = new STARLexer(in);
            SansParser p = new SansParser(lex, this, this);
            p.parse();
            if (this.fRs != null) {
                this.fRs.close();
            }
            this.fCacheQuery.close();
            this.fTagQuery.close();
            this.fValQuery.close();
            if (this.fLoopCache != null) {
                for (Triple<String, String, ArrayList<String>> t : this.fLoopCache) {
                    if (t.getThird() == null) continue;
                    t.getThird().clear();
                }
                this.fLoopCache.clear();
            }
            return true;
        }
        catch (SQLException e) {
            System.err.println(e);
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 13, -1, -1, "DB exception, check error output"));
            return false;
        }
    }

    public void error(int param, int param1, String str) {
        this.fErrs.add(new Error(Severity.CRIT, 13, -1, param, str));
        System.err.printf("Parse error in line %d, col %d: %s\n", param, param1, str);
    }

    public boolean warning(int param, int param1, String str) {
        this.fErrs.add(new Error(Severity.ERR, 13, -1, param, str));
        System.err.printf("Parse warning in line %d, col %d: %s\n", param, param1, str);
        return false;
    }

    public boolean endLoop(int line) {
        for (Triple<String, String, ArrayList<String>> t : this.fLoopCache) {
            if (t.getThird() == null) continue;
            t.getThird().clear();
        }
        this.fLoopCache.clear();
        return false;
    }

    public boolean data(DataItemNode node) {
        if (node.getValue().equals("?") || node.getValue().equals(".")) {
            return false;
        }
        try {
            if (node.isInLoop()) {
                int i;
                boolean found = false;
                for (i = 0; i < this.fLoopCache.size(); ++i) {
                    if (!this.fLoopCache.get(i).getFirst().equals(node.getName())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    i = this.fillCache(node.getName());
                }
                found = false;
                if (this.fLoopCache.get(i).getThird() == null) {
                    return false;
                }
                for (String s : this.fLoopCache.get(i).getThird()) {
                    if (!s.equals(node.getValue())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.fErrs.add(new Error(Severity.ERR, 13, 2, node.getValueLine(), "Cannot find parent tag %s with value %s (%s)", this.fLoopCache.get(i).getSecond(), node.getValue(), node.getName()));
                    return false;
                }
            }
            this.fTagQuery.setString(1, node.getName());
            this.fRs = this.fTagQuery.executeQuery();
            if (this.fRs.next()) {
                String tagname = this.fRs.getString(2);
                this.fValQuery.setInt(1, this.fRs.getInt(1));
                this.fValQuery.setString(2, node.getValue());
                this.fRs = this.fValQuery.executeQuery();
                if (!this.fRs.next()) {
                    this.fErrs.add(new Error(Severity.ERR, 13, 3, node.getValueLine(), "Cannot find parent tag %s with value %s (%s)", tagname, node.getValue(), node.getName()));
                }
            }
            return false;
        }
        catch (SQLException e) {
            this.fErrs.add(new Error(Severity.ERR, 13, 1, node.getTagLine(), "Cannot fetch parent tag value"));
            System.err.println(e);
            e.printStackTrace();
            return true;
        }
    }

    private int fillCache(String tag) throws SQLException {
        Triple node = new Triple();
        node.setFirst(tag);
        int seq = -1;
        this.fTagQuery.setString(1, tag);
        this.fRs = this.fTagQuery.executeQuery();
        if (this.fRs.next()) {
            seq = this.fRs.getInt(1);
            node.setSecond(this.fRs.getString(2));
        } else {
            node.setSecond(null);
            node.setThird(null);
        }
        if (seq >= 0) {
            ArrayList<String> vals = new ArrayList<String>();
            this.fCacheQuery.setInt(1, seq);
            this.fRs = this.fCacheQuery.executeQuery();
            while (this.fRs.next()) {
                this.fRs.getString(1);
                if (this.fRs.wasNull()) continue;
                vals.add(this.fRs.getString(1));
            }
            if (vals.size() > 0) {
                node.setThird(vals);
            } else {
                node.setThird(null);
            }
        }
        int rc = this.fLoopCache.size();
        this.fLoopCache.add(rc, node);
        return rc;
    }

    public boolean startData(int i, String string) {
        return false;
    }

    public void endData(int i, String string) {
    }

    public boolean endSaveFrame(int i, String string) {
        return false;
    }

    public boolean comment(int i, String string) {
        return false;
    }

    public boolean startSaveFrame(int line, String name) {
        return false;
    }

    public boolean startLoop(int line) {
        return false;
    }

    public static void usage() {
        System.err.print("Usage: java EDU.bmrb.validator.functions.CheckRelatedTags ");
        System.err.println("[-c FILE] [-i FILE] [-h]");
        System.err.println("  -c FILE: use config FILE instead of ~/validator.conf");
        System.err.println("  -i FILE: input file name (default: stdin)");
        System.err.println("  -h: print this message");
    }

    public static void main(String[] args) {
        try {
            int opt;
            Getopt g = new Getopt("CheckRelatedTags", args, "c:i:h");
            String conffile = null;
            String infile = null;
            block6: while ((opt = g.getopt()) != -1) {
                switch (opt) {
                    case 99: {
                        conffile = g.getOptarg();
                        continue block6;
                    }
                    case 105: {
                        infile = g.getOptarg();
                        continue block6;
                    }
                }
                CheckRelatedTags.usage();
                return;
            }
            Config conf = conffile == null ? new Config() : new Config(conffile);
            ErrorList errs = new ErrorList();
            BufferedReader in = infile == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(infile));
            long start = System.currentTimeMillis();
            Star_DB star = new Star_DB(conf.getProperties());
            star.connect(true);
            System.err.println("DB open: " + (System.currentTimeMillis() - start));
            CheckRelatedTags chk = new CheckRelatedTags(errs, conf);
            chk.validate(star.getConnection(), in);
            System.err.println("Validated: " + (System.currentTimeMillis() - start));
            star.disconnect();
            ((Reader)in).close();
            if (errs.size() > 0) {
                errs.sort();
                errs.printErrors(System.out);
            }
            System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

