/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Severity;
import EDU.bmrb.validator.ValidationFunction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CheckSampleSaveframe
extends ValidationFunction {
    private static final boolean DEBUG = false;
    private static final boolean PROFILE = false;
    public static final int NUMBER = 35;
    public static final String TAG_MOLNAME = "_Sample_component.Mol_common_name";
    public static final String TAG_ENTITY = "_Sample_component.Entity_label";
    public static final String TAG_CONCVAL = "_Sample_component.Concentration_val";
    public static final String TAG_CONCMIN = "_Sample_component.Concentration_val_min";
    public static final String TAG_CONCMAX = "_Sample_component.Concentration_val_max";

    public CheckSampleSaveframe(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = 35;
        this.fName = CheckSampleSaveframe.className(this.getClass().getName());
        this.init(35);
    }

    public boolean validate(Connection conn) {
        long start = System.currentTimeMillis();
        try {
            boolean rc = true;
            Statement query = conn.createStatement(1003, 1007);
            ResultSet rs = query.executeQuery("SELECT ID FROM ENTRYSFS WHERE CATEGORY='sample'");
            while (rs.next()) {
                if (this.checkSaveframe(conn, rs.getInt(1))) continue;
                rc = false;
            }
            rs.close();
            query.close();
            return rc;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 35, -1, -1, "Caught exception, check error output"));
            return false;
        }
    }

    public boolean checkSaveframe(Connection conn, int sfid) throws SQLException {
        String tmp2;
        String tmp1;
        boolean rc = true;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT v1.LINE,v1.VAL,v2.VAL FROM ENTRYVALS v1 ");
        sql.append("JOIN ENTRYTAGS t1 ON v1.TAGID=t1.ID ");
        sql.append("JOIN ENTRYVALS v2 ON v2.LOOPROW=v1.LOOPROW ");
        sql.append("JOIN ENTRYTAGS t2 ON v2.TAGID=t2.ID ");
        sql.append("WHERE t1.SFID=");
        sql.append(sfid);
        sql.append(" AND t2.SFID=");
        sql.append(sfid);
        sql.append(" AND t1.NAME='");
        sql.append(TAG_MOLNAME);
        sql.append("' AND t2.NAME='");
        sql.append(TAG_ENTITY);
        sql.append('\'');
        Statement query = conn.createStatement(1003, 1007);
        boolean i = false;
        ResultSet rs = query.executeQuery(sql.toString());
        while (rs.next()) {
            tmp1 = rs.getString(2);
            if (rs.wasNull()) {
                tmp1 = null;
            }
            tmp2 = rs.getString(3);
            if (rs.wasNull()) {
                tmp2 = null;
            }
            if ((tmp1 != null || tmp2 != null) && (tmp1 == null || !tmp1.equals(".") && !tmp1.equals("?") || tmp2 == null || !tmp2.equals(".") && !tmp2.equals("?"))) continue;
            this.fErrs.add(new Error(Severity.ERR, 35, 0, rs.getInt(1), "Mol_common_name or Entity_label must have a value"));
            rc = false;
        }
        sql.setLength(0);
        sql.append("SELECT v1.LINE,v1.VAL,v2.VAL,v3.VAL FROM ENTRYVALS v1 ");
        sql.append("JOIN ENTRYTAGS t1 ON v1.TAGID=t1.ID ");
        sql.append("JOIN ENTRYVALS v2 ON v2.LOOPROW=v1.LOOPROW ");
        sql.append("JOIN ENTRYTAGS t2 ON v2.TAGID=t2.ID ");
        sql.append("JOIN ENTRYVALS v3 ON v3.LOOPROW=v2.LOOPROW ");
        sql.append("JOIN ENTRYTAGS t3 ON v3.TAGID=t3.ID ");
        sql.append("WHERE t1.SFID=");
        sql.append(sfid);
        sql.append(" AND t2.SFID=");
        sql.append(sfid);
        sql.append(" AND t3.SFID=");
        sql.append(sfid);
        sql.append(" AND t1.NAME='");
        sql.append(TAG_CONCVAL);
        sql.append("' AND t2.NAME='");
        sql.append(TAG_CONCMIN);
        sql.append("' AND t3.NAME='");
        sql.append(TAG_CONCMAX);
        sql.append('\'');
        i = false;
        rs = query.executeQuery(sql.toString());
        while (rs.next()) {
            tmp1 = rs.getString(2);
            if (rs.wasNull()) {
                tmp1 = null;
            } else if (tmp1.equals(".") || tmp1.equals("?")) {
                tmp1 = null;
            }
            if (tmp1 != null) continue;
            tmp1 = rs.getString(3);
            if (rs.wasNull()) {
                tmp1 = null;
            }
            if (tmp1.equals(".") || tmp1.equals("?")) {
                tmp1 = null;
            }
            tmp2 = rs.getString(4);
            if (rs.wasNull()) {
                tmp2 = null;
            }
            if (tmp2.equals(".") || tmp2.equals("?")) {
                tmp2 = null;
            }
            if (tmp1 != null || tmp2 != null) continue;
            this.fErrs.add(new Error(Severity.ERR, 35, 1, rs.getInt(1), "Either Concentration_val or both Concentration_min_val and _max_val must have a value"));
            rc = false;
        }
        rs.close();
        query.close();
        return rc;
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.CheckSampleSaveframe [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        CheckSampleSaveframe chk = new CheckSampleSaveframe(errs, conf);
        star.connect(true);
        chk.validate(star.getConnection());
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
    }
}

