/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Severity;
import EDU.bmrb.validator.ValidationFunction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;

public class CheckSaveFrames
extends ValidationFunction {
    public static final int NUMBER = 0;

    public CheckSaveFrames(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = 0;
        this.fName = CheckSaveFrames.className(this.getClass().getName());
        this.init(0);
    }

    private boolean checkMissingCategories(Statement query, ResultSet rs) {
        boolean rc = true;
        try {
            rs = query.executeQuery("SELECT NAME, LINE FROM ENTRYSFS WHERE CATEGORY IS NULL");
            while (rs.next()) {
                this.fErrs.add(new Error(Severity.ERR, 0, 0, rs.getInt(2), "Invalid saveframe category for saveframe %s (missing saveframe label tag?)", rs.getString(1)));
                rc = false;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 0, -1, -1, "Caught exception, check error output"));
            return false;
        }
        return rc;
    }

    private boolean checkInvalidCategories(Connection conn, Statement query, ResultSet rs) {
        boolean rc = true;
        try {
            StringBuilder sql = new StringBuilder();
            Statement stat = conn.createStatement(1004, 1007);
            ResultSet rs2 = null;
            rs = query.executeQuery("SELECT ID, CATEGORY, NAME FROM ENTRYSFS ORDER BY LINE");
            while (rs.next()) {
                sql.setLength(0);
                sql.append("SELECT v.LINE,v.VAL FROM ENTRYTAGS e JOIN TAGS t ON t.SEQ=e.SEQ JOIN ENTRYVALS v ON v.TAGID=e.ID WHERE t.SFCATFLAG='Y' AND e.SFID=");
                sql.append(rs.getInt(1));
                rs2 = stat.executeQuery(sql.toString());
                if (!rs2.next() || rs2.getString(2).equals(rs.getString(2))) continue;
                this.fErrs.add(new Error(Severity.ERR, 0, 6, rs2.getInt(1), "Invalid saveframe category value for saveframe %s", rs.getString(3)));
                rc = false;
            }
            if (rs2 != null) {
                rs2.close();
            }
            stat.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 0, -1, -1, "Caught exception, check error output"));
            return false;
        }
        return rc;
    }

    private boolean checkDuplicateNames(Statement query, ResultSet rs) {
        boolean rc = true;
        try {
            rs = query.executeQuery("SELECT DISTINCT a.NAME,a.LINE FROM ENTRYSFS a JOIN ENTRYSFS b ON a.NAME=b.NAME WHERE a.LINE<>b.LINE ORDER BY a.NAME,a.LINE");
            while (rs.next()) {
                this.fErrs.add(new Error(Severity.ERR, 0, 1, rs.getInt(2), "Duplicate saveframe name: %s", rs.getString(1)));
                rc = false;
            }
            ArrayList<String> names = new ArrayList<String>();
            rs = query.executeQuery("SELECT DISTINCT NAME,LINE FROM ENTRYSFS");
            while (rs.next()) {
                boolean found = false;
                for (String s : names) {
                    if (!s.toUpperCase().equals(rs.getString(1).toUpperCase())) continue;
                    this.fErrs.add(new Error(Severity.ERR, 0, 1, rs.getInt(2), "Duplicate saveframe name: %s", rs.getString(1)));
                    found = true;
                }
                if (found) continue;
                names.add(rs.getString(1));
            }
            names.clear();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 0, -1, -1, "Caught exception, check error output"));
            return false;
        }
        return rc;
    }

    private boolean checkInvalidLabels(Statement query, ResultSet rs) {
        boolean rc = true;
        try {
            rs = query.executeQuery("SELECT a.NAME,d.VAL,b.LINE FROM ENTRYSFS a JOIN ENTRYTAGS b ON b.SFID=a.ID JOIN TAGS c ON c.TAGNAME=b.NAME JOIN ENTRYVALS d ON d.TAGID=b.ID WHERE c.SFLABELFLAG='Y' AND d.VAL<>a.NAME");
            while (rs.next()) {
                this.fErrs.add(new Error(Severity.ERR, 0, 2, rs.getInt(3), "Saveframe name does not match label: %s (%s)", rs.getString(1), rs.getString(2)));
                rc = false;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 0, -1, -1, "Caught exception, check error output"));
            return false;
        }
        return rc;
    }

    private boolean checkDuplicateCategories(Statement query, ResultSet rs) {
        boolean rc = true;
        try {
            rs = query.executeQuery("SELECT a.CATEGORY,a.LINE,b.NAME,b.LINE FROM ENTRYSFS a JOIN ENTRYSFS b ON b.CATEGORY=a.CATEGORY JOIN SFCATS c ON c.SFCAT=b.CATEGORY WHERE c.UNIQ ='Y' AND a.LINE<>b.LINE");
            String str = null;
            while (rs.next()) {
                if (str != null && str.equals(rs.getString(1))) continue;
                str = rs.getString(1);
                this.fErrs.add(new Error(Severity.ERR, 0, 3, rs.getInt(4), "Duplicate saveframe category: %s (%s, previously defined in line %d)", str, rs.getString(3), rs.getInt(2)));
                rc = false;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 0, -1, -1, "Caught exception, check error output"));
            return false;
        }
        return rc;
    }

    private boolean checkMandatoryCategories(Statement query, ResultSet rs) {
        boolean rc = true;
        try {
            ArrayList<String> list = new ArrayList<String>();
            rs = query.executeQuery("SELECT SFCAT FROM SFCATS WHERE MANDATORY='M' ORDER BY SFCAT");
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            rs = query.executeQuery("SELECT DISTINCT CATEGORY FROM ENTRYSFS WHERE CATEGORY IS NOT NULL ORDER BY CATEGORY");
            block3: while (rs.next()) {
                String str = rs.getString(1);
                if (rs.wasNull()) continue;
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    String s = (String)i.next();
                    if (!str.equals(s)) continue;
                    i.remove();
                    continue block3;
                }
            }
            PreparedStatement pquery = query.getConnection().prepareStatement("SELECT a.LINE FROM ENTRYSFS a,SFCATS b WHERE b.SFCAT=? AND a.SEQ>b.ID ORDER BY a.LINE", 1003, 1007);
            for (String t : list) {
                rc = false;
                pquery.setString(1, t);
                rs = pquery.executeQuery();
                if (rs.next()) {
                    this.fErrs.add(new Error(Severity.ERR, 0, 4, rs.getInt(1), "Missing mandatory saveframe category %s", t));
                    continue;
                }
                this.fErrs.add(new Error(Severity.ERR, 0, 4, 0, "Missing mandatory saveframe category %s", t));
            }
            list.clear();
            pquery.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 0, -1, -1, "Caught exception, check error output"));
            return false;
        }
        return rc;
    }

    private boolean checkOrder(Statement query, ResultSet rs) {
        boolean rc = true;
        try {
            rs = query.executeQuery("SELECT SEQ,LINE,CATEGORY FROM ENTRYSFS ORDER BY LINE");
            int seq = -1;
            String oldcat = null;
            while (rs.next()) {
                rs.getInt(1);
                if (rs.wasNull()) continue;
                if (seq != -1 && seq > rs.getInt(1)) {
                    this.fErrs.add(new Error(Severity.ERR, 0, 5, rs.getInt(2), "Saveframe order error: %s (%d) after %s (%d)", rs.getString(3), rs.getInt(1), oldcat, seq));
                    rc = false;
                }
                seq = rs.getInt(1);
                oldcat = rs.getString(3);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 0, -1, -1, "Caught exception, check error output"));
            return false;
        }
        return rc;
    }

    public boolean validate(Connection conn) {
        try {
            ResultSet rs = null;
            Statement stat = conn.createStatement(1004, 1007);
            boolean rc = this.checkMissingCategories(stat, rs);
            if (!this.checkInvalidCategories(conn, stat, rs)) {
                rc = false;
            }
            if (!this.checkDuplicateNames(stat, rs)) {
                rc = false;
            }
            if (!this.checkInvalidLabels(stat, rs)) {
                rc = false;
            }
            if (!this.checkDuplicateCategories(stat, rs)) {
                rc = false;
            }
            if (!this.checkMandatoryCategories(stat, rs)) {
                rc = false;
            }
            if (!this.checkOrder(stat, rs)) {
                rc = false;
            }
            if (rs != null) {
                rs.close();
            }
            stat.close();
            return rc;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 0, -1, -1, "Caught exception, check error output"));
            return false;
        }
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.CheckSaveFrames [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        CheckSaveFrames chk = new CheckSaveFrames(errs, conf);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        chk.validate(star.getConnection());
        System.err.println("Validated: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
    }
}

