/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.sansj.ContentHandler;
import EDU.bmrb.sansj.DataItemNode;
import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.STARLexer;
import EDU.bmrb.sansj.SansParser;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.DataValidationFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class CheckSaveframeLinks
extends DataValidationFunction
implements ErrorHandler,
ContentHandler {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 13;
    public static final String[] ERRS = new String[]{"Missing local ID value, should be ", "Local IDs do not match: expected ", "Invalid saveframe ID: saveframe not found: ", ": Saveframe ID is not a number", "Missing saveframe name", "Saveframe with no category", "Dictionary error: no local ID tag"};
    private ArrayList<Saveframe> fSfs = null;
    private ArrayList<String> fIdTags = null;
    private String fSfName = null;
    private PreparedStatement fLocalIdQuery = null;
    private boolean fInLoop = false;
    private boolean fCheckLocalIds = false;
    private ArrayList<String> fLinkTags = null;
    private PreparedStatement fSfLinkQuery = null;
    private boolean fCheckLinks = false;
    private PreparedStatement fLinkTgtQuery = null;

    public CheckSaveframeLinks(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = new Integer(13);
        this.fName = CheckSaveframeLinks.className(this.getClass().getName());
        this.init(13);
    }

    public boolean validate(Connection conn, Reader in) {
        try {
            this.fSfs = new ArrayList();
            Statement query = conn.createStatement(1004, 1007);
            PreparedStatement pquery = conn.prepareStatement("SELECT TAGNAME FROM TAGS WHERE SFCAT=? AND LOCALIDFLAG='Y'", 1004, 1007);
            ResultSet rs2 = null;
            ResultSet rs = query.executeQuery("SELECT ID,NAME,CATEGORY,LINE FROM ENTRYSFS ORDER BY ID");
            while (rs.next()) {
                rs.getInt(1);
                if (rs.wasNull()) {
                    this.fErrs.add(new Error(true, 13, 3, rs.getInt(4), rs.getString(1) + ERRS[3]));
                    continue;
                }
                rs.getString(2);
                if (rs.wasNull()) {
                    this.fErrs.add(new Error(true, 13, 4, rs.getInt(4), ERRS[4]));
                    continue;
                }
                rs.getString(3);
                if (rs.wasNull()) {
                    this.fErrs.add(new Error(true, 13, 5, rs.getInt(4), ERRS[5]));
                    continue;
                }
                pquery.setString(1, rs.getString(3));
                rs2 = pquery.executeQuery();
                if (!rs2.next()) {
                    this.fErrs.add(new Error(true, 13, 6, rs.getInt(4), ERRS[6]));
                    continue;
                }
                this.fSfs.add(new Saveframe(rs.getInt(1), rs.getString(2), rs2.getString(1)));
            }
            rs2.close();
            pquery.close();
            rs.close();
            query.close();
            if (this.fSfs.size() < 1) {
                return false;
            }
            this.fIdTags = new ArrayList();
            this.fLinkTags = new ArrayList();
            this.fLocalIdQuery = conn.prepareStatement("SELECT t.NAME FROM ENTRYTAGS t,TAGS d WHERE t.SFID=? AND d.LOCALIDFLAG='Y' AND d.LOOPFLAG='Y' AND t.SEQ=d.SEQ", 1004, 1007);
            this.fSfLinkQuery = conn.prepareStatement("SELECT t.NAME FROM ENTRYTAGS t,TAGS d WHERE t.SFID=? AND d.SFLINKFLAG='Y' AND t.SEQ=d.SEQ", 1004, 1007);
            this.fLinkTgtQuery = conn.prepareStatement("SELECT s.NAME FROM ENTRYSFS s,ENTRYTAGS t,ENTRYTAGS t1,TAGRELS r WHERE t.NAME=? AND r.CHLDSEQ=t.SEQ AND t1.SEQ=r.PRNTSEQ AND s.ID=t1.SFID", 1004, 1007);
            STARLexer lex = new STARLexer(in);
            SansParser p = new SansParser(lex, this, this);
            p.parse();
            this.fSfs.clear();
            this.fSfs = null;
            this.fIdTags = null;
            this.fLinkTags = null;
            this.fLocalIdQuery.close();
            this.fLocalIdQuery = null;
            this.fSfLinkQuery.close();
            this.fSfLinkQuery = null;
            this.fLinkTgtQuery.close();
            this.fLinkTgtQuery = null;
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(true, 13, -1, -1, "DB exception, check error output"));
            return false;
        }
    }

    private void getTagNames() throws SQLException {
        boolean found = false;
        for (Saveframe s : this.fSfs) {
            if (!s.name.equals(this.fSfName)) continue;
            this.fLocalIdQuery.setInt(1, s.number);
            this.fSfLinkQuery.setInt(1, s.number);
            found = true;
            break;
        }
        if (!found) {
            this.fErrs.add(new Error(true, 13, -1, -1, "Saveframe " + this.fSfName + " not found"));
            return;
        }
        ResultSet rs = this.fLocalIdQuery.executeQuery();
        while (rs.next()) {
            this.fIdTags.add(rs.getString(1));
        }
        rs = this.fSfLinkQuery.executeQuery();
        while (rs.next()) {
            this.fLinkTags.add(rs.getString(1));
        }
        rs.close();
        if (this.fIdTags.size() > 0) {
            this.fCheckLocalIds = true;
        }
        if (this.fLinkTags.size() > 0) {
            this.fCheckLinks = true;
        }
    }

    public static void usage() {
        System.err.print("Usage: java EDU.bmrb.validator.functions.CheckSaveframeLinks ");
        System.err.println("[-c FILE] [-i FILE] [-h]");
        System.err.println("  -c FILE: use config FILE instead of ~/validator.conf");
        System.err.println("  -i FILE: input file name (default: stdin)");
        System.err.println("  -h: print this message");
    }

    public static void main(String[] args) {
        try {
            int opt;
            Getopt g = new Getopt("CheckSaveframeLinks", args, "c:i:h");
            String conffile = null;
            String infile = null;
            block6: while ((opt = g.getopt()) != -1) {
                switch (opt) {
                    case 99: {
                        conffile = g.getOptarg();
                        continue block6;
                    }
                    case 105: {
                        infile = g.getOptarg();
                        continue block6;
                    }
                }
                CheckSaveframeLinks.usage();
                return;
            }
            Config conf = conffile == null ? new Config() : new Config(conffile);
            ErrorList errs = new ErrorList();
            BufferedReader in = infile == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(infile));
            long start = System.currentTimeMillis();
            Star_DB star = new Star_DB(conf.getProperties());
            star.connect(true);
            System.err.println("DB open: " + (System.currentTimeMillis() - start));
            CheckSaveframeLinks chk = new CheckSaveframeLinks(errs, conf);
            chk.validate(star.getConnection(), in);
            System.err.println("Validated: " + (System.currentTimeMillis() - start));
            star.disconnect();
            ((Reader)in).close();
            if (errs.size() > 0) {
                errs.sort();
                errs.printErrors(System.out);
            }
            System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void error(int param, int param1, String str) {
        this.fErrs.add(new Error(true, 13, -1, param, str));
        System.err.print("Parse error in line ");
        System.err.print(param);
        System.err.print(", col ");
        System.err.print(param1);
        System.err.print(": ");
        System.err.println(str);
    }

    public boolean warning(int param, int param1, String str) {
        this.fErrs.add(new Error(false, 13, -1, param, str));
        System.err.print("Parse warning in line ");
        System.err.print(param);
        System.err.print(", col ");
        System.err.print(param1);
        System.err.print(": ");
        System.err.println(str);
        return false;
    }

    public boolean startSaveFrame(int param, String str) {
        this.fSfName = str;
        try {
            this.getTagNames();
            return false;
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(true, 13, -1, param, "DB exception, check error output"));
            return false;
        }
    }

    public boolean endSaveFrame(int param, String str) {
        this.fIdTags.clear();
        this.fLinkTags.clear();
        this.fSfName = null;
        this.fCheckLocalIds = false;
        this.fCheckLinks = false;
        return false;
    }

    public boolean startLoop(int param) {
        this.fInLoop = true;
        return false;
    }

    public boolean endLoop(int param) {
        this.fInLoop = false;
        return false;
    }

    public boolean data(DataItemNode node) {
        String localid;
        if (this.fInLoop && this.fCheckLocalIds) {
            for (int i = 0; i < this.fIdTags.size(); ++i) {
                if (!this.fIdTags.get(i).equals(node.getName())) continue;
                for (Saveframe s : this.fSfs) {
                    if (!s.name.equals(this.fSfName)) continue;
                    try {
                        localid = node.getValue();
                        if (s.localid.equals(localid)) continue;
                        this.fErrs.add(new Error(true, 13, 1, node.getValueLine(), ERRS[1] + s.localid));
                    }
                    catch (NumberFormatException e) {
                        this.fErrs.add(new Error(true, 13, 0, node.getValueLine(), ERRS[0] + s.localid));
                    }
                }
            }
        }
        if (this.fCheckLinks) {
            for (String tag : this.fLinkTags) {
                if (!tag.equals(node.getName())) continue;
                boolean found = false;
                try {
                    localid = node.getValue();
                    try {
                        this.fLinkTgtQuery.setString(1, node.getName());
                        ResultSet rs = this.fLinkTgtQuery.executeQuery();
                        block9: while (rs.next()) {
                            for (Saveframe s : this.fSfs) {
                                if (!s.name.equals(rs.getString(1)) || !s.localid.equals(localid)) continue;
                                found = true;
                                break block9;
                            }
                        }
                        if (found) continue;
                        this.fErrs.add(new Error(true, 13, 2, node.getValueLine(), ERRS[2] + node.getName() + "=" + node.getValue()));
                    }
                    catch (SQLException se) {
                        System.err.println(se.getMessage());
                        se.printStackTrace();
                        this.fErrs.add(new Error(true, 13, -1, node.getValueLine(), "DB exception, check error output"));
                    }
                }
                catch (NumberFormatException e) {
                    this.fErrs.add(new Error(true, 13, 3, node.getValueLine(), node.getName() + ERRS[3]));
                }
            }
        }
        return false;
    }

    public boolean comment(int param, String str) {
        return false;
    }

    public void endData(int param, String str) {
    }

    public boolean startData(int param, String str) {
        return false;
    }

    class Saveframe {
        public int number = -1;
        public String name = null;
        public String localid = null;

        public Saveframe(int num, String label, String id) {
            this.number = num;
            this.name = label;
            this.localid = id;
        }
    }
}

