/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.sansj.ContentHandler;
import EDU.bmrb.sansj.DataItemNode;
import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.STARLexer;
import EDU.bmrb.sansj.SansParser;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.DataValidationFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Severity;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CheckShiftStats
extends DataValidationFunction
implements ErrorHandler,
ContentHandler {
    private static final boolean DEBUG = false;
    private static final boolean PROFILE = false;
    public static final int NUMBER = 20;
    public static final String TAG_SHIFTID = "_Atom_chem_shift.ID";
    public static final String TAG_ENTITYID = "_Atom_chem_shift.Entity_ID";
    public static final String TAG_SEQNO = "_Atom_chem_shift.Comp_index_ID";
    public static final String TAG_RESLABEL = "_Atom_chem_shift.Comp_ID";
    public static final String TAG_ATOM = "_Atom_chem_shift.Atom_ID";
    public static final String TAG_TYPE = "_Atom_chem_shift.Atom_type";
    public static final String TAG_SHIFTVAL = "_Atom_chem_shift.Val";
    private String fSfName = null;
    private boolean fInLoop = false;
    private boolean fInShifts = false;
    private String fEntityId = null;
    private String fLastEntityId = null;
    private String fLastEntityType = null;
    private boolean fFirstRow = true;
    private Row fLastRow = null;
    private String fLabel = null;
    private String fAtom = null;
    private float fShift = Float.NaN;
    private boolean fWarnNonPolymer = true;
    private PreparedStatement fEntityQuery = null;
    private PreparedStatement fRestypeQuery = null;
    private PreparedStatement fShiftQuery = null;
    private ResultSet rs = null;

    public CheckShiftStats(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = 20;
        this.fName = CheckShiftStats.className(this.getClass().getName());
        this.init(20);
    }

    public boolean validate(Connection conn, Reader in) {
        long start = System.currentTimeMillis();
        try {
            if (this.fEntityQuery == null) {
                this.fEntityQuery = conn.prepareStatement("SELECT v.VAL FROM ENTRYVALS v JOIN ENTRYTAGS t ON v.TAGID=t.ID WHERE t.NAME='_Entity.ID' AND v.VAL=?", 1003, 1007);
            }
            if (this.fRestypeQuery == null) {
                this.fRestypeQuery = conn.prepareStatement("SELECT ENTITY FROM ENTRYRESTYPES WHERE EID=?", 1003, 1007);
            }
            if (this.fShiftQuery == null) {
                this.fShiftQuery = conn.prepareStatement("SELECT s.SHIFTAVG,s.SHIFTSTD FROM CHEMSHIFTS s JOIN ATOMS a  ON a.ID=s.ATOMID JOIN RESIDUES r ON r.ID=a.RESID JOIN RESTYPES t  ON t.ID=r.TYPEID WHERE t.NAME=? AND r.LABEL=? AND a.NAME=?", 1003, 1007);
            }
            STARLexer lex = new STARLexer(in);
            SansParser p = new SansParser(lex, this, this);
            p.parse();
            if (this.rs != null) {
                this.rs.close();
            }
            this.fShiftQuery.close();
            this.fShiftQuery = null;
            this.fRestypeQuery.close();
            this.fRestypeQuery = null;
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 20, -1, -1, "Caught exception, check error output"));
            return false;
        }
    }

    public void error(int param, int param1, String str) {
        this.fErrs.add(new Error(Severity.CRIT, 20, -1, param, str));
        System.err.printf("Parse error in line %d, col %d: %s\n", param, param1, str);
    }

    public boolean warning(int param, int param1, String str) {
        this.fErrs.add(new Error(Severity.ERR, 20, -1, param, str));
        System.err.printf("Parse warning in line %d, col %d: %s\n", param, param1, str);
        return false;
    }

    public boolean startSaveFrame(int param, String str) {
        this.fSfName = str;
        return false;
    }

    public boolean endSaveFrame(int param, String str) {
        this.fSfName = null;
        return false;
    }

    public boolean startLoop(int param) {
        this.fInLoop = true;
        this.fFirstRow = true;
        return false;
    }

    public boolean endLoop(int param) {
        if (this.fInShifts) {
            this.checkShift();
        }
        this.fInLoop = false;
        this.fInShifts = false;
        return false;
    }

    public boolean data(DataItemNode node) {
        if (!this.fInLoop) {
            return false;
        }
        if (node.getName().equals(TAG_SHIFTID)) {
            this.fInShifts = true;
            if (this.fInShifts) {
                if (this.fLastRow == null) {
                    this.fLastRow = new Row();
                }
                if (this.fFirstRow) {
                    this.fFirstRow = false;
                } else {
                    this.checkShift();
                }
            }
        }
        if (this.fInShifts) {
            if (node.getName().equals(TAG_ENTITYID)) {
                if (node.getValue() == null || node.getValue().equals("?") || node.getValue().equals(".")) {
                    this.fErrs.add(new Error(Severity.ERR, 20, 0, node.getValueLine(), "Entity ID is not a number: %s", node.getValue()));
                    this.fEntityId = null;
                } else {
                    this.fEntityId = node.getValue();
                }
            }
            if (node.getName().equals(TAG_SEQNO)) {
                if (this.fLastRow == null || this.fLastRow.seq == null) {
                    this.fWarnNonPolymer = true;
                } else if (!this.fLastRow.seq.equals(node.getValue())) {
                    this.fWarnNonPolymer = true;
                }
                this.fLastRow.seq = node.getValue();
            }
            if (node.getName().equals(TAG_RESLABEL)) {
                this.fLastRow.label = node.getValue();
            }
            if (node.getName().equals(TAG_ATOM)) {
                this.fLastRow.atom = node.getValue();
            }
            if (node.getName().equals(TAG_TYPE)) {
                this.fLastRow.type = node.getValue();
            }
            if (node.getName().equals(TAG_SHIFTVAL)) {
                try {
                    this.fLastRow.shift = Float.parseFloat(node.getValue());
                }
                catch (NumberFormatException e) {
                    this.fLastRow.shift = Float.NaN;
                }
                this.fLastRow.line = node.getValueLine();
            }
        }
        return false;
    }

    public boolean comment(int param, String str) {
        return false;
    }

    public boolean startData(int param, String str) {
        return false;
    }

    public void endData(int param, String str) {
    }

    private void checkShift() {
        if (this.fLastRow != null && this.fEntityId != null) {
            try {
                if (Float.isNaN(this.fLastRow.shift)) {
                    this.fErrs.add(new Error(Severity.ERR, 20, 1, this.fLastRow.line, "Shift value is not a number: %s", this.fLastRow));
                    return;
                }
                String tmp = null;
                StringBuffer buf = new StringBuffer();
                if (!this.fEntityId.equals(this.fLastEntityId)) {
                    this.fEntityQuery.setString(1, this.fEntityId);
                    this.rs = this.fEntityQuery.executeQuery();
                    if (!this.rs.next()) {
                        this.fErrs.add(new Error(Severity.ERR, 20, 2, this.fLastRow.line, "Invalid entity ID"));
                        return;
                    }
                    this.fLastEntityId = this.fEntityId;
                    this.fRestypeQuery.setString(1, this.fEntityId);
                    this.rs = this.fRestypeQuery.executeQuery();
                    if (this.rs.next()) {
                        tmp = this.rs.getString(1);
                        if (this.rs.wasNull()) {
                            tmp = null;
                        }
                    }
                    if (tmp == null) {
                        if (this.fWarnNonPolymer) {
                            this.fErrs.add(new Error(Severity.WARN, 20, 5, this.fLastRow.line, "Cannot check shift value for %s", this.fLastRow.label));
                        }
                        this.fWarnNonPolymer = false;
                        return;
                    }
                    this.fLastEntityType = tmp.indexOf("polypeptide") > -1 ? "polypeptide" : tmp;
                }
                float avg = Float.NaN;
                float std = Float.NaN;
                this.fShiftQuery.setString(1, this.fLastEntityType);
                this.fShiftQuery.setString(2, this.fLastRow.label);
                this.fShiftQuery.setString(3, this.fLastRow.atom);
                this.rs = this.fShiftQuery.executeQuery();
                if (this.rs.next()) {
                    avg = this.rs.getFloat(1);
                    if (this.rs.wasNull()) {
                        avg = Float.NaN;
                    }
                    std = this.rs.getFloat(2);
                    if (this.rs.wasNull()) {
                        std = Float.NaN;
                    }
                }
                if (Float.isNaN(avg) || Float.isNaN(std)) {
                    this.fErrs.add(new Error(Severity.WARN, 20, 3, this.fLastRow.line, "No shift statistics for %s", this.fLastRow));
                } else {
                    float min = avg - std * 5.0f;
                    float max = avg + std * 5.0f;
                    if (this.fLastRow.shift < min || this.fLastRow.shift > max) {
                        buf.setLength(0);
                        buf.append("Chemical shift value out of range [");
                        buf.append(avg);
                        buf.append(" +/- 5*");
                        buf.append(std);
                        buf.append("]: ");
                        if (buf.length() < 65) {
                            for (int i = buf.length(); i < 65; ++i) {
                                buf.append(' ');
                            }
                        }
                        buf.append(this.fLastRow);
                        this.fErrs.add(new Error(Severity.ERR, 20, 4, this.fLastRow.line, buf.toString()));
                    }
                }
            }
            catch (SQLException e) {
                this.fErrs.add(new Error(Severity.CRIT, 20, -1, this.fLastRow.line, "DB exception, check error output"));
                System.err.println(e);
                e.printStackTrace();
                return;
            }
        }
        this.fLabel = null;
        this.fAtom = null;
        this.fEntityId = null;
        this.fShift = Float.NaN;
        this.fLastRow = new Row();
    }

    public static void usage() {
        System.err.print("Usage: java EDU.bmrb.validator.functions.CheckShiftStats ");
        System.err.println("[-c FILE] [-i FILE] [-h]");
        System.err.println("  -c FILE: use config FILE instead of ~/validator.conf");
        System.err.println("  -i FILE: input file name (default: stdin)");
        System.err.println("  -h: print this message");
    }

    public static void main(String[] args) {
        try {
            int opt;
            Getopt g = new Getopt("CheckShiftStats", args, "c:i:h");
            String conffile = null;
            String infile = null;
            block6: while ((opt = g.getopt()) != -1) {
                switch (opt) {
                    case 99: {
                        conffile = g.getOptarg();
                        continue block6;
                    }
                    case 105: {
                        infile = g.getOptarg();
                        continue block6;
                    }
                }
                CheckShiftStats.usage();
                return;
            }
            Config conf = conffile == null ? new Config() : new Config(conffile);
            ErrorList errs = new ErrorList();
            BufferedReader in = infile == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(infile));
            long start = System.currentTimeMillis();
            Star_DB star = new Star_DB(conf.getProperties());
            star.connect(true);
            CheckShiftStats chk = new CheckShiftStats(errs, conf);
            chk.validate(star.getConnection(), in);
            star.disconnect();
            ((Reader)in).close();
            if (errs.size() > 0) {
                errs.sort();
                errs.printErrors(System.out);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    class Row {
        int line = -1;
        String seq = null;
        String label = null;
        String atom = null;
        String type = null;
        float shift = Float.NaN;

        Row() {
        }

        public String toString() {
            int i;
            StringBuilder buf = new StringBuilder();
            if (Integer.toString(this.line).length() < 6) {
                for (i = Integer.toString(this.line).length(); i < 6; ++i) {
                    buf.append(' ');
                }
            }
            buf.append(this.seq);
            if (this.seq.length() < 5) {
                for (i = this.seq.length(); i < 5; ++i) {
                    buf.append(' ');
                }
            }
            buf.append(' ');
            buf.append(this.label);
            if (this.label.length() < 3) {
                for (i = this.seq.length(); i < 3; ++i) {
                    buf.append(' ');
                }
            }
            buf.append("  ");
            buf.append(this.atom);
            if (this.atom.length() < 2) {
                for (i = this.atom.length(); i < 2; ++i) {
                    buf.append(' ');
                }
            }
            buf.append("  ");
            buf.append(this.type);
            if (this.type.length() < 2) {
                for (i = this.type.length(); i < 2; ++i) {
                    buf.append(' ');
                }
            }
            buf.append("  ");
            if (!Float.isNaN(this.shift)) {
                buf.append(this.shift);
                if (Float.toString(this.shift).length() < 9) {
                    for (i = Float.toString(this.shift).length(); i < 9; ++i) {
                        buf.append(' ');
                    }
                }
            } else {
                buf.append(".        ");
            }
            buf.append("  ");
            return buf.toString();
        }
    }
}

