/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Severity;
import EDU.bmrb.validator.ValidationFunction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

public class CheckTagOrder
extends ValidationFunction {
    public static final int NUMBER = 5;

    public CheckTagOrder(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = 5;
        this.fName = CheckTagOrder.className(this.getClass().getName());
        this.init(5);
    }

    public boolean validate(Connection conn) {
        ResultSet rs = null;
        boolean rc = true;
        try {
            Statement stat = conn.createStatement(1004, 1007);
            rs = stat.executeQuery("SELECT LINE,SEQ,SFID,NAME FROM ENTRYTAGS WHERE SEQ IS NOT NULL ORDER BY SFID,LINE");
            int lastsfid = -1;
            int lastseq = -1;
            String lasttag = null;
            while (rs.next()) {
                if (lastsfid < 0 || rs.getInt(3) != lastsfid) {
                    lastsfid = rs.getInt(3);
                    lastseq = -1;
                }
                if (lastseq >= 0 && rs.getInt(2) < lastseq) {
                    this.fErrs.add(new Error(Severity.ERR, 5, 0, rs.getInt(1), "Invalid tag order: %s (%d) should be before %s (%d)", rs.getString(4), rs.getInt(2), lasttag, lastseq));
                    rc = false;
                }
                lastseq = rs.getInt(2);
                lasttag = rs.getString(4);
            }
            stat.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.ERR, 5, -1, -1, "DB exception, check error output"));
            return false;
        }
        return rc;
    }

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        Config conf = null;
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.CheckTagOrder [config file]");
                System.exit(1);
            } else {
                conf = new Config(args[0]);
            }
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        CheckTagOrder chk = new CheckTagOrder(errs, conf);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        chk.validate(star.getConnection());
        System.err.println("Validated: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
    }
}

