/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.ValidationFunction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

public class CheckThrHg
extends ValidationFunction {
    public static final int NUMBER = 25;
    public static final String TAG_RESLABEL = "_Atom_chem_shift.Comp_ID";
    public static final String TAG_ATOMNAME = "_Atom_chem_shift.Atom_ID";
    public static final String RESIDUE = "THR";
    public static final String ATOM = "HG1";
    public static final String[] ERRS = new String[]{"Found THR HG1", "No atom name for residue (loop count error?)", "No residue name (loop count error?)"};

    public CheckThrHg(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = new Integer(25);
        this.fName = CheckThrHg.className(this.getClass().getName());
        this.init(25);
    }

    public boolean validate(Connection conn) {
        boolean rc = true;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        StringBuffer sql = new StringBuffer();
        try {
            Statement stat1 = conn.createStatement(1004, 1007);
            Statement stat2 = conn.createStatement(1004, 1007);
            sql.append("SELECT v.LINE, v.VAL FROM ENTRYVALS v, ENTRYTAGS t WHERE t.NAME = '");
            sql.append(TAG_RESLABEL);
            sql.append("' AND t.ID = v.TAGID ORDER BY v.ID");
            rs1 = stat1.executeQuery(sql.toString());
            sql.setLength(0);
            sql.append("SELECT v.LINE, v.VAL FROM ENTRYVALS v, ENTRYTAGS t WHERE t.NAME = '");
            sql.append(TAG_ATOMNAME);
            sql.append("' AND t.ID = v.TAGID ORDER BY v.ID");
            rs2 = stat2.executeQuery(sql.toString());
            while (rs1.next()) {
                if (!rs2.next()) {
                    this.fErrs.add(new Error(true, 25, 1, rs1.getInt(1), ERRS[1]));
                    continue;
                }
                String str = rs1.getString(2);
                if (rs1.wasNull()) {
                    this.fErrs.add(new Error(true, 25, 2, rs1.getInt(1), ERRS[2]));
                    continue;
                }
                if (!str.equals(RESIDUE)) continue;
                str = rs2.getString(2);
                if (rs2.wasNull()) {
                    this.fErrs.add(new Error(true, 25, 1, rs2.getInt(1), ERRS[1]));
                    continue;
                }
                if (!str.equals(ATOM)) continue;
                this.fErrs.add(new Error(false, 25, 0, rs2.getInt(1), ERRS[0]));
                rc = false;
            }
            stat1.close();
            stat2.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(false, 25, -1, -1, "DB exception, check error output"));
            return false;
        }
        return rc;
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.CheckThrHg [config file]");
                System.err.println("Error messages:");
                for (int i = 0; i < ERRS.length; ++i) {
                    System.err.println(ERRS[i]);
                }
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        CheckThrHg chk = new CheckThrHg(errs, conf);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        chk.validate(star.getConnection());
        System.err.println("Validated: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
    }
}

