/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class EditExperimentNames
extends EditingFunction {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 94;
    public static final String TAG_ID = "_Experiment.ID";
    public static final String TAG_NAME = "_Experiment.Name";
    public static final String TAG_SAMPLE = "_Experiment.Sample_label";
    public static final String TAG_COND = "_Experiment.Sample_condition_list_label";
    public static final String CTAG_ID = "%.Experiment_ID";
    public static final String CTAG_NAME = "%.Experiment_name";
    private int fIdTagId = -1;
    private int fNameTagId = -1;
    private int fSampleTagId = -1;
    private int fCondTagId = -1;
    private PreparedStatement fTagidQuery = null;
    private PreparedStatement fValQuery = null;
    private PreparedStatement fExpQuery = null;
    private PreparedStatement fStat = null;

    public EditExperimentNames(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(94);
        this.fName = EditExperimentNames.className(this.getClass().getName());
        this.init(94);
    }

    public boolean edit(boolean interactive) {
        try {
            this.fTagidQuery = this.fStar.getPreparedQuery("SELECT e.ID FROM ENTRYTAGS e,TAGS t WHERE e.SFID=? AND t.TAGCAT=? AND e.NAME LIKE ? AND e.SEQ=t.SEQ");
            this.fValQuery = this.fStar.getPreparedQuery("SELECT ID,LOOPROW,VAL,LINE FROM ENTRYVALS WHERE TAGID=? ORDER BY LOOPROW");
            boolean rc = true;
            ArrayList<Integer> sfids = new ArrayList<Integer>();
            ArrayList<String> tagcats = new ArrayList<String>();
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery("SELECT e.SFID,t2.TAGCAT FROM ENTRYTAGS e,TAGS t1,TAGS t2,TAGRELS r WHERE t1.TAGNAME='_Experiment.ID' AND r.PRNTSEQ=t1.SEQ AND t2.SEQ=r.CHLDSEQ AND e.SEQ=t2.SEQ ORDER BY e.SFID");
            while (rs.next()) {
                sfids.add(rs.getInt(1));
                tagcats.add(rs.getString(2));
            }
            query.close();
            if (tagcats.size() < 1) {
                return true;
            }
            PreparedStatement pquery = this.fStar.getPreparedQuery("SELECT ID FROM ENTRYTAGS WHERE NAME=?");
            pquery.setString(1, TAG_ID);
            rs = pquery.executeQuery();
            if (rs.next()) {
                this.fIdTagId = rs.getInt(1);
                if (rs.wasNull()) {
                    this.fIdTagId = -1;
                }
            }
            pquery.setString(1, TAG_NAME);
            rs = pquery.executeQuery();
            if (rs.next()) {
                this.fNameTagId = rs.getInt(1);
                if (rs.wasNull()) {
                    this.fNameTagId = -1;
                }
            }
            pquery.setString(1, TAG_SAMPLE);
            rs = pquery.executeQuery();
            if (rs.next()) {
                this.fSampleTagId = rs.getInt(1);
                if (rs.wasNull()) {
                    this.fSampleTagId = -1;
                }
            }
            pquery.setString(1, TAG_COND);
            rs = pquery.executeQuery();
            if (rs.next()) {
                this.fCondTagId = rs.getInt(1);
                if (rs.wasNull()) {
                    this.fCondTagId = -1;
                }
            }
            rs.close();
            pquery.close();
            if (this.fIdTagId < 0 || this.fNameTagId < 0 || this.fSampleTagId < 0 || this.fCondTagId < 0) {
                if (this.fErrs != null) {
                    this.fErrs.add(new Error(true, 94, 1, -1, "Invalid or missing _Experiment loop"));
                }
                return false;
            }
            this.fExpQuery = this.fStar.getPreparedQuery("SELECT v1.VAL,v2.VAL,v3.VAL,v4.VAL FROM ENTRYVALS v1,ENTRYVALS v2,ENTRYVALS v3,ENTRYVALS v4 WHERE v1.TAGID=" + this.fIdTagId + " AND v2.TAGID=" + this.fNameTagId + " AND " + "v3.TAGID=" + this.fSampleTagId + " AND v4.TAGID=" + this.fCondTagId + " AND " + "v2.LOOPID=v1.LOOPID AND v3.LOOPID=v2.LOOPID AND v4.LOOPID=v3.LOOPID " + "AND v2.LOOPROW=v1.LOOPROW AND v3.LOOPROW=v2.LOOPROW AND v4.LOOPROW=" + "v3.LOOPROW");
            this.fStat = this.fStar.getPreparedStatement("UPDATE ENTRYVALS SET VAL=? WHERE TAGID=? AND LOOPROW=?");
            if (tagcats.size() != sfids.size()) {
                System.err.printf("EditExperimentNames ERROR: %d saveframes, %d tag categories (numbers don't match)\n", sfids.size(), tagcats.size());
            }
            for (int i = 0; i < tagcats.size(); ++i) {
                if (this.fixTable((Integer)sfids.get(i), (String)tagcats.get(i))) continue;
                rc = false;
            }
            sfids.clear();
            tagcats.clear();
            this.fTagidQuery.close();
            this.fValQuery.close();
            this.fExpQuery.close();
            if (!this.fStat.getConnection().getAutoCommit()) {
                this.fStat.getConnection().commit();
            }
            this.fStat.close();
            return rc;
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 94, -1, -1, "DB exception, check error output"));
            }
            return false;
        }
    }

    private boolean fixTable(int sfid, String tagcat) throws SQLException {
        boolean rc = true;
        ResultSet exp_rs = null;
        this.fTagidQuery.setInt(1, sfid);
        this.fTagidQuery.setString(2, tagcat);
        this.fTagidQuery.setString(3, CTAG_ID);
        ResultSet rs = this.fTagidQuery.executeQuery();
        rs.next();
        int idid = rs.getInt(1);
        this.fTagidQuery.setString(3, CTAG_NAME);
        rs = this.fTagidQuery.executeQuery();
        rs.next();
        int nameid = rs.getInt(1);
        this.fValQuery.setInt(1, nameid);
        rs = this.fValQuery.executeQuery();
        while (rs.next()) {
            String name = rs.getString(3);
            if (rs.wasNull() || name.equals("?") || name.equals(".")) continue;
            String[] fields = name.split(";\\s");
            if (fields.length != 3) {
                System.err.printf("EditExperimentNames ERROR: %d fields in experiment name (%s)\n", fields.length, tagcat);
                for (int i = 0; i < fields.length; ++i) {
                    System.err.println(fields[i]);
                }
                continue;
            }
            fields[1] = fields[1].replaceAll("\\s", "_");
            fields[2] = fields[2].replaceAll("\\s", "_");
            String str = null;
            exp_rs = this.fExpQuery.executeQuery();
            while (exp_rs.next()) {
                str = exp_rs.getString(2);
                if (exp_rs.wasNull() || str.equals(".") || str.equals("?") || !str.equals(fields[0])) continue;
                str = exp_rs.getString(3);
                if (exp_rs.wasNull() || str.equals(".") || str.equals("?") || !str.equals(fields[1])) continue;
                str = exp_rs.getString(4);
                if (exp_rs.wasNull() || str.equals(".") || str.equals("?") || !str.equals(fields[2])) continue;
                str = exp_rs.getString(1);
                if (!exp_rs.wasNull() && !str.equals(".") && !str.equals("?")) break;
                str = null;
                break;
            }
            if (str == null) {
                if (this.fErrs != null) {
                    this.fErrs.add(new Error(true, 94, 2, rs.getInt(4), "No matching row in _Experiment loop"));
                } else {
                    System.err.printf("ERR:%d:2:%d:No row in _Experiment loop for %s, %s, %s\n", 94, rs.getInt(4), fields[0], fields[1], fields[2]);
                }
                rc = false;
                continue;
            }
            this.fStat.setString(1, str);
            this.fStat.setInt(2, idid);
            this.fStat.setInt(3, rs.getInt(2));
            this.fStat.executeUpdate();
            this.fStat.setString(1, fields[0]);
            this.fStat.setInt(2, nameid);
            this.fStat.setInt(3, rs.getInt(2));
            this.fStat.executeUpdate();
        }
        rs.close();
        if (exp_rs != null) {
            exp_rs.close();
        }
        return rc;
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.FixExperimentNames [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        EditExperimentNames fn = new EditExperimentNames(errs, conf, star);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        boolean rc = fn.edit(false);
        System.err.println("Edited: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        if (!rc) {
            System.exit(1);
        }
    }
}

