/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Entry;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class InsertDataSetCount
extends EditingFunction {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 88;
    public static final String[] ERRS = new String[]{"Dictionary problem, cannot continue", "entry_information saveframe does not exists. Insert saveframe and try again.", "Cannot insert loop.", "No data saveframes"};
    public static final String DATASET_SFCAT = "entry_information";
    public static final String DATASET_TYPE_TAG = "_Data_set.Type";
    public static final String DATASET_COUNT_TAG = "_Data_set.Count";
    public static final String DATASET_ENTRYID_TAG = "_Data_set.Entry_ID";
    public static final String DATASET_SFID_TAG = "_Data_set.Sf_ID";
    private ArrayList fSfcats = null;
    private ArrayList fCounts = null;
    private StringBuffer fBuf = null;

    public InsertDataSetCount(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(88);
        this.fName = InsertDataSetCount.className(this.getClass().getName());
        this.init(88);
        this.fSfcats = new ArrayList();
        this.fCounts = new ArrayList();
        this.fBuf = new StringBuffer();
    }

    private boolean countDataSets() throws SQLException {
        ResultSet countrs;
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT SEQ FROM TAGS WHERE TAGNAME='");
        this.fBuf.append(DATASET_TYPE_TAG);
        this.fBuf.append("' AND SFCAT='");
        this.fBuf.append(DATASET_SFCAT);
        this.fBuf.append('\'');
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        if (!rs.next()) {
            this.fErrs.add(new Error(true, 88, 0, -1, ERRS[0]));
            return false;
        }
        int seq = rs.getInt(1);
        if (rs.wasNull()) {
            this.fErrs.add(new Error(true, 88, 0, -1, ERRS[0]));
            return false;
        }
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT VAL FROM VALENUMS WHERE SEQ=");
        this.fBuf.append(seq);
        rs = query.executeQuery(this.fBuf.toString());
        if (!rs.next()) {
            this.fErrs.add(new Error(true, 88, 0, -1, ERRS[0]));
            return false;
        }
        Statement counts = this.fStar.getQueryStatement();
        do {
            this.fBuf.setLength(0);
            this.fBuf.append("SELECT COUNT(*) FROM ENTRYSFS WHERE CATEGORY='");
            this.fBuf.append(rs.getString(1));
            this.fBuf.append('\'');
            countrs = counts.executeQuery(this.fBuf.toString());
            if (!countrs.next()) continue;
            int num = countrs.getInt(1);
            if (countrs.wasNull() || num <= 0) continue;
            this.fSfcats.add(rs.getString(1));
            this.fCounts.add(new Integer(num));
        } while (rs.next());
        countrs.close();
        counts.close();
        rs.close();
        query.close();
        if (this.fSfcats.size() < 1) {
            this.fErrs.add(new Error(true, 88, 3, -1, ERRS[3]));
            return false;
        }
        return true;
    }

    private int getTagId(int seq) throws SQLException {
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT ID FROM ENTRYTAGS WHERE SEQ=");
        this.fBuf.append(seq);
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        int rc = -1;
        if (rs.next()) {
            rc = rs.getInt(1);
            if (rs.wasNull()) {
                rc = -1;
            }
        }
        rs.close();
        query.close();
        return rc;
    }

    private int getLoopId(String sfcat, String tag) throws SQLException {
        int pos = tag.indexOf(46);
        if (pos < 0) {
            return -1;
        }
        String tagcat = tag.substring(0, pos);
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT LOOPID FROM ENTRYTAGS t,ENTRYSFS s WHERE s.CATEGORY='");
        this.fBuf.append(sfcat);
        this.fBuf.append("' AND t.NAME LIKE '");
        this.fBuf.append(tagcat);
        this.fBuf.append("%' AND s.ID=t.SFID");
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        int rc = -1;
        if (rs.next()) {
            rc = rs.getInt(1);
            if (rs.wasNull()) {
                rc = -1;
            }
        }
        rs.close();
        query.close();
        return rc;
    }

    private int getSaveframeId(String sfcat, String tag) throws SQLException {
        int pos = tag.indexOf(46);
        if (pos < 0) {
            return -1;
        }
        String tagcat = tag.substring(0, pos);
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT ID FROM ENTRYSFS WHERE CATEGORY='");
        this.fBuf.append(sfcat);
        this.fBuf.append("' ORDER BY ID");
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        int rc = -1;
        if (rs.next()) {
            rc = rs.getInt(1);
            if (rs.wasNull()) {
                rc = -1;
            }
        }
        rs.close();
        query.close();
        return rc;
    }

    private boolean addLoop(int sfid, String tag) throws Exception {
        int pos = tag.indexOf(46);
        if (pos < 0) {
            return false;
        }
        String tagcat = tag.substring(0, pos);
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT CATEGORY,NAME FROM ENTRYSFS WHERE ID=");
        this.fBuf.append(sfid);
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        rs.next();
        String sfcat = rs.getString(1);
        String sfname = rs.getString(2);
        rs.close();
        int loopid = Entry.insertLoop(this.fStar, sfid, tag);
        Statement stat = this.fStar.getStatement();
        this.fBuf.setLength(0);
        this.fBuf.append("DELETE FROM ENTRYVALS WHERE LOOPID=");
        this.fBuf.append(loopid);
        stat.executeUpdate(this.fBuf.toString());
        stat.getConnection().commit();
        stat.close();
        int type_id = Entry.getTagID(this.fStar, sfid, DATASET_TYPE_TAG);
        int count_id = Entry.getTagID(this.fStar, sfid, DATASET_COUNT_TAG);
        int entryid_id = Entry.getTagID(this.fStar, sfid, DATASET_ENTRYID_TAG);
        int entryid_seq = Entry.getTagNumber(this.fStar, entryid_id);
        int sfid_id = Entry.getTagID(this.fStar, sfid, DATASET_SFID_TAG);
        int sfid_seq = Entry.getTagNumber(this.fStar, sfid_id);
        String entry_id = null;
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT v.VAL FROM ENTRYVALS v, TAGRELS t ");
        this.fBuf.append(" WHERE v.SEQ=t.PRNTSEQ AND t.CHLDSEQ=");
        this.fBuf.append(entryid_seq);
        rs = query.executeQuery(this.fBuf.toString());
        if (rs.next()) {
            entry_id = rs.getString(1);
            if (rs.wasNull()) {
                entry_id = null;
            }
        }
        String sf_id = null;
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT v.VAL FROM ENTRYVALS v,TAGRELS t ");
        this.fBuf.append(" WHERE v.SEQ=t.PRNTSEQ AND t.CHLDSEQ=");
        this.fBuf.append(sfid_seq);
        rs = query.executeQuery(this.fBuf.toString());
        if (rs.next()) {
            sf_id = rs.getString(1);
            if (rs.wasNull()) {
                sf_id = null;
            }
        }
        rs.close();
        query.close();
        for (int i = 0; i < this.fSfcats.size(); ++i) {
            Entry.insertLoopRow(this.fStar, loopid, i);
            Entry.insertLoopValue(this.fStar, loopid, type_id, i, (String)this.fSfcats.get(i));
            Entry.insertLoopValue(this.fStar, loopid, count_id, i, ((Integer)this.fCounts.get(i)).toString());
            if (entry_id != null) {
                Entry.insertLoopValue(this.fStar, loopid, entryid_id, i, entry_id);
            }
            if (sf_id == null) continue;
            Entry.insertLoopValue(this.fStar, loopid, sfid_id, i, sf_id);
        }
        return true;
    }

    public boolean edit(boolean interactive) {
        try {
            if (!this.countDataSets()) {
                return false;
            }
            int[] sfids = Entry.getSaveframeIDs(this.fStar, DATASET_SFCAT);
            if (sfids == null) {
                this.fErrs.add(new Error(true, 88, 1, -1, ERRS[1]));
                return false;
            }
            int[] loopids = Entry.getLoopIDs(this.fStar, sfids[0], DATASET_COUNT_TAG);
            if (loopids != null) {
                for (int i = 0; i < loopids.length; ++i) {
                    this.fBuf.setLength(0);
                    this.fBuf.append("DELETE FROM ENTRYLOOPS WHERE ID=");
                    this.fBuf.append(loopids[i]);
                    Statement stat = this.fStar.getStatement();
                    stat.executeUpdate(this.fBuf.toString());
                    stat.getConnection().commit();
                    this.fBuf.setLength(0);
                    this.fBuf.append("DELETE FROM ENTRYTAGS WHERE LOOPID=");
                    this.fBuf.append(loopids[i]);
                    stat.executeUpdate(this.fBuf.toString());
                    stat.getConnection().commit();
                    stat.close();
                }
            }
            return this.addLoop(sfids[0], DATASET_COUNT_TAG);
        }
        catch (Exception e) {
            this.fErrs.add(new Error(true, 88, -1, -1, "DB exception, check error output"));
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.InsertDataSetCount [config file]");
                System.err.println("Error messages:");
                for (int i = 0; i < ERRS.length; ++i) {
                    System.err.println(ERRS[i]);
                }
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        InsertDataSetCount fn = new InsertDataSetCount(errs, conf, star);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        boolean rc = fn.edit(false);
        System.err.println("Edited: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        if (!rc) {
            System.exit(1);
        }
    }
}

