/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Entry;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.stardb.Tag;
import EDU.bmrb.stardb.sdbException;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class InsertResidueLoop
extends EditingFunction {
    private static final boolean DEBUG = false;
    public static final String ENTITY_SFCAT = "entity";
    public static final String TAG_EID = "_Entity.ID";
    public static final String TAG_SEQ = "_Entity.Polymer_seq_one_letter_code";
    public static final String TAG_SEQCAN = "_Entity.Polymer_seq_one_letter_code_can";
    public static final String TAG_SFID = "_Entity_poly_seq.Sf_ID";
    public static final String TAG_ENTRYID = "_Entity_poly_seq.Entry_ID";
    public static final String TAG_ENTITYID = "_Entity_poly_seq.Entity_ID";
    public static final String TAG_IDX = "_Entity_poly_seq.Num";
    public static final String TAG_IDX1 = "_Entity_poly_seq.Comp_index_ID";
    public static final String TAG_LABEL = "_Entity_poly_seq.Mon_ID";
    public static final String TAG_SFID2 = "_Entity_comp_index.Sf_ID";
    public static final String TAG_ENTRYID2 = "_Entity_comp_index.Entry_ID";
    public static final String TAG_ENTITYID2 = "_Entity_comp_index.Entity_ID";
    public static final String TAG_IDX2 = "_Entity_comp_index.ID";
    public static final String TAG_LABEL2 = "_Entity_comp_index.Comp_ID";
    public static final String[] ERRS = new String[]{"Residue loop already exists (poly_seq)", "No residue sequence", "No entity ID", "No residue type", "Invalid residue sequence", "Residue loop already exists (comp_index)", "No valid Comp_index loop"};
    public static final int NUMBER = 95;
    private StringBuffer fBuf = null;

    public InsertResidueLoop(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(95);
        this.fName = InsertResidueLoop.className(this.getClass().getName());
        this.init(95);
        this.fBuf = new StringBuffer();
    }

    public boolean edit(boolean interactive) {
        try {
            boolean rc = true;
            this.fBuf.setLength(0);
            this.fBuf.append("SELECT ID,LINE FROM ENTRYSFS WHERE CATEGORY='");
            this.fBuf.append(ENTITY_SFCAT);
            this.fBuf.append("' ORDER BY ID");
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery(this.fBuf.toString());
            while (rs.next()) {
                if (this.updateSaveframe(rs.getInt(1), rs.getInt(2))) continue;
                rc = false;
            }
            rs.close();
            query.close();
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 95, -1, -1, "DB exception, check error output"));
            }
            return false;
        }
    }

    public boolean updateSaveframe(int sfid, int sfline) throws SQLException, sdbException {
        int seqidcan = Entry.getTagID(this.fStar, sfid, TAG_SEQCAN);
        int seqid = Entry.getTagID(this.fStar, sfid, TAG_SEQ);
        if (seqidcan < 0 && seqid < 0) {
            this.fErrs.add(new Error(false, 95, 1, sfline, ERRS[1]));
            return false;
        }
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT v.VAL,v.LINE FROM ENTRYVALS v,ENTRYTAGS t WHERE t.NAME='");
        this.fBuf.append(TAG_EID);
        this.fBuf.append("' AND t.SFID=");
        this.fBuf.append(sfid);
        this.fBuf.append(" AND v.TAGID=t.ID");
        int eid = -1;
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        if (rs.next()) {
            try {
                eid = Integer.parseInt(rs.getString(1));
            }
            catch (NumberFormatException ne) {
                if (this.fErrs != null) {
                    this.fErrs.add(new Error(true, 95, 3, rs.getInt(2), ERRS[3]));
                }
                rs.close();
                query.close();
                return false;
            }
            if (rs.wasNull()) {
                eid = -1;
            }
        }
        if (eid < 0) {
            rs.close();
            query.close();
            this.fErrs.add(new Error(false, 95, 2, sfline, ERRS[2]));
            return false;
        }
        String seq = null;
        if (seqid >= 0) {
            this.fBuf.setLength(0);
            this.fBuf.append("SELECT VAL FROM ENTRYVALS WHERE TAGID=");
            this.fBuf.append(seqid);
            rs = query.executeQuery(this.fBuf.toString());
            if (rs.next()) {
                seq = rs.getString(1);
                if (rs.wasNull()) {
                    seq = null;
                }
            }
        }
        if (seq != null && (seq.equals("?") || seq.equals("."))) {
            seq = null;
        }
        if (seq == null) {
            this.fBuf.setLength(0);
            this.fBuf.append("SELECT VAL FROM ENTRYVALS WHERE TAGID=");
            this.fBuf.append(seqidcan);
            rs = query.executeQuery(this.fBuf.toString());
            if (rs.next()) {
                seq = rs.getString(1);
                if (rs.wasNull()) {
                    seq = null;
                }
            }
        }
        rs.close();
        query.close();
        if (seq != null && (seq.equals("?") || seq.equals(".") || seq.equals(""))) {
            seq = null;
        }
        if (seq == null) {
            this.fErrs.add(new Error(false, 95, 1, sfline, ERRS[1]));
            return false;
        }
        if ((seq = seq.trim()).charAt(0) == '>') {
            int pos = seq.indexOf("\n");
            if (pos < 0) {
                this.fErrs.add(new Error(false, 95, 4, sfline, ERRS[4]));
                return false;
            }
            seq = seq.substring(0, pos);
        }
        seq = seq.replaceAll("\\s+", "");
        seq = seq.toUpperCase();
        StringBuffer newseq = new StringBuffer();
        boolean skip = false;
        for (int i = 0; i < seq.length(); ++i) {
            if (seq.substring(i, i + 1).equals("(")) {
                skip = true;
            }
            if (skip) {
                if (!seq.substring(i, i + 1).equals(")")) continue;
                skip = false;
                newseq.append("X");
                continue;
            }
            newseq.append(seq.substring(i, i + 1));
        }
        this.insertCompIndexLoop(sfid, sfline, newseq.toString());
        this.insertPolySeqLoop(sfid, sfline);
        return true;
    }

    public boolean insertCompIndexLoop(int sfid, int sfline, String seq) throws SQLException, sdbException {
        int loopid = Entry.getTagID(this.fStar, sfid, TAG_LABEL2);
        if (loopid >= 0) {
            this.fErrs.add(new Error(false, 95, 5, sfline, ERRS[5]));
            return false;
        }
        loopid = Entry.insertLoopTags(this.fStar, sfid, TAG_LABEL2);
        boolean skip = false;
        Tag[] tags = Entry.getLoopTags(this.fStar, loopid);
        PreparedStatement pstat = this.fStar.getPreparedStatement("UPDATE ENTRYVALS SET VAL=? WHERE LOOPROW=? AND TAGID=?");
        for (int seqno = 0; seqno < seq.length(); ++seqno) {
            Entry.insertLoopRow(this.fStar, loopid, seqno + 1);
            for (int i = 0; i < tags.length; ++i) {
                if (tags[i].getName().equals(TAG_IDX2)) {
                    pstat.setString(1, Integer.toString(seqno + 1));
                    pstat.setInt(2, seqno + 1);
                    pstat.setInt(3, tags[i].getId());
                    pstat.executeUpdate();
                    continue;
                }
                if (!tags[i].getName().equals(TAG_LABEL2)) continue;
                String code = seqno == seq.length() ? seq.substring(seqno) : seq.substring(seqno, seqno + 1);
                if (code.equals("(") && !skip) {
                    skip = true;
                }
                if (code.equals(")") && skip) {
                    skip = false;
                }
                if (skip) continue;
                pstat.setString(1, code);
                pstat.setInt(2, seqno + 1);
                pstat.setInt(3, tags[i].getId());
                pstat.executeUpdate();
            }
        }
        if (!pstat.getConnection().getAutoCommit()) {
            pstat.getConnection().commit();
        }
        pstat.close();
        return true;
    }

    public boolean insertPolySeqLoop(int sfid, int sfline) throws SQLException, sdbException {
        int[] loopids = Entry.getLoopIDs(this.fStar, sfid, TAG_LABEL);
        if (loopids != null) {
            Statement stat = this.fStar.getStatement();
            for (int i = 0; i < loopids.length; ++i) {
                this.fBuf.setLength(0);
                this.fBuf.append("DELETE FROM ENTRYTAGS WHERE LOOPID=");
                this.fBuf.append(loopids[i]);
                stat.executeUpdate(this.fBuf.toString());
                this.fBuf.setLength(0);
                this.fBuf.append("DELETE FROM ENTRYLOOPS WHERE ID=");
                this.fBuf.append(loopids[i]);
                stat.executeUpdate(this.fBuf.toString());
            }
            if (!stat.getConnection().getAutoCommit()) {
                stat.getConnection().commit();
            }
            stat.close();
            loopids = null;
        }
        int seqid = Entry.getTagID(this.fStar, sfid, TAG_IDX2);
        int labid = Entry.getTagID(this.fStar, sfid, TAG_LABEL2);
        if (seqid < 0 || labid < 0) {
            this.fErrs.add(new Error(false, 95, 6, sfline, ERRS[6]));
            return false;
        }
        int loopid = Entry.insertLoopTags(this.fStar, sfid, TAG_LABEL);
        seqid = Entry.getTagID(this.fStar, sfid, TAG_IDX);
        int idxid = Entry.getTagID(this.fStar, sfid, TAG_IDX1);
        labid = Entry.getTagID(this.fStar, sfid, TAG_LABEL);
        PreparedStatement pstat = this.fStar.getPreparedStatement("UPDATE ENTRYVALS SET VAL=? WHERE TAGID=? AND LOOPROW=?");
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT v1.VAL,v2.VAL FROM ENTRYTAGS t1,ENTRYTAGS t2,ENTRYVALS v1,ENTRYVALS v2 WHERE t1.SFID=");
        this.fBuf.append(sfid);
        this.fBuf.append(" AND t2.SFID=");
        this.fBuf.append(sfid);
        this.fBuf.append(" AND t1.NAME='");
        this.fBuf.append(TAG_IDX2);
        this.fBuf.append("' AND t2.NAME='");
        this.fBuf.append(TAG_LABEL2);
        this.fBuf.append("' AND v1.TAGID=t1.ID AND v2.TAGID=t2.ID AND v1.LOOPROW=v2.LOOPROW ORDER BY v1.LOOPROW");
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        int row = 0;
        while (rs.next()) {
            Entry.insertLoopRow(this.fStar, loopid, row + 1);
            pstat.setString(1, rs.getString(1));
            pstat.setInt(2, seqid);
            pstat.setInt(3, row + 1);
            pstat.executeUpdate();
            pstat.setString(1, rs.getString(1));
            pstat.setInt(2, idxid);
            pstat.setInt(3, row + 1);
            pstat.executeUpdate();
            pstat.setString(1, rs.getString(2));
            pstat.setInt(2, labid);
            pstat.setInt(3, row + 1);
            pstat.executeUpdate();
            ++row;
        }
        rs.close();
        query.close();
        if (!pstat.getConnection().getAutoCommit()) {
            pstat.getConnection().commit();
        }
        pstat.close();
        return true;
    }

    public void insertLoop(int sfid, String seq, boolean poly_seq) throws SQLException, sdbException {
        int loopid = Entry.insertLoopTags(this.fStar, sfid, poly_seq ? TAG_LABEL : TAG_LABEL2);
        Tag[] tags = Entry.getLoopTags(this.fStar, loopid);
        this.fBuf.setLength(0);
        this.fBuf.append("UPDATE ENTRYVALS SET VAL=? WHERE LOOPROW=? AND TAGID=?");
        PreparedStatement pstat = this.fStar.getPreparedStatement(this.fBuf.toString());
        for (int seqno = 0; seqno < seq.length(); ++seqno) {
            Entry.insertLoopRow(this.fStar, loopid, seqno + 1);
            for (int i = 0; i < tags.length; ++i) {
                if (tags[i].getName().equals(poly_seq ? TAG_IDX : TAG_IDX2)) {
                    pstat.setString(1, Integer.toString(seqno + 1));
                    pstat.setInt(2, seqno + 1);
                    pstat.setInt(3, tags[i].getId());
                    pstat.executeUpdate();
                    continue;
                }
                if (tags[i].getName().equals(TAG_IDX1)) {
                    pstat.setString(1, Integer.toString(seqno + 1));
                    pstat.setInt(2, seqno + 1);
                    pstat.setInt(3, tags[i].getId());
                    pstat.executeUpdate();
                    continue;
                }
                if (!tags[i].getName().equals(poly_seq ? TAG_LABEL : TAG_LABEL2)) continue;
                if (seqno == seq.length()) {
                    pstat.setString(1, seq.substring(seqno).toUpperCase());
                } else {
                    pstat.setString(1, seq.substring(seqno, seqno + 1).toUpperCase());
                }
                pstat.setInt(2, seqno + 1);
                pstat.setInt(3, tags[i].getId());
                pstat.executeUpdate();
            }
        }
        pstat.getConnection().commit();
        pstat.close();
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.print("Usage: java ");
                System.err.print(InsertResidueLoop.class.getName());
                System.err.println(" [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        InsertResidueLoop fn = new InsertResidueLoop(errs, conf, star);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        boolean rc = fn.edit(false);
        System.err.println("Edited: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        if (!rc) {
            System.exit(1);
        }
    }
}

