/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Entry;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.sql.ResultSet;
import java.sql.Statement;

public class InsertSaveframeIDs
extends EditingFunction {
    public static final int NUMBER = 92;
    private StringBuffer fBuf = null;

    public InsertSaveframeIDs(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(92);
        this.fName = InsertSaveframeIDs.className(this.getClass().getName());
        this.init(92);
        this.fBuf = new StringBuffer();
    }

    public boolean edit(boolean interactive) {
        try {
            int sfid = -1;
            Statement stat = this.fStar.getStatement();
            Statement tagquery = this.fStar.getQueryStatement();
            ResultSet tagrs = null;
            Statement sfquery = this.fStar.getQueryStatement();
            ResultSet sfrs = sfquery.executeQuery("SELECT ID,CATEGORY FROM ENTRYSFS WHERE CATEGORY IS NOT NULL");
            while (sfrs.next()) {
                int tagnum;
                int tagid;
                this.fBuf.setLength(0);
                this.fBuf.append("SELECT e.ID,e.SEQ FROM ENTRYTAGS e,TAGS t WHERE e.SFID=");
                this.fBuf.append(sfrs.getInt(1));
                this.fBuf.append(" AND t.SFIDFLAG='Y' AND t.LOOPFLAG<>'Y' AND e.SEQ=t.SEQ");
                tagrs = tagquery.executeQuery(this.fBuf.toString());
                if (!tagrs.next()) {
                    this.fBuf.setLength(0);
                    this.fBuf.append("SELECT SEQ,TAGNAME FROM TAGS WHERE SFCAT='");
                    this.fBuf.append(sfrs.getString(2));
                    this.fBuf.append("' AND SFIDFLAG='Y' AND LOOPFLAG<>'Y'");
                    tagrs = tagquery.executeQuery(this.fBuf.toString());
                    tagrs.next();
                    tagid = this.fStar.nextId("ENTRYTAGS");
                    tagnum = tagrs.getInt(1);
                    this.fBuf.setLength(0);
                    this.fBuf.append("INSERT INTO ENTRYTAGS(ID,SFID,SEQ,NAME,LINE) VALUES(");
                    this.fBuf.append(tagid);
                    this.fBuf.append(',');
                    this.fBuf.append(sfrs.getInt(1));
                    this.fBuf.append(',');
                    this.fBuf.append(tagnum);
                    this.fBuf.append(",'");
                    this.fBuf.append(tagrs.getString(2));
                    this.fBuf.append("',0)");
                    stat.executeUpdate(this.fBuf.toString());
                    stat.getConnection().commit();
                } else {
                    tagid = tagrs.getInt(1);
                    tagnum = tagrs.getInt(2);
                }
                Entry.insertFreeValue(this.fStar, tagid, Integer.toString(sfid));
                this.fBuf.setLength(0);
                this.fBuf.append("SELECT CHLDSEQ FROM TAGRELS WHERE PRNTSEQ=");
                this.fBuf.append(tagnum);
                tagrs = tagquery.executeQuery(this.fBuf.toString());
                while (tagrs.next()) {
                    tagid = Entry.getTagID(this.fStar, sfrs.getInt(1), tagrs.getInt(1));
                    if (tagid < 0) continue;
                    this.fBuf.setLength(0);
                    this.fBuf.append("UPDATE ENTRYVALS SET VAL='");
                    this.fBuf.append(sfid);
                    this.fBuf.append("' WHERE TAGID=");
                    this.fBuf.append(tagid);
                    stat.executeUpdate(this.fBuf.toString());
                    stat.getConnection().commit();
                }
                --sfid;
            }
            if (sfrs != null) {
                sfrs.close();
            }
            sfquery.close();
            if (tagrs != null) {
                tagrs.close();
            }
            tagquery.close();
            stat.close();
            return true;
        }
        catch (Exception e) {
            this.fErrs.add(new Error(true, 92, -1, -1, "DB exception, check error output"));
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.print("Usage: java ");
                System.err.print(InsertSaveframeIDs.class.getName());
                System.err.println(" [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        InsertSaveframeIDs fn = new InsertSaveframeIDs(errs, conf, star);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        boolean rc = fn.edit(false);
        System.err.println("Edited: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        if (!rc) {
            System.exit(1);
        }
    }
}

