/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class RemoveEmptyTags
extends EditingFunction {
    public static final int NUMBER = 70;
    private StringBuffer fBuf = null;
    private List fCondLoops = null;

    public RemoveEmptyTags(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(70);
        this.fName = RemoveEmptyTags.className(this.getClass().getName());
        this.init(70);
        this.fBuf = new StringBuffer();
        this.fCondLoops = new ArrayList();
    }

    public boolean edit(boolean interactive) {
        try {
            this.deleteFreeTags();
            Statement stat = this.fStar.getStatement();
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery("SELECT ID,NAME FROM ENTRYSFS WHERE SEQ IS NOT NULL ORDER BY ID");
            while (rs.next()) {
                System.err.println("\n***\n\nworking on saveframe " + rs.getInt(1) + ", " + rs.getString(2));
                this.deleteEmptyLoops(rs.getInt(1));
                if (!this.hasNonDefaultValues(rs.getInt(1))) {
                    System.err.println("checking loops, list is");
                    for (int i = 0; i < this.fCondLoops.size(); ++i) {
                        System.err.print(this.fCondLoops.get(i) + "\t");
                    }
                    System.err.println();
                    if (!this.hasNonEmptyLoops(rs.getInt(1))) {
                        System.err.println("removing saveframe " + rs.getInt(1) + ", " + rs.getString(2));
                        this.fBuf.setLength(0);
                        this.fBuf.append("DELETE FROM ENTRYSFS WHERE ID=");
                        this.fBuf.append(rs.getInt(1));
                        stat.executeUpdate(this.fBuf.toString());
                        stat.getConnection().commit();
                        continue;
                    }
                    System.err.println("*** saveframe " + rs.getInt(1) + " has non-empty loops" + ", " + rs.getString(2));
                    continue;
                }
                System.err.println("** saveframe " + rs.getInt(1) + " has non-default values" + ", " + rs.getString(2));
            }
            rs.close();
            query.close();
            stat.close();
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 70, -1, -1, "DB exception, check error output"));
            }
            return false;
        }
    }

    public void deleteEmptyLoops(int sfid) throws SQLException {
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT ID FROM ENTRYLOOPS WHERE SFID=");
        this.fBuf.append(sfid);
        this.fBuf.append(" ORDER BY ID");
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        while (rs.next()) {
            this.trimLoop(rs.getInt(1));
        }
        rs.close();
        query.close();
    }

    public void trimLoop(int loopid) throws SQLException {
        boolean has_values = false;
        boolean has_rows = false;
        boolean has_mandatory_tags = false;
        boolean has_conditional_tags = false;
        boolean has_valid_tags = false;
        int current_row = -1;
        ArrayList<Integer> empty_rows = new ArrayList<Integer>();
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT MANDATORY FROM ENTRYMANDATORY WHERE SEQ=?");
        PreparedStatement manquery = this.fStar.getPreparedQuery(this.fBuf.toString());
        ResultSet manrs = null;
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT ADITAUTO,ADITDEFAULT FROM TAGS WHERE SEQ=?");
        PreparedStatement defquery = this.fStar.getPreparedQuery(this.fBuf.toString());
        ResultSet defrs = null;
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT ID,SEQ,VAL,LOOPROW FROM ENTRYVALS WHERE LOOPID=");
        this.fBuf.append(loopid);
        this.fBuf.append(" ORDER BY LOOPROW,SEQ");
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        while (rs.next()) {
            String str;
            if (current_row < 0) {
                current_row = rs.getInt(4);
            } else if (current_row != rs.getInt(4)) {
                if (has_values) {
                    has_rows = true;
                } else {
                    empty_rows.add(new Integer(current_row));
                }
                has_values = false;
                System.err.println("* Loop " + loopid + " new row " + current_row);
                current_row = rs.getInt(4);
            }
            rs.getInt(2);
            if (rs.wasNull()) {
                rs.close();
                query.close();
                if (defrs != null) {
                    defrs.close();
                }
                defquery.close();
                System.err.println("! invalid tag");
                return;
            }
            if (current_row == 0) {
                manquery.setInt(1, rs.getInt(2));
                manrs = manquery.executeQuery();
                if (!manrs.next()) {
                    throw new SQLException("Tag # " + rs.getInt(2) + " not in dictionary");
                }
                str = manrs.getString(1).trim();
                if (!str.equals("I")) {
                    has_valid_tags = true;
                }
                if (str.equals("M") || str.equals("V")) {
                    has_mandatory_tags = true;
                }
                if (str.equals("C") || str.equals("R")) {
                    has_conditional_tags = true;
                }
            }
            defquery.setInt(1, rs.getInt(2));
            defrs = defquery.executeQuery();
            defrs.next();
            str = rs.getString(3);
            System.err.println("--- Checking default value " + str);
            if (!(rs.wasNull() || str.trim().equals(".") || str.trim().equals("?"))) {
                str = defrs.getString(1);
                if (!defrs.wasNull() && str.trim().equals("Y")) {
                    str = defrs.getString(2);
                    if (!defrs.wasNull() && !str.equals(rs.getString(3))) {
                        System.err.println("Loop " + loopid + " has non-default value " + rs.getString(3));
                        has_values = true;
                    }
                } else {
                    System.err.println("Loop " + loopid + " has value " + rs.getString(3));
                    has_values = true;
                }
            }
            System.err.println("** Loop " + loopid + " row " + current_row);
        }
        System.err.println("Loop " + loopid + " last row " + current_row);
        if (has_values) {
            has_rows = true;
        } else {
            empty_rows.add(new Integer(current_row));
        }
        System.err.println("** Loop " + loopid + " row " + current_row + " empty rows: ");
        for (int i = 0; i < empty_rows.size(); ++i) {
            System.err.println(empty_rows.get(i));
        }
        System.err.flush();
        rs.close();
        query.close();
        if (manrs != null) {
            manrs.close();
        }
        manquery.close();
        if (defrs != null) {
            defrs.close();
        }
        defquery.close();
        Statement stat = this.fStar.getStatement();
        if (has_rows) {
            for (int i = 0; i < empty_rows.size(); ++i) {
                System.err.println("deleting empty rows from loop " + loopid);
                this.fBuf.setLength(0);
                this.fBuf.append("DELETE FROM ENTRYVALS WHERE LOOPID=");
                this.fBuf.append(loopid);
                this.fBuf.append(" AND LOOPROW=");
                this.fBuf.append((Integer)empty_rows.get(i));
                stat.executeUpdate(this.fBuf.toString());
            }
        } else {
            this.fBuf.setLength(0);
            System.err.println("deleting rows  > 0 from empty loop " + loopid);
            this.fBuf.append("DELETE FROM ENTRYVALS WHERE LOOPID=");
            this.fBuf.append(loopid);
            this.fBuf.append(" AND LOOPROW>0");
            stat.executeUpdate(this.fBuf.toString());
        }
        stat.getConnection().commit();
        System.err.println("** Loop " + loopid + " has_rows " + has_rows + " has_mandatory_tags " + has_mandatory_tags + " has_conditional_tags " + has_conditional_tags + " has_valid_tags " + has_valid_tags);
        if (!has_valid_tags || !has_mandatory_tags && !has_rows && !has_conditional_tags) {
            System.err.println("removing empty loop " + loopid);
            this.fBuf.setLength(0);
            this.fBuf.append("DELETE FROM ENTRYTAGS WHERE LOOPID=");
            this.fBuf.append(loopid);
            stat.executeUpdate(this.fBuf.toString());
            this.fBuf.setLength(0);
            this.fBuf.append("DELETE FROM ENTRYLOOPS WHERE ID=");
            this.fBuf.append(loopid);
            stat.executeUpdate(this.fBuf.toString());
            stat.getConnection().commit();
        }
        stat.close();
        if (has_conditional_tags && !has_mandatory_tags && !has_rows) {
            System.err.println("saving conditional loop id for later check: " + loopid);
            this.fCondLoops.add(new Integer(loopid));
        }
    }

    private void deleteFreeTags() throws SQLException {
        this.fBuf.setLength(0);
        Statement query = this.fStar.getQueryStatement();
        this.fBuf.append("SELECT DISTINCT t.ID FROM ENTRYTAGS t,ENTRYMANDATORY m,ENTRYVALS v ");
        this.fBuf.append("WHERE (m.MANDATORY='I' OR m.MANDATORY='O') ");
        this.fBuf.append("AND m.LOOPFLAG<>'Y' ");
        this.fBuf.append("AND t.SEQ=m.SEQ AND (v.VAL IS NULL OR v.VAL='?') ");
        this.fBuf.append("AND v.TAGID=t.ID");
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        Statement stat = this.fStar.getStatement();
        while (rs.next()) {
            this.fBuf.setLength(0);
            this.fBuf.append("DELETE FROM ENTRYTAGS WHERE ID=");
            this.fBuf.append(rs.getInt(1));
            stat.executeUpdate(this.fBuf.toString());
        }
        stat.getConnection().commit();
        rs.close();
        stat.close();
        query.close();
    }

    private boolean isDefaultValue(int seq, String val) throws SQLException {
        boolean rc = false;
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT ADITAUTO,ADITDEFAULT FROM TAGS WHERE SEQ=");
        this.fBuf.append(seq);
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        if (rs.next()) {
            String str = rs.getString(1);
            if (!rs.wasNull() && str.equals("Y")) {
                str = rs.getString(2);
                if (rs.wasNull()) {
                    rc = true;
                } else if (str.equals(val)) {
                    rc = true;
                }
            }
        }
        rs.close();
        query.close();
        System.err.println("Default value for " + seq + "," + val + " is " + rc);
        return rc;
    }

    private boolean hasNonDefaultValues(int sfid) throws SQLException {
        boolean rc = false;
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT v.SEQ,v.VAL FROM ENTRYVALS v, ENTRYTAGS t WHERE ");
        this.fBuf.append("t.SFID=");
        this.fBuf.append(sfid);
        this.fBuf.append(" AND v.LOOPID IS NULL AND v.VAL IS NOT NULL AND v.VAL<>'?' ");
        this.fBuf.append("AND t.ID=v.TAGID");
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        while (rs.next()) {
            int seq = rs.getInt(1);
            if (rs.wasNull()) {
                rc = true;
                break;
            }
            if (this.isDefaultValue(seq, rs.getString(2))) continue;
            rc = true;
            break;
        }
        rs.close();
        query.close();
        return rc;
    }

    public boolean hasNonEmptyLoops(int sfid) throws SQLException {
        boolean found = false;
        boolean rc = false;
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT ID FROM ENTRYLOOPS WHERE SFID=");
        this.fBuf.append(sfid);
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        while (rs.next()) {
            System.err.println("checking loop " + rs.getInt(1));
            found = false;
            for (int i = 0; i < this.fCondLoops.size(); ++i) {
                if (rs.getInt(1) != ((Integer)this.fCondLoops.get(i)).intValue()) continue;
                found = true;
                System.err.println("loop in the list " + rs.getInt(1));
                this.fCondLoops.remove(i);
                break;
            }
            if (found) continue;
            rc = true;
        }
        rs.close();
        query.close();
        return rc;
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.RemoveEmptyTags [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        RemoveEmptyTags fn = new RemoveEmptyTags(errs, conf, star);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        boolean rc = fn.edit(false);
        System.err.println("Edited: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        if (!rc) {
            System.exit(1);
        }
    }
}

