/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.Dictionary;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;

public class TrimAditDeposition
extends EditingFunction {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 69;
    private StringBuffer fBuf = null;

    public TrimAditDeposition(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(69);
        this.fName = TrimAditDeposition.className(this.getClass().getName());
        this.init(69);
        this.fBuf = new StringBuffer();
    }

    public boolean edit(boolean interactive) {
        try {
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery("SELECT s.ID,s.NAME FROM ENTRYSFS s,SFCATS d WHERE s.SEQ IS NOT NULL AND d.MANDATORY<>'M' AND s.SEQ=d.ID ORDER BY s.ID");
            while (rs.next()) {
                this.removeEmptySf(rs.getInt(1));
            }
            Statement stat = this.fStar.getStatement();
            stat.executeUpdate("DELETE FROM ENTRYTAGS WHERE SEQ IN (SELECT SEQ FROM TAGS WHERE LOOPFLAG='Y' AND SFIDFLAG='Y')");
            stat.getConnection().commit();
            stat.close();
            rs = query.executeQuery("SELECT ID FROM ENTRYLOOPS ORDER BY ID");
            while (rs.next()) {
                if (!this.deleteEmptyRows(rs.getInt(1))) continue;
                this.removeEmptyLoop(rs.getInt(1));
            }
            rs.close();
            query.close();
            this.deleteLoopCols();
            this.deleteFreeTags();
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 69, -1, -1, "DB exception, check error output"));
            }
            return false;
        }
    }

    public void removeEmptySf(int sfid) throws SQLException {
        boolean has_data = false;
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT v.ID,t.SEQ,m.MANDATORY,s.CATEGORY FROM ENTRYVALS v,ENTRYTAGS t,TAGS m,ENTRYSFS s WHERE t.SFID=");
        this.fBuf.append(sfid);
        this.fBuf.append(" AND v.VAL IS NOT NULL AND v.VAL<>'.' AND v.VAL<>'?' AND (m.ADITAUTO<>'Y' OR (m.ADITAUTO='Y' AND m.ADITDEFAULT IS NOT NULL AND m.ADITDEFAULT<>v.VAL)) AND m.SFLABELFLAG<>'Y' AND t.SEQ IS NOT NULL AND v.TAGID=t.ID AND v.SEQ=m.SEQ AND s.ID=");
        this.fBuf.append(sfid);
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        while (rs.next()) {
            char mandatory = Dictionary.checkOverride(this.fStar.getConnection(), rs.getString(4), sfid, rs.getInt(2));
            if (mandatory == '\u0000') {
                mandatory = rs.getString(3).charAt(0);
            }
            if (mandatory == 'I') continue;
            has_data = true;
            break;
        }
        Statement stat = this.fStar.getStatement();
        if (!has_data) {
            this.fBuf.setLength(0);
            this.fBuf.append("DELETE FROM ENTRYSFS WHERE ID=");
            this.fBuf.append(sfid);
            stat.executeUpdate(this.fBuf.toString());
        }
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT DISTINCT s.ID FROM ENTRYSFS s,ENTRYTAGS t WHERE s.ID NOT IN (SELECT DISTINCT SFID FROM ENTRYTAGS)");
        rs = query.executeQuery(this.fBuf.toString());
        while (rs.next()) {
            rs.getInt(1);
            if (rs.wasNull()) continue;
            this.fBuf.setLength(0);
            this.fBuf.append("DELETE FROM ENTRYSFS WHERE ID=");
            this.fBuf.append(rs.getInt(1));
            stat.executeUpdate(this.fBuf.toString());
        }
        stat.getConnection().commit();
        stat.close();
        rs.close();
        query.close();
    }

    public boolean deleteEmptyRows(int loopid) throws SQLException {
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT MAX(LOOPROW) FROM ENTRYVALS WHERE LOOPID=");
        this.fBuf.append(loopid);
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        rs.next();
        int maxrow = rs.getInt(1);
        query.close();
        boolean empty_loop = false;
        boolean has_rows = false;
        this.fBuf.setLength(0);
        this.fBuf.append("DELETE FROM ENTRYVALS WHERE LOOPID=");
        this.fBuf.append(loopid);
        this.fBuf.append(" AND LOOPROW=?");
        PreparedStatement pstat = this.fStar.getPreparedStatement(this.fBuf.toString());
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT v.VAL FROM ENTRYVALS v,TAGS t WHERE v.SEQ IS NOT NULL ");
        this.fBuf.append(" AND v.LOOPID=");
        this.fBuf.append(loopid);
        this.fBuf.append(" AND v.LOOPROW=? AND v.VAL IS NOT NULL AND v.VAL<>'.' AND");
        this.fBuf.append(" v.VAL<>'?' AND (t.ADITAUTO<>'Y' OR (t.ADITAUTO='Y' AND");
        this.fBuf.append(" t.ADITDEFAULT IS NOT NULL AND t.ADITDEFAULT<>v.VAL)) AND");
        this.fBuf.append(" v.VAL<>'pH' AND v.SEQ=t.SEQ");
        PreparedStatement pquery = this.fStar.getPreparedQuery(this.fBuf.toString());
        for (int i = maxrow; i >= 0; --i) {
            pquery.setInt(1, i);
            rs = pquery.executeQuery();
            if (rs.next()) {
                has_rows = true;
                continue;
            }
            if (has_rows) {
                pstat.setInt(1, i);
                pstat.executeUpdate();
                continue;
            }
            if (i > 0) {
                pstat.setInt(1, i);
                pstat.executeUpdate();
                continue;
            }
            empty_loop = true;
        }
        pstat.getConnection().commit();
        pstat.close();
        rs.close();
        pquery.close();
        return empty_loop;
    }

    public void removeEmptyLoop(int loopid) throws SQLException {
        char mandatory = '\u0000';
        boolean has_mandatory_tag = false;
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT d.MANDATORY,d.SFCAT,t.SFID,t.SEQ,t.NAME FROM TAGS d,ENTRYTAGS t WHERE t.LOOPID=");
        this.fBuf.append(loopid);
        this.fBuf.append(" AND d.SEQ=t.SEQ");
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        while (rs.next()) {
            mandatory = Dictionary.checkOverride(this.fStar.getConnection(), rs.getString(2), rs.getInt(3), rs.getInt(4));
            if (mandatory == '\u0000') {
                mandatory = rs.getString(1).charAt(0);
            }
            if (mandatory == 'I' || mandatory == 'O') continue;
            has_mandatory_tag = true;
            break;
        }
        if (!has_mandatory_tag) {
            this.fBuf.setLength(0);
            this.fBuf.append("SELECT NAME FROM ENTRYTAGS WHERE LOOPID=");
            this.fBuf.append(loopid);
            this.fBuf.append(" AND NAME LIKE '_Bond.%'");
            rs = query.executeQuery(this.fBuf.toString());
            if (rs.next()) {
                rs = query.executeQuery("SELECT v.VAL FROM ENTRYVALS v,ENTRYTAGS t WHERE (t.NAME='_Entity.Polymer_seq_one_letter_code' OR t.NAME='_Entity.Polymer_seq_one_letter_code_can') AND v.TAGID=t.ID");
                while (rs.next()) {
                    int count = 0;
                    String seq = rs.getString(1);
                    if (rs.wasNull()) continue;
                    for (int i = 0; i < seq.length(); ++i) {
                        if (seq.toUpperCase().charAt(i) != 'C') continue;
                        ++count;
                    }
                    if (count <= true) continue;
                    has_mandatory_tag = true;
                    break;
                }
            }
        }
        rs.close();
        query.close();
        if (!has_mandatory_tag) {
            Statement stat = this.fStar.getStatement();
            this.fBuf.setLength(0);
            this.fBuf.append("DELETE FROM ENTRYTAGS WHERE LOOPID=");
            this.fBuf.append(loopid);
            stat.executeUpdate(this.fBuf.toString());
            this.fBuf.setLength(0);
            this.fBuf.append("DELETE FROM ENTRYLOOPS WHERE ID=");
            this.fBuf.append(loopid);
            stat.executeUpdate(this.fBuf.toString());
            stat.getConnection().commit();
            stat.close();
        }
    }

    public void deleteFreeTags() throws SQLException {
        char mandatory = '\u0000';
        PreparedStatement pstat = this.fStar.getPreparedStatement("DELETE FROM ENTRYTAGS WHERE ID=?");
        this.fBuf.setLength(0);
        Statement query = this.fStar.getQueryStatement();
        this.fBuf.append("SELECT t.ID,d.MANDATORY,t.SFID,d.SFCAT,t.SEQ FROM ENTRYTAGS t,ENTRYVALS v,TAGS d WHERE d.LOOPFLAG<>'Y' AND d.SFLINKFLAG<>'Y' AND d.VALTYPE<>'FRAMECODE' AND (v.VAL IS NULL OR v.VAL='.' OR v.VAL='?' OR (d.ADITAUTO='Y' AND d.ADITDEFAULT IS NULL) OR (d.ADITDEFAULT IS NOT NULL AND v.VAL=d.ADITDEFAULT)) AND t.SEQ=d.SEQ AND v.TAGID=t.ID");
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        while (rs.next()) {
            mandatory = Dictionary.checkOverride(this.fStar.getConnection(), rs.getString(4), rs.getInt(3), rs.getInt(5));
            if (mandatory == '\u0000') {
                mandatory = rs.getString(2).charAt(0);
            }
            if (mandatory != 'O' && mandatory != 'I') continue;
            pstat.setInt(1, rs.getInt(1));
            pstat.executeUpdate();
        }
        pstat.getConnection().commit();
        pstat.close();
        rs.close();
        query.close();
    }

    public void deleteLoopCols() throws SQLException {
        ArrayList<Integer> loopids = new ArrayList<Integer>();
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery("SELECT DISTINCT ID FROM ENTRYLOOPS ORDER BY ID");
        while (rs.next()) {
            loopids.add(rs.getInt(1));
        }
        rs.close();
        query.close();
        if (loopids.size() < 1) {
            return;
        }
        PreparedStatement pstat = this.fStar.getPreparedStatement("DELETE FROM ENTRYTAGS WHERE ID=?");
        PreparedStatement pquery = this.fStar.getPreparedQuery("SELECT t.ID,d.ADITAUTO,d.ADITDEFAULT,v.LOOPROW,v.VAL,t.NAME FROM ENTRYTAGS t,TAGS d,ENTRYVALS v WHERE t.LOOPID=? AND d.DELETEFLAG='Y' AND t.SEQ=d.SEQ AND v.TAGID=t.ID ORDER BY t.ID,v.LOOPROW");
        int lasttag = -1;
        Iterator i$ = loopids.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            pquery.setInt(1, i);
            rs = pquery.executeQuery();
            while (rs.next()) {
                boolean delete = true;
                if (lasttag < 0) {
                    lasttag = rs.getInt(1);
                }
                String val = rs.getString(5);
                if (!(rs.wasNull() || val.equals("?") || val.equals("."))) {
                    rs.getString(2);
                    if (!rs.wasNull() && rs.getString(2).equals("Y")) {
                        rs.getString(3);
                        if (!rs.wasNull() && !rs.getString(3).equals(val)) {
                            delete = false;
                        }
                    } else {
                        delete = false;
                    }
                }
                if (lasttag == rs.getInt(1)) continue;
                if (delete) {
                    pstat.setInt(1, rs.getInt(1));
                    pstat.executeUpdate();
                }
                lasttag = rs.getInt(1);
            }
        }
        pstat.getConnection().commit();
        pstat.close();
        rs.close();
        pquery.close();
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.TrimAditDeposition [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        TrimAditDeposition fn = new TrimAditDeposition(errs, conf, star);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        boolean rc = fn.edit(false);
        System.err.println("Edited: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        if (!rc) {
            System.exit(1);
        }
    }
}

