/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class TrimValues
extends EditingFunction {
    public static final int NUMBER = 74;
    public static final String TAG_VENDOR = "_Vendor.Name";
    public static final String SFCAT_SW = "software";

    public TrimValues(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(74);
        this.fName = TrimValues.className(this.getClass().getName());
        this.init(74);
    }

    public boolean edit(boolean interactive) {
        try {
            String str;
            Statement query = this.fStar.getQueryStatement();
            PreparedStatement pstat = this.fStar.getPreparedStatement("UPDATE ENTRYVALS SET VAL=? WHERE ID=?");
            ResultSet rs = query.executeQuery("SELECT ID,VAL,DELIMITER FROM ENTRYVALS WHERE VAL IS NOT NULL AND VAL <> '?'");
            while (rs.next()) {
                if (rs.getInt(3) == 11) continue;
                str = rs.getString(2).trim();
                str = str.replaceAll("\\s{2,}", " ");
                pstat.setString(1, str);
                pstat.setInt(2, rs.getInt(1));
                pstat.executeUpdate();
            }
            rs = query.executeQuery("SELECT v.ID,v.VAL FROM ENTRYVALS v,TAGS t WHERE t.TAGNAME='_Vendor.Name' AND t.SFCAT='software' AND v.VAL IS NOT NULL AND v.SEQ=t.SEQ");
            while (rs.next()) {
                str = rs.getString(2).trim();
                str = str.replaceAll("^(.+)\\s+-\\s+", "");
                pstat.setString(1, str);
                pstat.setInt(2, rs.getInt(1));
                pstat.executeUpdate();
            }
            if (!pstat.getConnection().getAutoCommit()) {
                pstat.getConnection().commit();
            }
            pstat.close();
            rs.close();
            query.close();
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 74, -1, -1, "DB exception, check error output"));
            }
            return false;
        }
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.print("Usage: java ");
                System.err.print(TrimValues.class.getName());
                System.err.println(" [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        TrimValues fn = new TrimValues(errs, conf, star);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        boolean rc = fn.edit(false);
        System.err.println("Edited: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        if (!rc) {
            System.exit(1);
        }
    }
}

