/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TypeChecker {
    public static boolean isInt(String str) {
        if (str == null || str.equals("")) {
            return false;
        }
        char[] val = str.trim().toCharArray();
        block4: for (int i = 0; i < val.length; ++i) {
            switch (val[i]) {
                case '+': 
                case '-': {
                    if (i > 0) {
                        return false;
                    }
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block4;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isFloat(String str) {
        if (str == null || str.equals("")) {
            return false;
        }
        char[] val = str.trim().toCharArray();
        boolean seen_dot = false;
        boolean seen_exp = false;
        boolean check_digit = false;
        boolean has_exp = false;
        int last_char = -1;
        int DIGIT = 0;
        int EXP = 1;
        int DOT = 2;
        int SIGN = 3;
        block7: for (int i = 0; i < val.length; ++i) {
            switch (val[i]) {
                case '+': 
                case '-': {
                    if (check_digit) {
                        return false;
                    }
                    if (i != 0 && val[i - 1] != 'E' && val[i - 1] != 'e') {
                        return false;
                    }
                    last_char = SIGN;
                    continue block7;
                }
                case 'E': 
                case 'e': {
                    if (seen_exp) {
                        return false;
                    }
                    if (check_digit) {
                        return false;
                    }
                    seen_exp = true;
                    last_char = EXP;
                    continue block7;
                }
                case 'I': 
                case 'i': {
                    if (i > 1) {
                        return false;
                    }
                    if (last_char != SIGN) {
                        return false;
                    }
                    if (i + 2 >= val.length) {
                        return false;
                    }
                    if (!(val[i + 1] != 'n' && val[i + 1] != 'N' || val[i + 2] != 'f' && val[i + 2] != 'F')) {
                        return true;
                    }
                }
                case '.': {
                    if (seen_dot) {
                        return false;
                    }
                    if (last_char != DIGIT) {
                        if (i + 1 >= val.length) {
                            return false;
                        }
                        check_digit = true;
                    }
                    seen_dot = true;
                    last_char = DOT;
                    continue block7;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (seen_exp) {
                        has_exp = true;
                    }
                    check_digit = false;
                    last_char = DIGIT;
                    continue block7;
                }
                default: {
                    return false;
                }
            }
        }
        return !seen_exp || has_exp;
    }

    public static boolean isIsoDate(String str) {
        if (str == null || str.trim().equals("")) {
            return false;
        }
        str = str.trim();
        Pattern iso = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}$");
        Matcher m = iso.matcher(str);
        if (!m.matches()) {
            return false;
        }
        try {
            int i = Integer.parseInt(str.substring(5, 7));
            if (i < 1 || i > 12) {
                return false;
            }
            i = Integer.parseInt(str.substring(8));
            if (i < 1 || i > 31) {
                return false;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

