/*
 * Decompiled with CFR 0.152.
 */
package edu.bmrb.sans;

import edu.bmrb.sans.ContentHandler;
import edu.bmrb.sans.DataItemNode;
import edu.bmrb.sans.ErrorHandler;
import edu.bmrb.sans.IntStringPair;
import edu.bmrb.sans.STARLexer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class CifParser {
    private static final boolean DEBUG = false;
    public static final String ERR_LEXER = "Scanner error: ";
    public static final String ERR_TOKEN = "Invalid token: ";
    public static final String ERR_TAG = "Tag expected: ";
    public static final String ERR_LOOPVALS = "Loop with no values";
    public static final String ERR_LOOPTAGS = "Loop with no tags";
    public static final String WARN_LEXER = "Lexer warning: ";
    private STARLexer fLex = null;
    private ErrorHandler fEh = null;
    private ContentHandler fCh = null;
    private String fDataId = null;

    private CifParser(STARLexer lex) {
        this.fLex = lex;
    }

    public CifParser(STARLexer lex, ContentHandler ch, ErrorHandler eh) {
        this.fLex = lex;
        this.fCh = ch;
        this.fEh = eh;
    }

    public ContentHandler getContentHandler() {
        return this.fCh;
    }

    public void setContentHandler(ContentHandler ch) {
        this.fCh = ch;
    }

    public ErrorHandler getErrorHandler() {
        return this.fEh;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.fEh = eh;
    }

    public STARLexer getScanner() {
        return this.fLex;
    }

    public void setScanner(STARLexer lex) {
        this.fLex = lex;
    }

    public void parse() {
        if (this.fLex == null || this.fCh == null || this.fEh == null) {
            throw new NullPointerException("Parser not initialized");
        }
        try {
            STARLexer.Types tok;
            block9: do {
                tok = this.fLex.yylex();
                switch (tok) {
                    case EOF: {
                        this.fCh.endData(this.fLex.getLine(), this.fDataId);
                        return;
                    }
                    case ERROR: {
                        this.fEh.fatalError(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                        return;
                    }
                    case WARNING: {
                        if (!this.fEh.warning(this.fLex.getLine(), this.fLex.getColumn(), WARN_LEXER + this.fLex.yytext())) continue block9;
                        return;
                    }
                    case COMMENT: {
                        if (!this.fCh.comment(this.fLex.getLine(), this.fLex.yytext())) continue block9;
                        return;
                    }
                    case DATASTART: {
                        this.fDataId = this.fLex.yytext().substring(5);
                        if (this.fCh.startData(this.fLex.getLine(), this.fDataId)) {
                            return;
                        }
                        if (!this.parseDataBlock()) continue block9;
                        return;
                    }
                    default: {
                        if (!this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_TOKEN + this.fLex.yytext())) continue block9;
                        return;
                    }
                }
            } while (tok != STARLexer.Types.EOF);
        }
        catch (Exception e) {
            this.fEh.fatalError(-1, -1, e.getMessage());
            System.err.println(e);
            e.printStackTrace();
        }
    }

    public boolean parseDataBlock() {
        int tagline = -1;
        String tag = null;
        try {
            STARLexer.Types tok;
            block11: do {
                DataItemNode item = null;
                tok = this.fLex.yylex();
                switch (tok) {
                    case EOF: {
                        this.fCh.endData(this.fLex.getLine(), this.fDataId);
                        return true;
                    }
                    case ERROR: {
                        this.fEh.fatalError(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                        return true;
                    }
                    case WARNING: {
                        if (!this.fEh.warning(this.fLex.getLine(), this.fLex.getColumn(), WARN_LEXER + this.fLex.yytext())) continue block11;
                        return true;
                    }
                    case COMMENT: {
                        if (!this.fCh.comment(this.fLex.getLine(), this.fLex.yytext())) continue block11;
                        return true;
                    }
                    case LOOPSTART: {
                        if (this.fCh.startLoop(this.fLex.getLine())) {
                            return true;
                        }
                        if (!this.parseLoop()) continue block11;
                        return true;
                    }
                    case TAGNAME: {
                        tag = this.fLex.yytext();
                        tagline = this.fLex.getLine();
                        break;
                    }
                    case DVNDOUBLE: 
                    case DVNFRAMECODE: 
                    case DVNNON: 
                    case DVNSEMICOLON: 
                    case DVNSINGLE: {
                        if (tag == null && this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_TAG + this.fLex.yytext())) {
                            return true;
                        }
                        item = new DataItemNode(tagline, tag);
                        item.setDelimType(tok);
                        item.setLoopFlag(false);
                        item.setValueLine(this.fLex.getLine());
                        if (tok == STARLexer.Types.DVNSEMICOLON) {
                            if (this.fLex.getText().indexOf(System.getProperty("line.separator")) == 0) {
                                item.setValue(this.fLex.getText().substring(System.getProperty("line.separator").length()));
                            } else {
                                item.setValue(this.fLex.getText());
                            }
                        } else if (tok == STARLexer.Types.DVNFRAMECODE) {
                            item.setValue(this.fLex.yytext().substring(1));
                        } else if (tok == STARLexer.Types.DVNNON) {
                            item.setValue(this.fLex.yytext());
                        } else {
                            item.setValue(this.fLex.getText());
                        }
                        if (this.fCh.data(item)) {
                            return true;
                        }
                        tag = null;
                        break;
                    }
                    default: {
                        if (!this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_TOKEN + this.fLex.yytext())) continue block11;
                        return true;
                    }
                }
            } while (tok != STARLexer.Types.EOF);
            return false;
        }
        catch (Exception e) {
            this.fEh.fatalError(-1, -1, e.getMessage());
            System.err.println(e);
            e.printStackTrace();
            return true;
        }
    }

    public boolean parseLoop() {
        int col = 0;
        IntStringPair tag = null;
        boolean parsing_values = false;
        ArrayList<IntStringPair> tags = new ArrayList<IntStringPair>();
        try {
            STARLexer.Types tok;
            block11: do {
                DataItemNode item = null;
                tok = this.fLex.yylex();
                switch (tok) {
                    case EOF: {
                        this.fCh.endData(this.fLex.getLine(), this.fDataId);
                        return true;
                    }
                    case ERROR: {
                        this.fEh.fatalError(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                        return true;
                    }
                    case WARNING: {
                        if (!this.fEh.warning(this.fLex.getLine(), this.fLex.getColumn(), WARN_LEXER + this.fLex.yytext())) continue block11;
                        return true;
                    }
                    case COMMENT: {
                        if (!this.fCh.comment(this.fLex.getLine(), this.fLex.yytext())) continue block11;
                        return true;
                    }
                    case LOOPSTART: {
                        if (!parsing_values && this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LOOPVALS)) {
                            return true;
                        }
                        if (this.fCh.endLoop(this.fLex.getLine())) {
                            return true;
                        }
                        this.fLex.pushBack(5);
                        return false;
                    }
                    case TAGNAME: {
                        if (parsing_values) {
                            if (this.fCh.endLoop(this.fLex.getLine())) {
                                return true;
                            }
                            this.fLex.pushBack(this.fLex.yytext().length());
                            return false;
                        }
                        tag = new IntStringPair(this.fLex.getLine(), this.fLex.yytext());
                        tags.add(tag);
                        break;
                    }
                    case DVNDOUBLE: 
                    case DVNFRAMECODE: 
                    case DVNNON: 
                    case DVNSEMICOLON: 
                    case DVNSINGLE: {
                        if (tags.size() < 1 && this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LOOPTAGS)) {
                            tags.clear();
                            tags = null;
                            return true;
                        }
                        parsing_values = true;
                        tag = null;
                        item = new DataItemNode((IntStringPair)tags.get(col));
                        item.setLoopFlag(true);
                        item.setDelimType(tok);
                        item.setValueLine(this.fLex.getLine());
                        if (tok == STARLexer.Types.DVNSEMICOLON) {
                            if (this.fLex.getText().indexOf(System.getProperty("line.separator")) == 0) {
                                item.setValue(this.fLex.getText().substring(System.getProperty("line.separator").length()));
                            } else {
                                item.setValue(this.fLex.getText());
                            }
                        } else if (tok == STARLexer.Types.DVNFRAMECODE) {
                            item.setValue(this.fLex.yytext().substring(1));
                        } else if (tok == STARLexer.Types.DVNNON) {
                            item.setValue(this.fLex.yytext());
                        } else {
                            item.setValue(this.fLex.getText());
                        }
                        if (++col == tags.size()) {
                            col = 0;
                        }
                        if (!this.fCh.data(item)) continue block11;
                        return true;
                    }
                    default: {
                        if (!this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_TOKEN + this.fLex.yytext())) continue block11;
                        return true;
                    }
                }
            } while (tok != STARLexer.Types.EOF);
            return false;
        }
        catch (Exception e) {
            this.fEh.fatalError(-1, -1, e.getMessage());
            System.err.println(e);
            e.printStackTrace();
            return true;
        }
    }

    private void test_parse() throws IOException {
        STARLexer.Types tok = this.fLex.yylex();
        while (tok != STARLexer.Types.EOF) {
            System.out.printf("%s (%d,%d): %s\n", new Object[]{tok, this.fLex.getLine(), this.fLex.getColumn(), this.fLex.getText()});
            tok = this.fLex.yylex();
        }
        System.out.println("End of data (EOF)");
    }

    public static void main(String[] args) {
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
            STARLexer lex = new STARLexer(r);
            CifParser p = new CifParser(lex);
            p.test_parse();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(1);
        }
    }
}

