/*
 * Decompiled with CFR 0.152.
 */
package edu.bmrb.sans;

import edu.bmrb.sans.ContentHandler;
import edu.bmrb.sans.DataItemNode;
import edu.bmrb.sans.ErrorHandler;
import edu.bmrb.sans.IntStringPair;
import edu.bmrb.sans.STARLexer;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class SansParser {
    private static final boolean DEBUG = true;
    public static final String ERR_LEXER = "Lexer error: ";
    public static final String WARN_LEXER = "Lexer warning: ";
    public static final String ERR_TOPTOKEN = "Illegal token: ";
    public static final String ERR_DATATOKEN = "Illegal token in data_ block: ";
    public static final String ERR_SAVETOKEN = "Illegal token in saveframe: ";
    public static final String ERR_SAVEVAL = "Saveframe: value expected, found: ";
    public static final String ERR_SAVENVAL = "Saveframe: value not expected here: ";
    public static final String ERR_EOF = "Premature end of file";
    public static final String ERR_NOSAVE = ": no closing save_";
    public static final String ERR_NOSTOP = ": no closing stop_";
    public static final String ERR_NOTAGS = "Loop with no tags";
    public static final String ERR_NOVALS = "Loop with no values";
    public static final String WARN_LOOPCNT = "Loop count error";
    public static final String ERR_LOOPNVAL = "Loop: tag not expected here: ";
    private STARLexer fLex = null;
    private ErrorHandler fEh = null;
    private ContentHandler fCh = null;
    private String fBlockName = null;

    public SansParser(STARLexer lex, ContentHandler ch, ErrorHandler eh) {
        this.fLex = lex;
        this.fEh = eh;
        this.fCh = ch;
    }

    private SansParser(STARLexer lex) {
        this.fLex = lex;
    }

    public ContentHandler getContentHandler() {
        return this.fCh;
    }

    public void setContentHandler(ContentHandler ch) {
        this.fCh = ch;
    }

    public ErrorHandler getErrorHandler() {
        return this.fEh;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.fEh = eh;
    }

    public STARLexer getScanner() {
        return this.fLex;
    }

    public void setScanner(STARLexer lex) {
        this.fLex = lex;
    }

    public void parse() {
        assert (this.fLex != null);
        assert (this.fCh == null);
        assert (this.fEh == null);
        try {
            STARLexer.Types tok;
            block9: do {
                tok = this.fLex.yylex();
                switch (tok) {
                    case ERROR: {
                        this.fEh.fatalError(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                        return;
                    }
                    case WARNING: {
                        if (!this.fEh.warning(this.fLex.getLine(), this.fLex.getColumn(), WARN_LEXER + this.fLex.yytext())) continue block9;
                        return;
                    }
                    case COMMENT: {
                        if (!this.fCh.comment(this.fLex.getLine(), this.fLex.getText())) continue block9;
                        return;
                    }
                    case DATASTART: {
                        this.fBlockName = this.fLex.getText();
                        if (this.fCh.startData(this.fLex.getLine(), this.fBlockName)) {
                            return;
                        }
                        if (!this.parseDataBlock()) continue block9;
                        return;
                    }
                    case EOF: {
                        this.fCh.endData(this.fLex.getLine(), this.fBlockName);
                        return;
                    }
                    default: {
                        if (!this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_TOPTOKEN + this.fLex.yytext())) continue block9;
                        return;
                    }
                }
            } while (tok != STARLexer.Types.EOF);
        }
        catch (IOException e) {
            this.fEh.fatalError(this.fLex.getLine(), this.fLex.getColumn(), e.getMessage());
            System.err.println(e);
            e.printStackTrace();
        }
    }

    private boolean parseDataBlock() throws IOException {
        STARLexer.Types tok;
        block7: do {
            tok = this.fLex.yylex();
            switch (tok) {
                case ERROR: {
                    this.fEh.fatalError(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                    return true;
                }
                case WARNING: {
                    if (!this.fEh.warning(this.fLex.getLine(), this.fLex.getColumn(), WARN_LEXER + this.fLex.yytext())) continue block7;
                    return true;
                }
                case COMMENT: {
                    if (!this.fCh.comment(this.fLex.getLine(), this.fLex.getText())) continue block7;
                    return true;
                }
                case SAVESTART: {
                    String savename = this.fLex.getText();
                    if (this.fCh.startSaveFrame(this.fLex.getLine(), savename)) {
                        return true;
                    }
                    if (!this.parseSaveFrame(savename)) continue block7;
                    return true;
                }
                case EOF: {
                    this.fCh.endData(this.fLex.getLine(), this.fBlockName);
                    return true;
                }
                default: {
                    if (!this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_DATATOKEN + this.fLex.yytext())) continue block7;
                    return true;
                }
            }
        } while (tok != STARLexer.Types.DATAEND);
        return false;
    }

    private boolean parseSaveFrame(String name) throws IOException {
        STARLexer.Types tok;
        DataItemNode item = null;
        boolean needvalue = false;
        block13: do {
            tok = this.fLex.yylex();
            switch (tok) {
                case ERROR: {
                    this.fEh.fatalError(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                    return true;
                }
                case WARNING: {
                    if (!this.fEh.warning(this.fLex.getLine(), this.fLex.getColumn(), WARN_LEXER + this.fLex.yytext())) continue block13;
                    return true;
                }
                case COMMENT: {
                    if (!this.fCh.comment(this.fLex.getLine(), this.fLex.getText())) continue block13;
                    return true;
                }
                case EOF: {
                    this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), "Premature end of file: no closing save_");
                    this.fCh.endData(this.fLex.getLine(), this.fBlockName);
                    return true;
                }
                case SAVEEND: {
                    if (needvalue && this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_SAVEVAL + this.fLex.getText())) {
                        return true;
                    }
                    return this.fCh.endSaveFrame(this.fLex.getLine(), name);
                }
                case LOOPSTART: {
                    if (needvalue && this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_SAVEVAL + this.fLex.getText())) {
                        return true;
                    }
                    if (this.fCh.startLoop(this.fLex.getLine())) {
                        return true;
                    }
                    if (!this.parseLoop()) continue block13;
                    return true;
                }
                case TAGNAME: {
                    if (needvalue && this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_SAVEVAL + this.fLex.getText())) {
                        return true;
                    }
                    item = new DataItemNode(this.fLex.getLine(), this.fLex.getText());
                    needvalue = true;
                    break;
                }
                case DVNSEMICOLON: 
                case DVNSINGLE: 
                case DVNDOUBLE: 
                case DVNFRAMECODE: 
                case DVNNON: {
                    if (!needvalue && this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_SAVENVAL + this.fLex.getText())) {
                        return true;
                    }
                    needvalue = false;
                    String val = this.fLex.getText();
                    switch (tok) {
                        case DVNSEMICOLON: {
                            if (val.indexOf(System.getProperty("line.separator")) != 0) break;
                            val = val.substring(System.getProperty("line.separator").length());
                        }
                    }
                    item.setValueLine(this.fLex.getLine());
                    item.setDelimType(tok);
                    item.setValue(val);
                    if (this.fCh.data(item)) {
                        return true;
                    }
                    item = null;
                    break;
                }
                default: {
                    if (!this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_DATATOKEN + this.fLex.yytext())) continue block13;
                    return true;
                }
            }
        } while (tok != STARLexer.Types.EOF);
        return false;
    }

    private boolean parseLoop() throws IOException {
        STARLexer.Types tok;
        int numvals = 0;
        int lastline = -1;
        int wrongline = -1;
        int wrongcol = -1;
        int loopcol = 0;
        boolean parsingtags = true;
        ArrayList<IntStringPair> tags = new ArrayList<IntStringPair>();
        block12: do {
            tok = this.fLex.yylex();
            switch (tok) {
                case ERROR: {
                    this.fEh.fatalError(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                    return true;
                }
                case WARNING: {
                    if (!this.fEh.warning(this.fLex.getLine(), this.fLex.getColumn(), WARN_LEXER + this.fLex.yytext())) continue block12;
                    return true;
                }
                case COMMENT: {
                    if (!this.fCh.comment(this.fLex.getLine(), this.fLex.getText())) continue block12;
                    return true;
                }
                case EOF: {
                    this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), "Premature end of file: no closing stop_");
                    this.fCh.endData(this.fLex.getLine(), this.fBlockName);
                    return true;
                }
                case STOP: {
                    if (tags.size() < 1 && this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_NOTAGS)) {
                        return true;
                    }
                    if (numvals < 1 && this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_NOVALS)) {
                        return true;
                    }
                    boolean rc = false;
                    if (numvals % tags.size() != 0) {
                        if (wrongline < 0) {
                            wrongline = this.fLex.getLine();
                        }
                        rc = this.fEh.warning(wrongline, wrongcol, WARN_LOOPCNT);
                    }
                    rc = rc || this.fCh.endLoop(this.fLex.getLine());
                    return rc;
                }
                case TAGNAME: {
                    if (!parsingtags && this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LOOPNVAL + this.fLex.yytext())) {
                        return true;
                    }
                    tags.add(new IntStringPair(this.fLex.getLine(), this.fLex.getText()));
                    break;
                }
                case DVNSEMICOLON: 
                case DVNSINGLE: 
                case DVNDOUBLE: 
                case DVNFRAMECODE: 
                case DVNNON: {
                    if (parsingtags) {
                        parsingtags = false;
                    }
                    String val = this.fLex.getText();
                    switch (tok) {
                        case DVNSEMICOLON: {
                            if (val.indexOf(System.getProperty("line.separator")) != 0) break;
                            val = val.substring(System.getProperty("line.separator").length());
                        }
                    }
                    ++numvals;
                    if (++loopcol == tags.size()) {
                        if (lastline < this.fLex.getLine()) {
                            if (wrongline < 0) {
                                wrongline = this.fLex.getLine();
                                wrongcol = this.fLex.getColumn();
                            }
                            lastline = this.fLex.getLine();
                        }
                        loopcol = 0;
                    }
                    System.out.printf("loopcol %d, numvals %d, numtags %d, line %d\n", loopcol, numvals, tags.size(), this.fLex.getLine());
                    DataItemNode item = new DataItemNode((IntStringPair)tags.get(loopcol));
                    item.setValueLine(this.fLex.getLine());
                    item.setValue(val);
                    item.setDelimType(tok);
                    item.setLoopFlag(true);
                    if (!this.fCh.data(item)) continue block12;
                    return true;
                }
                default: {
                    if (!this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_DATATOKEN + this.fLex.yytext())) continue block12;
                    return true;
                }
            }
        } while (tok != STARLexer.Types.EOF);
        return false;
    }

    private void test_parse() throws IOException {
        STARLexer.Types tok = this.fLex.yylex();
        while (tok != STARLexer.Types.EOF) {
            System.out.printf("%s (%d,%d): %s\n", new Object[]{tok, this.fLex.getLine(), this.fLex.getColumn(), this.fLex.getText()});
            if (tok == STARLexer.Types.ERROR) {
                System.err.printf("Error: %s in line %d (%d),", this.fLex.getText(), this.fLex.getLine(), this.fLex.getColumn());
            }
            if (tok == STARLexer.Types.WARNING) {
                System.err.printf("Warning: %s in line %d (%d),", this.fLex.getText(), this.fLex.getLine(), this.fLex.getColumn());
            }
            tok = this.fLex.yylex();
        }
    }

    public static void main(String[] args) {
        try {
            BufferedReader r = args.length < 1 ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(args[0]));
            STARLexer lex = new STARLexer(r);
            SansParser p = new SansParser(lex);
            long start = System.currentTimeMillis();
            p.test_parse();
            System.err.printf("Elapsed: %d millis (%d - %d)\n", System.currentTimeMillis() - start, System.currentTimeMillis(), start);
            System.err.printf("%d\n", System.currentTimeMillis() - start);
            if (args.length > 0) {
                r.close();
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(1);
        }
    }
}

