/*
 * Decompiled with CFR 0.152.
 */
package edu.bmrb.starobj.db;

import edu.bmrb.sans.ContentHandler2;
import edu.bmrb.sans.ErrorHandler;
import edu.bmrb.sans.STARLexer;
import edu.bmrb.sans.SansParser2;
import edu.bmrb.starobj.db.RunSQL;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class LoadDict
implements ErrorHandler,
ContentHandler2 {
    private static final boolean DEBUG = false;
    private Connection fConn = null;
    private int fParseErrors = 0;
    private String fTableName = null;
    private ArrayList<String> fColNames = null;
    private int[] fColTypes = null;
    private int fColNum;
    private PreparedStatement fStat = null;

    public LoadDict(Connection connection) {
        if (connection == null) {
            throw new NullPointerException("JDBC connection is null");
        }
        try {
            if (connection.isClosed()) {
                throw new NullPointerException("JDBC connection is null");
            }
        }
        catch (SQLException sQLException) {
            throw new NullPointerException("JDBC connection problem: " + sQLException.getMessage());
        }
        this.fConn = connection;
        this.fColNames = new ArrayList();
    }

    public void load(Reader reader) throws SQLException {
        STARLexer sTARLexer = new STARLexer(reader);
        SansParser2 sansParser2 = new SansParser2(sTARLexer, this, this);
        sansParser2.parse();
        if (!this.fConn.getAutoCommit()) {
            this.fConn.commit();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            System.err.println("Usage: java edu.bmrb.starobj.db.LoadDict scriptfile dictfile constrfile");
            System.exit(1);
        }
        try {
            long l = System.currentTimeMillis();
            Class.forName("org.postgresql.Driver");
            Connection connection = DriverManager.getConnection("jdbc:postgresql:dmaziuk", "dmaziuk", "212-eu01");
            connection.setAutoCommit(false);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
            RunSQL.run(connection, bufferedReader, null);
            bufferedReader.close();
            LoadDict loadDict = new LoadDict(connection);
            bufferedReader = new BufferedReader(new FileReader(stringArray[1]));
            loadDict.load(bufferedReader);
            bufferedReader.close();
            bufferedReader = new BufferedReader(new FileReader(stringArray[2]));
            RunSQL.run(connection, bufferedReader, null);
            connection.close();
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
            System.exit(2);
        }
    }

    private void initRow() throws SQLException {
        Statement statement = this.fConn.createStatement(1003, 1007);
        StringBuilder stringBuilder = new StringBuilder("SELECT * FROM ");
        stringBuilder.append(this.fTableName);
        ResultSet resultSet = statement.executeQuery(stringBuilder.toString());
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        this.fColTypes = new int[this.fColNames.size()];
        stringBuilder.setLength(0);
        stringBuilder.append("INSERT INTO ");
        stringBuilder.append(this.fTableName);
        stringBuilder.append(" (");
        int n = 0;
        int n2 = resultSetMetaData.getColumnCount();
        assert (n2 == this.fColNames.size());
        for (String string : this.fColNames) {
            stringBuilder.append(string);
            if (n < this.fColNames.size() - 1) {
                stringBuilder.append(',');
            }
            for (int i = 1; i <= n2; ++i) {
                if (!string.equals(resultSetMetaData.getColumnName(i).toUpperCase())) continue;
                this.fColTypes[n] = resultSetMetaData.getColumnType(i);
                break;
            }
            ++n;
        }
        resultSet.close();
        statement.close();
        stringBuilder.append(") VALUES (");
        for (n = 0; n < this.fColNames.size(); ++n) {
            stringBuilder.append('?');
            if (n >= this.fColNames.size() - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(')');
        this.fStat = this.fConn.prepareStatement(stringBuilder.toString());
        stringBuilder.setLength(0);
    }

    public void fatalError(int n, int n2, String string) {
        ++this.fParseErrors;
        System.err.printf("Fatal parser error in line %d, col %d: %s\n", n, n2, string);
    }

    public boolean error(int n, int n2, String string) {
        ++this.fParseErrors;
        System.err.printf("Parser error in line %d, col %d: %s\nTerminating\n", n, n2, string);
        return true;
    }

    public boolean warning(int n, int n2, String string) {
        ++this.fParseErrors;
        System.err.printf("Parser warning in line %d, col %d: %s\nTerminating\n", n, n2, string);
        return true;
    }

    public boolean startSaveFrame(int n, String string) {
        this.fTableName = string;
        return false;
    }

    public boolean endSaveFrame(int n, String string) {
        this.fTableName = null;
        return false;
    }

    public boolean endLoop(int n) {
        this.fColNames.clear();
        this.fColTypes = null;
        this.fColNum = 0;
        try {
            this.fStat.executeUpdate();
            if (!this.fConn.getAutoCommit()) {
                this.fConn.commit();
            }
            this.fStat.close();
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException);
            sQLException.printStackTrace();
            return true;
        }
        return false;
    }

    public boolean tag(int n, String string) {
        this.fColNames.add(string.substring(1));
        return false;
    }

    public boolean value(int n, String string, STARLexer.Types types) {
        if (this.fColTypes == null) {
            try {
                this.initRow();
            }
            catch (SQLException sQLException) {
                System.err.println(sQLException);
                sQLException.printStackTrace();
                return true;
            }
        }
        if (this.fColNum == this.fColTypes.length) {
            this.fColNum = 0;
            try {
                this.fStat.executeUpdate();
            }
            catch (SQLException sQLException) {
                System.err.println(sQLException);
                sQLException.printStackTrace();
                return true;
            }
        }
        try {
            if (this.fTableName.toUpperCase().equals("VALENUMS") && string.equals("?")) {
                this.fStat.setString(this.fColNum + 1, "?");
            } else if (string.equals(".") || string.equals("?")) {
                this.fStat.setNull(this.fColNum + 1, this.fColTypes[this.fColNum]);
            } else {
                switch (this.fColTypes[this.fColNum]) {
                    case 8: {
                        this.fStat.setDouble(this.fColNum + 1, Double.parseDouble(string));
                        break;
                    }
                    case 6: 
                    case 7: {
                        this.fStat.setFloat(this.fColNum + 1, Float.parseFloat(string));
                        break;
                    }
                    case 2: 
                    case 4: {
                        this.fStat.setInt(this.fColNum + 1, Integer.parseInt(string));
                        break;
                    }
                    case 5: {
                        this.fStat.setShort(this.fColNum + 1, Short.parseShort(string));
                        break;
                    }
                    case 1: 
                    case 12: {
                        this.fStat.setString(this.fColNum + 1, string);
                        break;
                    }
                    default: {
                        System.err.printf("Unknown column type %d\nTerminating\n", this.fColTypes[this.fColNum]);
                        return true;
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException);
            sQLException.printStackTrace();
            return true;
        }
        ++this.fColNum;
        return false;
    }

    public boolean comment(int n, String string) {
        return false;
    }

    public boolean startData(int n, String string) {
        return false;
    }

    public void endData(int n, String string) {
    }

    public boolean startLoop(int n) {
        return false;
    }
}

