/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.lib;

import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.regex.Pattern;

public class CreateDBSchema {
    private static final boolean DEBUG = false;
    public static final String DEF_PROPFILE = "javalib.properties";
    public static final String DEF_SCRIPT_KEY = "SQL.Script";
    public static final String DRIVER_KEY = "DB.Driver";
    public static final String DBURL_KEY = "DB.Url";
    public static final String DBUSER_KEY = "DB.User";
    public static final String DBPASSWD_KEY = "DB.Password";

    public static void runScript(Connection conn, String scriptfile, PrintWriter out) throws IOException, SQLException {
        FileInputStream in = new FileInputStream(scriptfile);
        CreateDBSchema.runScript(conn, in, out);
    }

    public static void runScript(Connection conn, InputStream script, PrintWriter out) throws IOException, SQLException {
        String str;
        Statement stat = conn.createStatement();
        BufferedReader in = new BufferedReader(new InputStreamReader(script));
        StringBuffer sql = new StringBuffer();
        Pattern drop_pat = Pattern.compile("\\W*[dD][Rr][Oo][Pp]\\W*.*");
        Pattern commit_pat = Pattern.compile("\\W*[Cc][Oo][Mm][Mm][Ii][Tt]\\W*.*");
        Pattern quit_pat = Pattern.compile("\\W*[Qq][Uu][Ii][Tt]\\W*");
        Pattern begin_pat = Pattern.compile(".*\\W*[Bb][Ee][Gg][Ii][Nn]\\W*.*");
        Pattern end_pat = Pattern.compile(".*\\W*[Ee][Nn][Dd]\\W*.*");
        int blockcount = 0;
        boolean keep_semicolon = false;
        while ((str = in.readLine()) != null) {
            boolean run_statement = false;
            if ((str = str.trim()).length() == 0 || str.charAt(0) == '-' && str.charAt(1) == '-') continue;
            if (quit_pat.matcher(str).matches()) {
                if (!conn.getAutoCommit()) {
                    conn.commit();
                }
                stat.close();
                conn.close();
                return;
            }
            int end = str.indexOf("--");
            if (end != -1) {
                str = str.substring(0, end);
            }
            if (begin_pat.matcher(str).matches()) {
                ++blockcount;
                keep_semicolon = true;
            }
            if (end_pat.matcher(str).matches()) {
                --blockcount;
            }
            if ((end = str.lastIndexOf(59)) != -1) {
                if (keep_semicolon) {
                    sql.append(' ');
                    sql.append(str);
                    if (blockcount == 0) {
                        keep_semicolon = false;
                        run_statement = true;
                    }
                } else {
                    sql.append(' ');
                    sql.append(str.substring(0, end));
                    run_statement = true;
                }
            } else if (keep_semicolon && blockcount < 1) {
                sql.append(' ');
                sql.append(str);
                run_statement = true;
            } else {
                sql.append(' ');
                sql.append(str);
            }
            if (!run_statement) continue;
            if (out != null) {
                out.println(sql);
                out.flush();
            }
            if (commit_pat.matcher(sql.toString()).matches()) {
                if (!conn.getAutoCommit()) {
                    conn.commit();
                }
            } else if (drop_pat.matcher(sql.toString()).matches()) {
                try {
                    stat.executeUpdate(sql.toString());
                }
                catch (SQLException e) {
                    if (out != null) {
                        out.println(sql);
                        out.println(e.getMessage());
                        e.printStackTrace(out);
                    }
                }
            } else {
                stat.executeUpdate(sql.toString());
            }
            sql.setLength(0);
        }
        if (!conn.getAutoCommit()) {
            conn.commit();
        }
        stat.close();
        if (out != null) {
            out.flush();
        }
        in.close();
    }

    public static void runScript(Properties props, String scriptkey, PrintWriter out) throws IOException, SQLException, ClassNotFoundException {
        String drv = props.getProperty(DRIVER_KEY);
        if (drv == null) {
            throw new NullPointerException("Missing DB driver");
        }
        String url = props.getProperty(DBURL_KEY);
        if (url == null) {
            throw new NullPointerException("Missing DB URL");
        }
        Class.forName(drv);
        Connection conn = DriverManager.getConnection(url, props.getProperty(DBUSER_KEY), props.getProperty(DBPASSWD_KEY));
        conn.setAutoCommit(false);
        try {
            CreateDBSchema.runScript(conn, scriptkey, out);
        }
        catch (IOException e) {
            throw e;
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            conn.close();
        }
    }

    public static void usage() {
        System.out.print("Usage: java EDU.bmrb.lib.CreateDBSchema [-h]");
        System.out.println(" [-c FILE] [-o FILE] [-k KEY]");
        System.out.println("  -h: print this usage summary");
        System.out.println("  -c FILE: use configuration FILE (default: " + System.getProperty("user.home") + File.separatorChar + DEF_PROPFILE + ")");
        System.out.println("  -k KEY: script file KEY (default: SQL.Script config file setting)");
        System.out.println("  -o FILE: print SQL statements to FILE (use dash '-' for stdout)");
    }

    public static void main(String[] args) {
        int opt;
        Getopt g = new Getopt("CreateDBSchema", args, "hc:o:k:");
        String conffile = null;
        String outfile = null;
        String scriptkey = null;
        block7: while ((opt = g.getopt()) != -1) {
            switch (opt) {
                case 99: {
                    conffile = g.getOptarg();
                    continue block7;
                }
                case 111: {
                    outfile = g.getOptarg();
                    continue block7;
                }
                case 107: {
                    scriptkey = g.getOptarg();
                    continue block7;
                }
            }
            CreateDBSchema.usage();
            return;
        }
        if (conffile == null) {
            conffile = System.getProperty("user.home") + File.separatorChar + DEF_PROPFILE;
        }
        try {
            Properties props = new Properties();
            FileInputStream in = new FileInputStream(conffile);
            props.load(in);
            in.close();
            scriptkey = scriptkey == null ? props.getProperty(DEF_SCRIPT_KEY) : props.getProperty(scriptkey);
            if (scriptkey == null) {
                throw new NullPointerException("Missing SQL script filename");
            }
            PrintWriter out = null;
            if (outfile != null) {
                out = outfile.equals("-") ? new PrintWriter(System.out) : new PrintWriter(new FileOutputStream(outfile));
            }
            CreateDBSchema.runScript(props, scriptkey, out);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

