/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.lib;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class DBMgr {
    public static final String PROPKEY_DBDRIVER = "DB.Driver";
    public static final String PROPKEY_DBURL = "DB.Url";
    public static final String PROPKEY_DBUSER = "DB.User";
    public static final String PROPKEY_DBPASSWD = "DB.Password";
    private Properties fProps = null;
    private Connection fConn = null;

    public DBMgr(Properties props) {
        if (props == null) {
            throw new NullPointerException("Missing properties");
        }
        this.fProps = props;
    }

    public Properties getProperties() {
        return this.fProps;
    }

    public void setProperties(Properties props) {
        if (props == null) {
            throw new NullPointerException("Missing properties");
        }
        this.fProps = props;
    }

    public String getProperty(String key) {
        return this.fProps.getProperty(key);
    }

    public Connection getConnection() {
        return this.fConn;
    }

    public void setConnection(Connection conn) {
        if (conn == null) {
            throw new NullPointerException("Missing connection");
        }
        this.fConn = conn;
    }

    public boolean isConnected() {
        if (this.fConn == null) {
            return false;
        }
        try {
            return !this.fConn.isClosed();
        }
        catch (SQLException e) {
            System.err.println("Exception in DBMgr.isConnected()");
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public void connect(boolean autocommit) throws SQLException, ClassNotFoundException {
        if (this.isConnected()) {
            return;
        }
        String drv = this.fProps.getProperty(PROPKEY_DBDRIVER);
        if (drv == null) {
            throw new NullPointerException("Missing DB driver");
        }
        String url = this.fProps.getProperty(PROPKEY_DBURL);
        if (url == null) {
            throw new NullPointerException("Missing DB URL");
        }
        Class.forName(drv);
        this.fConn = DriverManager.getConnection(url, this.fProps.getProperty(PROPKEY_DBUSER), this.fProps.getProperty(PROPKEY_DBPASSWD));
        this.fConn.setAutoCommit(autocommit);
    }

    public void close() {
        if (!this.isConnected()) {
            return;
        }
        try {
            if (!this.fConn.isClosed()) {
                this.fConn.close();
            }
            this.fConn = null;
        }
        catch (SQLException e) {
            System.err.println("Exception in DBMgr.close()");
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public Statement getStatement() {
        try {
            if (!this.isConnected()) {
                this.connect(false);
            }
            return this.fConn.createStatement();
        }
        catch (Exception e) {
            System.err.println("Exception in DBMgr.getStatement()");
            System.err.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public Statement getQuery() {
        try {
            if (!this.isConnected()) {
                this.connect(false);
            }
            return this.fConn.createStatement(1003, 1007);
        }
        catch (Exception e) {
            System.err.println("Exception in DBMgr.getQuery()");
            System.err.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

