/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.lib;

import EDU.bmrb.lib.ErrorList;
import EDU.bmrb.nmrstar.utils.QuoteString;
import gnu.getopt.Getopt;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DbToStar {
    public static final String DRIVER_KEY = "DB.Driver";
    public static final String DBURL_KEY = "DB.Url";
    public static final String DBUSER_KEY = "DB.User";
    public static final String DBPASSWD_KEY = "DB.Password";
    private static final String ERR_DBEXC = "DB exception";
    private static final int TABWIDTH = 4;
    private Connection fConn = null;
    private PrintWriter fOut = null;
    private ErrorList fErrs = null;
    private List fTables = null;

    public DbToStar(Connection connection, PrintWriter printWriter, ErrorList errorList) {
        this.fConn = connection;
        this.fOut = printWriter;
        this.fErrs = errorList;
        this.fTables = new ArrayList();
    }

    private void checkTableNames(List list) throws SQLException {
        if (this.fConn == null || this.fConn.isClosed()) {
            System.err.println("Not connected to database");
            return;
        }
        String[] stringArray = new String[]{"TABLE"};
        DatabaseMetaData databaseMetaData = this.fConn.getMetaData();
        ResultSet resultSet = databaseMetaData.getDatabaseProductName().matches(".*Oracle.*") ? databaseMetaData.getTables(null, databaseMetaData.getUserName(), null, stringArray) : databaseMetaData.getTables(null, null, null, stringArray);
        if (list == null) {
            while (resultSet.next()) {
                this.fTables.add(resultSet.getString(3));
            }
        } else {
            int n;
            block1: while (resultSet.next()) {
                for (n = 0; n < list.size(); ++n) {
                    if (!list.get(n).equals(resultSet.getString(3))) continue;
                    this.fTables.add(list.get(n));
                    continue block1;
                }
            }
            for (n = 0; n < list.size(); ++n) {
                boolean bl = false;
                for (int i = 0; i < this.fTables.size(); ++i) {
                    if (!list.get(n).equals(this.fTables.get(i))) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                System.err.print("Invalid table name: ");
                System.err.println(list.get(n));
            }
        }
        resultSet.close();
    }

    public void printTable(String string) throws SQLException {
        String string2;
        int n;
        int n2;
        if (this.fConn == null || this.fConn.isClosed()) {
            System.err.println("Not connected to database");
            return;
        }
        this.fOut.print("save_");
        this.fOut.println(string);
        Statement statement = this.fConn.createStatement(1004, 1007);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM " + string);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (n2 = 0; n2 < 4; ++n2) {
            this.fOut.print(' ');
        }
        this.fOut.println("loop_");
        for (n2 = 1; n2 < resultSetMetaData.getColumnCount() + 1; ++n2) {
            for (n = 0; n < 8; ++n) {
                this.fOut.print(' ');
            }
            this.fOut.print('_');
            this.fOut.println(resultSetMetaData.getColumnName(n2));
        }
        int[] nArray = new int[resultSetMetaData.getColumnCount() + 1];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = 0;
        }
        while (resultSet.next()) {
            for (n2 = 1; n2 < resultSetMetaData.getColumnCount() + 1; ++n2) {
                string2 = resultSet.getString(n2);
                if (resultSet.wasNull() || string2.length() <= nArray[n2 - 1]) continue;
                nArray[n2 - 1] = string2.length();
            }
        }
        n2 = 0;
        while (n2 < nArray.length) {
            int n3 = n2++;
            nArray[n3] = nArray[n3] + 4;
        }
        resultSet = statement.executeQuery("SELECT * FROM " + string);
        while (resultSet.next()) {
            for (n = 0; n < 8; ++n) {
                this.fOut.print(' ');
            }
            for (n2 = 1; n2 < resultSetMetaData.getColumnCount() + 1; ++n2) {
                string2 = resultSet.getString(n2);
                string2 = resultSet.wasNull() ? "." : QuoteString.quoteForSTAR(string2);
                this.fOut.print(string2);
                for (n = string2.length(); n < nArray[n2 - 1]; ++n) {
                    this.fOut.print(' ');
                }
            }
            this.fOut.println();
        }
        resultSet.close();
        statement.close();
        for (n2 = 0; n2 < 4; ++n2) {
            this.fOut.print(' ');
        }
        this.fOut.println("stop_");
        this.fOut.println("save_");
        this.fOut.println();
        this.fOut.flush();
    }

    public void print() throws SQLException {
        if (this.fConn == null || this.fConn.isClosed()) {
            System.err.println("Not connected to database");
            return;
        }
        this.fOut.println("data_TABLEDUMP");
        this.fOut.println();
        for (int i = 0; i < this.fTables.size(); ++i) {
            this.printTable((String)this.fTables.get(i));
        }
    }

    public static void usage() {
        System.out.print("Usage: java EDU.bmrb.javalib.DbToStar [-h]");
        System.out.println(" [-c FILE] [-o FILE] [-t TABLE]");
        System.out.println("  -h: print this usage summary");
        System.out.println("  -c FILE: configuration FILE");
        System.out.println("  -o FILE: output FILE (default: stdout)");
        System.out.print("  -t TABLE: db table to print. Multiple -t options");
        System.out.println(" are allowed. Default: print all tables");
    }

    public static void main(String[] stringArray) {
        int n;
        Getopt getopt = new Getopt("EDU.bmrb.lib.DbToStar", stringArray, "hc:o:t:");
        String string = null;
        String string2 = null;
        ArrayList<String> arrayList = null;
        block7: while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 99: {
                    string = getopt.getOptarg();
                    continue block7;
                }
                case 111: {
                    string2 = getopt.getOptarg();
                    continue block7;
                }
                case 116: {
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                    }
                    arrayList.add(getopt.getOptarg().toUpperCase());
                    continue block7;
                }
            }
            DbToStar.usage();
            return;
        }
        if (string == null) {
            DbToStar.usage();
            return;
        }
        Connection connection = null;
        try {
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            fileInputStream.close();
            PrintWriter printWriter = null;
            printWriter = string2 == null ? new PrintWriter(System.out) : new PrintWriter(new FileOutputStream(string2));
            String string3 = properties.getProperty(DRIVER_KEY);
            if (string3 == null) {
                throw new NullPointerException("Missing DB driver");
            }
            String string4 = properties.getProperty(DBURL_KEY);
            if (string4 == null) {
                throw new NullPointerException("Missing DB URL");
            }
            Class.forName(string3);
            connection = DriverManager.getConnection(string4, properties.getProperty(DBUSER_KEY), properties.getProperty(DBPASSWD_KEY));
            connection.setAutoCommit(false);
            DbToStar dbToStar = new DbToStar(connection, printWriter, null);
            dbToStar.checkTableNames(arrayList);
            if (arrayList != null) {
                arrayList.clear();
            }
            dbToStar.print();
            connection.close();
            printWriter.close();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }
}

