/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.lib;

import EDU.bmrb.lib.ErrorList;
import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.STARLexer;
import EDU.bmrb.sansj.SimpleStarParser;
import EDU.bmrb.sansj.StarContentHandler;
import EDU.bmrb.sansj.starlib.DataNameNode;
import EDU.bmrb.sansj.starlib.DataValueNode;
import EDU.bmrb.sansj.starlib.StarNode;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class StarToDb
implements StarContentHandler,
ErrorHandler {
    public static final String DRIVER_KEY = "DB.Driver";
    public static final String DBURL_KEY = "DB.Url";
    public static final String DBUSER_KEY = "DB.User";
    public static final String DBPASSWD_KEY = "DB.Password";
    private static final String ERR_COLTYPES = "Cannot get column types";
    private static final String ERR_DBEXC = "DB exception";
    private static final String ERR_DBTYPE = "Wrong data type for value ";
    private String fTableName = null;
    private int[] fColTypes = null;
    private PreparedStatement fStat = null;
    private List fColumns = null;
    private Connection fConn = null;
    private PrintWriter fOut = null;
    private ErrorList fErrs = null;
    private int fColNum = 0;
    private List fTables = null;
    private boolean fOracle = false;

    public StarToDb(Connection connection, PrintWriter printWriter, ErrorList errorList) {
        this.fConn = connection;
        this.fOut = printWriter;
        this.fErrs = errorList;
        this.fColumns = new ArrayList();
        this.fTables = new ArrayList();
    }

    private void fetchTableNames() throws SQLException {
        ResultSet resultSet;
        if (this.fConn == null || this.fConn.isClosed()) {
            System.err.println("Not connected to database");
            return;
        }
        String[] stringArray = new String[]{"TABLE"};
        DatabaseMetaData databaseMetaData = this.fConn.getMetaData();
        if (databaseMetaData.getDatabaseProductName().matches(".*Oracle.*")) {
            this.fOracle = true;
            resultSet = databaseMetaData.getTables(null, databaseMetaData.getUserName(), null, stringArray);
        } else {
            this.fOracle = false;
            resultSet = databaseMetaData.getTables(null, null, null, stringArray);
        }
        while (resultSet.next()) {
            resultSet.getString(3);
            if (!resultSet.wasNull()) {
                this.fTables.add(resultSet.getString(3).toUpperCase());
            }
            System.err.println("Table: " + resultSet.getString(3));
        }
    }

    public void load(BufferedReader bufferedReader) throws SQLException {
        if (this.fConn == null || this.fConn.isClosed()) {
            System.err.println("Not connected to database");
            return;
        }
        this.fetchTableNames();
        STARLexer sTARLexer = new STARLexer(bufferedReader);
        SimpleStarParser simpleStarParser = new SimpleStarParser(sTARLexer, this, this);
        simpleStarParser.parse();
        this.fConn.commit();
    }

    public static void usage() {
        System.out.print("Usage: java EDU.bmrb.javalib.StarToDb [-h]");
        System.out.println(" [-c FILE] [-i FILE] [-o FILE]");
        System.out.println("  -h: print this usage summary");
        System.out.println("  -c FILE: configuration FILE");
        System.out.println("  -i FILE: input FILE (default: stdin)");
        System.out.print("  -o FILE: output FILE for SQL statements (use ");
        System.out.println("single dash '-' for stdout)");
    }

    public static void main(String[] stringArray) {
        int n;
        Getopt getopt = new Getopt("EDU.bmrb.lib.StarToDb", stringArray, "hc:i:o:");
        String string = null;
        String string2 = null;
        String string3 = null;
        block7: while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 99: {
                    string = getopt.getOptarg();
                    continue block7;
                }
                case 105: {
                    string2 = getopt.getOptarg();
                    continue block7;
                }
                case 111: {
                    string3 = getopt.getOptarg();
                    continue block7;
                }
            }
            StarToDb.usage();
            return;
        }
        if (string == null) {
            StarToDb.usage();
            return;
        }
        Connection connection = null;
        try {
            String string4;
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            fileInputStream.close();
            BufferedReader bufferedReader = string2 == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(string2));
            PrintWriter printWriter = null;
            if (string3 != null) {
                printWriter = string3.equals("-") ? new PrintWriter(System.out) : new PrintWriter(new FileOutputStream(string3));
            }
            if ((string4 = properties.getProperty(DRIVER_KEY)) == null) {
                throw new NullPointerException("Missing DB driver");
            }
            String string5 = properties.getProperty(DBURL_KEY);
            if (string5 == null) {
                throw new NullPointerException("Missing DB URL");
            }
            Class.forName(string4);
            connection = DriverManager.getConnection(string5, properties.getProperty(DBUSER_KEY), properties.getProperty(DBPASSWD_KEY));
            connection.setAutoCommit(false);
            StarToDb starToDb = new StarToDb(connection, printWriter, null);
            starToDb.load(bufferedReader);
            connection.close();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void error(int n, int n2, String string) {
        System.err.print("Parse error in line ");
        System.err.print(n);
        System.err.print(", column ");
        System.err.print(n2);
        System.err.print(": ");
        System.err.println(string);
    }

    public boolean warning(int n, int n2, String string) {
        System.err.print("Parse warning in line ");
        System.err.print(n);
        System.err.print(", column ");
        System.err.print(n2);
        System.err.print(": ");
        System.err.println(string);
        return false;
    }

    public boolean startData(StarNode starNode) {
        return false;
    }

    public void endData(StarNode starNode) {
    }

    public boolean startSaveFrame(StarNode starNode) {
        String string = starNode.getValue();
        for (int i = 0; i < this.fTables.size(); ++i) {
            if (!string.equals(this.fTables.get(i))) continue;
            this.fTableName = string;
            return false;
        }
        System.err.print("Invalid table: ");
        System.err.print(string);
        System.err.print(" in line ");
        System.err.println(starNode.getLineNum());
        this.fTableName = null;
        return false;
    }

    public boolean endSaveFrame(StarNode starNode) {
        this.fTableName = null;
        return false;
    }

    public boolean startLoop(StarNode starNode) {
        return false;
    }

    public boolean endLoop(StarNode starNode) {
        if (this.fTableName == null) {
            return false;
        }
        try {
            this.fColTypes = null;
            this.fColumns.clear();
            if (this.fStat != null) {
                this.fStat.getConnection().commit();
                this.fStat.close();
                this.fStat = null;
            }
            return false;
        }
        catch (SQLException sQLException) {
            if (this.fErrs != null) {
                this.fErrs.add(true, -1, -1, starNode.getLineNum(), ERR_DBEXC);
            }
            System.err.println(ERR_DBEXC);
            sQLException.printStackTrace();
            return true;
        }
    }

    public boolean tag(DataNameNode dataNameNode) {
        if (this.fTableName == null) {
            return false;
        }
        this.fColumns.add(dataNameNode.getValue().substring(1));
        return false;
    }

    public boolean data(DataValueNode dataValueNode) {
        if (this.fTableName == null) {
            return false;
        }
        if (this.fOracle) {
            return this.data_orrible(dataValueNode);
        }
        return this.data_proper(dataValueNode);
    }

    public boolean data_orrible(DataValueNode dataValueNode) {
        if (this.fColTypes == null && !this.initRows()) {
            return true;
        }
        try {
            switch (this.fColTypes[this.fColNum]) {
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    if (dataValueNode.getValue().equals(".")) {
                        this.fStat.setNull(this.fColNum + 1, 8);
                        break;
                    }
                    this.fStat.setFloat(this.fColNum + 1, Float.parseFloat(dataValueNode.getValue()));
                    break;
                }
                case 1: {
                    if (dataValueNode.getValue().equals(".")) {
                        this.fStat.setNull(this.fColNum + 1, 1);
                        break;
                    }
                }
                case 12: {
                    if (dataValueNode.getValue().equals(".")) {
                        this.fStat.setNull(this.fColNum + 1, 12);
                        break;
                    }
                    this.fStat.setString(this.fColNum + 1, dataValueNode.getValue());
                    break;
                }
                default: {
                    if (this.fErrs != null) {
                        this.fErrs.add(true, -1, -1, dataValueNode.getLineNum(), ERR_DBTYPE + dataValueNode.getValue() + " " + this.fColTypes[this.fColNum]);
                    }
                    System.err.println(ERR_DBTYPE + dataValueNode.getValue() + " " + this.fColTypes[this.fColNum]);
                    return true;
                }
            }
            ++this.fColNum;
            if (this.fColNum == this.fColTypes.length) {
                this.fColNum = 0;
                this.fStat.executeUpdate();
                this.fStat.getConnection().commit();
            }
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            if (this.fErrs != null) {
                this.fErrs.add(true, -1, -1, dataValueNode.getLineNum(), ERR_DBTYPE + dataValueNode.getValue());
            }
            System.err.println(ERR_DBTYPE + dataValueNode.getValue());
            System.err.println(numberFormatException.getMessage());
            numberFormatException.printStackTrace();
            return true;
        }
        catch (SQLException sQLException) {
            if (this.fErrs != null) {
                this.fErrs.add(true, -1, -1, dataValueNode.getLineNum(), ERR_DBEXC);
            }
            System.err.println(ERR_DBEXC);
            System.err.println(sQLException.getMessage());
            sQLException.printStackTrace();
            return true;
        }
    }

    public boolean data_proper(DataValueNode dataValueNode) {
        if (this.fTableName == null) {
            return false;
        }
        if (this.fColTypes == null && !this.initRows()) {
            return true;
        }
        try {
            switch (this.fColTypes[this.fColNum]) {
                case 8: {
                    if (dataValueNode.getValue().equals(".")) {
                        this.fStat.setNull(this.fColNum + 1, 8);
                        break;
                    }
                    this.fStat.setDouble(this.fColNum + 1, Double.parseDouble(dataValueNode.getValue()));
                    break;
                }
                case 6: {
                    if (dataValueNode.getValue().equals(".")) {
                        this.fStat.setNull(this.fColNum + 1, 6);
                        break;
                    }
                    this.fStat.setFloat(this.fColNum + 1, Float.parseFloat(dataValueNode.getValue()));
                    break;
                }
                case 2: 
                case 4: {
                    if (dataValueNode.getValue().equals(".")) {
                        this.fStat.setNull(this.fColNum + 1, 4);
                        break;
                    }
                    this.fStat.setInt(this.fColNum + 1, Integer.parseInt(dataValueNode.getValue()));
                    break;
                }
                case 5: {
                    if (dataValueNode.getValue().equals(".")) {
                        this.fStat.setNull(this.fColNum + 1, 5);
                        break;
                    }
                    this.fStat.setShort(this.fColNum, Short.parseShort(dataValueNode.getValue()));
                    break;
                }
                case 1: {
                    if (dataValueNode.getValue().equals(".")) {
                        this.fStat.setNull(this.fColNum + 1, 1);
                        break;
                    }
                }
                case 12: {
                    if (dataValueNode.getValue().equals(".")) {
                        this.fStat.setNull(this.fColNum + 1, 12);
                        break;
                    }
                    this.fStat.setString(this.fColNum + 1, dataValueNode.getValue());
                    break;
                }
                default: {
                    if (this.fErrs != null) {
                        this.fErrs.add(true, -1, -1, dataValueNode.getLineNum(), ERR_DBTYPE + dataValueNode.getValue() + " " + this.fColTypes[this.fColNum]);
                    }
                    System.err.println(ERR_DBTYPE + dataValueNode.getValue() + " " + this.fColTypes[this.fColNum]);
                    return true;
                }
            }
            ++this.fColNum;
            if (this.fColNum == this.fColTypes.length) {
                this.fColNum = 0;
                this.fStat.executeUpdate();
                this.fStat.getConnection().commit();
            }
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            if (this.fErrs != null) {
                this.fErrs.add(true, -1, -1, dataValueNode.getLineNum(), ERR_DBTYPE + dataValueNode.getValue());
            }
            System.err.println(ERR_DBTYPE + dataValueNode.getValue());
            System.err.println(numberFormatException.getMessage());
            numberFormatException.printStackTrace();
            return true;
        }
        catch (SQLException sQLException) {
            if (this.fErrs != null) {
                this.fErrs.add(true, -1, -1, dataValueNode.getLineNum(), ERR_DBEXC);
            }
            System.err.println(ERR_DBEXC);
            System.err.println(sQLException.getMessage());
            sQLException.printStackTrace();
            return true;
        }
    }

    private boolean initRows() {
        try {
            int n;
            ResultSet resultSet;
            ResultSetMetaData resultSetMetaData;
            int n2;
            Statement statement = this.fConn.createStatement(1004, 1007);
            StringBuffer stringBuffer = new StringBuffer("SELECT * FROM ");
            stringBuffer.append(this.fTableName);
            if (this.fOut != null) {
                this.fOut.println(stringBuffer);
                this.fOut.flush();
            }
            if ((n2 = (resultSetMetaData = (resultSet = statement.executeQuery(stringBuffer.toString())).getMetaData()).getColumnCount()) != this.fColumns.size()) {
                if (this.fErrs != null) {
                    this.fErrs.add(true, -1, -1, -1, ERR_COLTYPES);
                }
                System.err.println(ERR_COLTYPES);
                return false;
            }
            this.fColTypes = new int[n2];
            stringBuffer.setLength(0);
            stringBuffer.append("INSERT INTO ");
            stringBuffer.append(this.fTableName);
            stringBuffer.append(" (");
            block2: for (n = 0; n < n2; ++n) {
                stringBuffer.append((String)this.fColumns.get(n));
                if (n != n2 - 1) {
                    stringBuffer.append(',');
                }
                for (int i = 0; i <= n2; ++i) {
                    if (!((String)this.fColumns.get(n)).equals(resultSetMetaData.getColumnName(i + 1).toUpperCase())) continue;
                    this.fColTypes[n] = resultSetMetaData.getColumnType(i + 1);
                    continue block2;
                }
            }
            stringBuffer.append(") VALUES (");
            for (n = 0; n < n2; ++n) {
                stringBuffer.append('?');
                if (n == n2 - 1) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append(')');
            this.fStat = this.fConn.prepareStatement(stringBuffer.toString());
            resultSet.close();
            statement.close();
            if (this.fOut != null) {
                this.fOut.println(stringBuffer);
                this.fOut.flush();
            }
            stringBuffer.setLength(0);
            return true;
        }
        catch (Exception exception) {
            System.err.println(ERR_COLTYPES);
            System.err.println(exception.getLocalizedMessage());
            exception.printStackTrace();
            return false;
        }
    }
}

