/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.lib;

import EDU.bmrb.lib.PoolTest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class StringPool {
    protected ArrayList list = new ArrayList();

    public String add(String str) {
        if (str == null) {
            return null;
        }
        if (this.list.size() < 1) {
            String s = str.intern();
            this.list.add(s);
            return s;
        }
        int pos = Collections.binarySearch(this.list, str);
        if (pos >= 0) {
            return (String)this.list.get(pos);
        }
        pos = Math.abs(pos) - 1;
        String s = str.intern();
        this.list.add(pos, s);
        return s;
    }

    public String addNoIntern(String str) {
        if (this.list.size() < 1) {
            this.list.add(str);
            return str;
        }
        int pos = Collections.binarySearch(this.list, str);
        if (pos >= 0) {
            return (String)this.list.get(pos);
        }
        pos = Math.abs(pos) - 1;
        this.list.add(pos, str);
        return str;
    }

    public void clear() {
        this.list.clear();
    }

    public int size() {
        return this.list.size();
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public static void main(String[] args) {
        PoolTest tst = new PoolTest();
        tst.testStoreInternUniq();
        tst.testStoreNoInternUniq();
        tst.testStoreInternNonUniq();
        tst.testStoreNoInternNonUniq();
        tst.testArrayInternUniq();
        tst.testArrayNoInternUniq();
        tst.testArrayInternNonUniq();
        tst.testArrayNoInternNonUniq();
    }
}

