/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.lib;

import EDU.bmrb.lib.StringPool;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class StringTable {
    protected StringPool fStore = new StringPool();
    protected ArrayList fHeaders = new ArrayList();
    protected ArrayList fWidths = new ArrayList();
    protected ArrayList fRows = new ArrayList();

    public int numColumns() {
        return this.fHeaders.size();
    }

    public void addColumn(String name) {
        if (this.fRows.size() > 0) {
            throw new ArrayIndexOutOfBoundsException("Cannot add column: there's data in table");
        }
        this.fHeaders.add(this.fStore.add(name));
        this.fWidths.add(new Integer(0));
    }

    public String getColumnName(int index) {
        if (index < 0 || index >= this.fHeaders.size()) {
            return null;
        }
        return (String)this.fHeaders.get(index);
    }

    public void setColumnName(int index, String name) {
        if (index < 0 || index >= this.fHeaders.size()) {
            return;
        }
        this.fHeaders.set(index, this.fStore.add(name));
    }

    public int getColumnIndex(String name) {
        for (int i = 0; i < this.fHeaders.size(); ++i) {
            if (!((String)this.fHeaders.get(i)).equals(name)) continue;
            return i;
        }
        return -1;
    }

    public int getColumnWidth(int index) {
        if (index < 0 || index >= this.fHeaders.size()) {
            return -1;
        }
        return (Integer)this.fWidths.get(index);
    }

    public int numRows() {
        return this.fRows.size();
    }

    public int addRow() {
        String[] row = new String[this.fHeaders.size()];
        for (int i = 0; i < this.fHeaders.size(); ++i) {
            row[i] = null;
        }
        this.fRows.add(row);
        return this.fRows.size() - 1;
    }

    public String[] getRow(int index) {
        if (index < 0 || index >= this.fRows.size()) {
            return null;
        }
        return (String[])this.fRows.get(index);
    }

    public Iterator rowIterator() {
        return this.fRows.iterator();
    }

    public String get(int row, int col) {
        if (col < 0 || col >= this.fHeaders.size()) {
            throw new ArrayIndexOutOfBoundsException("Bad column number");
        }
        if (row < 0 || row >= this.fRows.size()) {
            throw new ArrayIndexOutOfBoundsException("Bad row number");
        }
        String[] r = (String[])this.fRows.get(row);
        return r[col];
    }

    public boolean set(int row, int col, String str) {
        if (col < 0 || col >= this.fHeaders.size()) {
            return false;
        }
        if (row < 0 || row >= this.fRows.size()) {
            return false;
        }
        String[] r = (String[])this.fRows.get(row);
        r[col] = this.fStore.add(str);
        if (str.length() > (Integer)this.fWidths.get(col)) {
            this.fWidths.add(col, new Integer(str.length()));
        }
        return true;
    }

    public void printHeader(PrintWriter out) {
        int i;
        for (i = 0; i < this.fHeaders.size(); ++i) {
            out.print((String)this.fHeaders.get(i));
            for (int j = 0; j < 4; ++j) {
                out.print(' ');
            }
        }
        out.println();
        for (i = 0; i < 78; ++i) {
            out.print('-');
        }
        out.println();
    }

    public void printBody(PrintWriter out) {
        for (int i = 0; i < this.fRows.size(); ++i) {
            String[] r = (String[])this.fRows.get(i);
            for (int j = 0; j < this.fHeaders.size(); ++j) {
                int k;
                out.print(r[j]);
                int width = (Integer)this.fWidths.get(j);
                for (k = r[j].length(); k < width; ++k) {
                    out.print(' ');
                }
                for (k = 0; k < 4; ++k) {
                    out.print(' ');
                }
            }
            out.println();
        }
        out.flush();
    }

    public void print(PrintWriter out) {
        this.printHeader(out);
        this.printBody(out);
    }
}

