/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.nmrstar.dictionary;

import EDU.bmrb.csv.CSVLexer;
import EDU.bmrb.csv.Yytoken;
import EDU.bmrb.nmrstar.dictionary.DBMgr;
import EDU.bmrb.nmrstar.dictionary.Props;
import EDU.bmrb.nmrstar.utils.QuoteString;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.Statement;

public class CSVparser {
    public static final int NUMTABLES = 9;
    public static final String SFCAT_PROPFILE = "cat_grp.properties";
    public static final String CIFMATCH_PROPFILE = "nmr_cif_match.properties";
    public static final String ENUMDTL_PROPFILE = "enum_dtl.properties";
    public static final String ENUMHDR_PROPFILE = "enum_hdr.properties";
    public static final String ENUMTIE_PROPFILE = "enum_ties.properties";
    public static final String TAG_PROPFILE = "item_tbl.properties";
    public static final String MANOVER_PROPFILE = "man_over.properties";
    public static final String SGRP_PROPFILE = "super_grp.properties";
    public static final String VAL_PROPFILE = "tag_validation.properties";
    public static final String PROPKEY_CSVFILE = "CSVTable.filename";
    public static final String PROPKEY_NUMCOLS = "CSVTable.numcols";
    public static final String PROPKEY_CSVCOLPREFIX = "CSVTable.col";
    public static final String PROPKEY_DBCOLPREFIX = "DBTable.col";
    public static final String PROPKEY_DBTYPEPREFIX = "DBTable.type";
    public static final String PROPKEY_DBTABLE = "DBTable.name";
    Props fGlobalProps = null;
    Connection fConn = null;
    protected String fCsvTableName = "CSVTable.filename";
    protected String fNumCols = "CSVTable.numcols";
    protected String fCsvColPrefix = "CSVTable.col";
    protected String fDbColPrefix = "DBTable.col";
    protected String fDbColTypePrefix = "DBTable.type";
    protected String fDbTableName = "DBTable.name";

    public CSVparser() {
        this.fGlobalProps = new Props();
        this.fGlobalProps.load();
    }

    public CSVparser(Props props) {
        this.fGlobalProps = props;
    }

    public void setConnection(Connection connection) {
        this.fConn = connection;
    }

    private int getColumnIndex(int n, String string, Props props) {
        for (int i = 1; i <= n; ++i) {
            String string2 = props.get(this.fCsvColPrefix + i);
            if (!string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public boolean parse(String string, PrintWriter printWriter) {
        Props props = new Props();
        props.setPropFile(string);
        props.load();
        Statement statement = null;
        String string2 = props.get(this.fCsvTableName);
        if (string2 == null || string2.equals("")) {
            return false;
        }
        String string3 = props.get(this.fDbTableName);
        if (string3 == null || string3.equals("")) {
            return false;
        }
        string3 = string3.toUpperCase();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            if (this.fConn != null) {
                statement = this.fConn.createStatement();
            }
            if (printWriter != null) {
                printWriter.println("DELETE FROM " + string3 + ";");
            }
            if (statement != null) {
                statement.execute("DELETE FROM " + string3);
            }
            if (this.fConn != null && !this.fConn.getAutoCommit()) {
                this.fConn.commit();
            }
            int n2 = Integer.parseInt(props.get(this.fNumCols));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string2)));
            CSVLexer cSVLexer = new CSVLexer((Reader)bufferedReader);
            int n3 = -1;
            String[] stringArray = new String[n2];
            Yytoken yytoken = cSVLexer.yylex();
            while (yytoken != null) {
                ++n3;
                if (yytoken == null) {
                    return false;
                }
                stringArray[n3] = yytoken.getText();
                if (yytoken.getType() == 1) break;
                yytoken = cSVLexer.yylex();
            }
            int[] nArray = new int[n3 + 1];
            String[] stringArray2 = new String[n3 + 1];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = this.getColumnIndex(n2, stringArray[n], props);
                if (nArray[n] != -1) continue;
                System.err.println("Invalid column name: " + stringArray[n]);
                return false;
            }
            stringArray = null;
            n3 = -1;
            yytoken = cSVLexer.yylex();
            while (yytoken.getText().indexOf("TBL_") < 0) {
                yytoken = cSVLexer.yylex();
            }
            while (yytoken.getType() != 1) {
                yytoken = cSVLexer.yylex();
            }
            for (n = 0; n < stringArray2.length; ++n) {
                stringArray2[n] = null;
            }
            yytoken = cSVLexer.yylex();
            while (yytoken != null && yytoken.getText().indexOf("TBL_") < 0) {
                if (++n3 >= nArray.length) {
                    System.err.println("Too many columns in CSV table");
                    return false;
                }
                stringArray2[n3] = yytoken.getText();
                if (stringArray2[n3] == null || stringArray2[n3].equals("")) {
                    stringArray2[n3] = null;
                }
                if (yytoken.getType() == 1) {
                    stringBuffer.setLength(0);
                    stringBuffer.append("INSERT INTO ");
                    stringBuffer.append(string3);
                    stringBuffer.append(" (");
                    stringBuffer.append(props.get(this.fDbColPrefix + 1));
                    for (n = 1; n < nArray.length; ++n) {
                        stringBuffer.append(", ");
                        stringBuffer.append(props.get(this.fDbColPrefix + nArray[n]));
                    }
                    stringBuffer.append(") VALUES (");
                    if (props.get(this.fDbColTypePrefix + 1).equals("integer")) {
                        stringBuffer.append(stringArray2[0]);
                    } else if (stringArray2[0] != null) {
                        stringBuffer.append(QuoteString.quoteForDB(stringArray2[0]));
                    } else {
                        stringBuffer.append("null");
                    }
                    for (n = 1; n < nArray.length; ++n) {
                        stringBuffer.append(", ");
                        if (props.get(this.fDbColTypePrefix + nArray[n]).equals("integer")) {
                            stringBuffer.append(stringArray2[n]);
                            continue;
                        }
                        if (stringArray2[n] != null) {
                            stringBuffer.append(QuoteString.quoteForDB(stringArray2[n]));
                            continue;
                        }
                        stringBuffer.append("null");
                    }
                    stringBuffer.append(")");
                    if (printWriter != null) {
                        printWriter.println(stringBuffer + ";");
                    }
                    if (statement != null) {
                        statement.executeUpdate(stringBuffer.toString());
                    }
                    n3 = -1;
                    for (n = 0; n < stringArray2.length; ++n) {
                        stringArray2[n] = null;
                    }
                }
                yytoken = cSVLexer.yylex();
            }
            if (this.fConn != null && !this.fConn.getAutoCommit()) {
                this.fConn.commit();
            }
            if (statement != null) {
                statement.close();
            }
            while ((yytoken = cSVLexer.yylex()) != null) {
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        CSVparser cSVparser = new CSVparser();
        PrintWriter printWriter = new PrintWriter(System.out);
        DBMgr dBMgr = new DBMgr(cSVparser.fGlobalProps);
        dBMgr.connect(false);
        cSVparser.setConnection(dBMgr.getConnection());
        cSVparser.parse(SFCAT_PROPFILE, printWriter);
        cSVparser.parse(CIFMATCH_PROPFILE, printWriter);
        cSVparser.parse(ENUMDTL_PROPFILE, printWriter);
        cSVparser.parse(ENUMHDR_PROPFILE, printWriter);
        cSVparser.parse(ENUMTIE_PROPFILE, printWriter);
        cSVparser.parse(TAG_PROPFILE, printWriter);
        cSVparser.parse(MANOVER_PROPFILE, printWriter);
        cSVparser.parse(SGRP_PROPFILE, printWriter);
        cSVparser.parse(VAL_PROPFILE, printWriter);
        dBMgr.close();
    }
}

