/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.nmrstar.dictionary;

import EDU.bmrb.nmrstar.dictionary.Props;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class DBMgr {
    private Props fProps = null;
    private Connection fConn = null;

    public DBMgr(Props props) {
        this.fProps = props;
    }

    public void setProperties(Props props) {
        this.fProps = props;
    }

    public Props getProperties() {
        return this.fProps;
    }

    public boolean isConnected() {
        if (this.fConn == null) {
            return false;
        }
        try {
            return !this.fConn.isClosed();
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getLocalizedMessage());
            sQLException.printStackTrace();
            return false;
        }
    }

    public void setConnection(Connection connection) {
        this.fConn = connection;
    }

    public Connection getConnection() {
        return this.fConn;
    }

    public boolean connect(boolean bl) {
        String string = this.fProps.get("DB.Driver");
        if (string == null || string.length() == 0) {
            System.err.println("No DB driver!");
            return false;
        }
        String string2 = this.fProps.get("DB.Url");
        if (string2 == null || string2.length() == 0) {
            System.err.println("No DB URL!");
            return false;
        }
        try {
            Class.forName(string).newInstance();
            this.fConn = DriverManager.getConnection(string2, this.fProps.get("DB.User"), this.fProps.get("DB.Password"));
            this.fConn.setAutoCommit(bl);
            return true;
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
            exception.printStackTrace();
            return false;
        }
    }

    public boolean close() {
        if (!this.isConnected()) {
            return false;
        }
        try {
            this.fConn.close();
            return true;
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
            exception.printStackTrace();
            return false;
        }
    }

    public Statement getStatement() {
        try {
            return this.fConn.createStatement();
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
            exception.printStackTrace();
            return null;
        }
    }

    public Statement getQuery() {
        try {
            return this.fConn.createStatement(1004, 1007);
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
            exception.printStackTrace();
            return null;
        }
    }
}

