/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.nmrstar.dictionary;

import EDU.bmrb.nmrstar.dictionary.Props;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DictionaryHTMLizer {
    static String sqlURL = new String("jdbc:oracle:thin:@eel.bmrb.wisc.edu:1521:PROD");
    static String sqlLogin = new String("logname");
    static String sqlPasswd = new String("password_here");
    static String confdir = new String("");
    static String mostRecentFName = "";
    static String currentSQL = "";
    static Connection sqlCon = null;
    static PrintStream sfFile = null;
    static PrintStream tblFile = null;
    static boolean frameFlg = false;
    static String framePrefix = "";
    static String superGroupPageName = "SuperGroupPage.html";
    static String superGroupTarget = "";
    static String superGroupTargetClause = "";
    static String saveFramePageName = "SaveFramePage.html";
    static String saveFrameTarget = "";
    static String saveFrameTargetClause = "";
    static String dbTablePageName = "TablePage.html";
    static String dbTableTarget = "";
    static String dbTableTargetClause = "";
    static String tagDetailTarget = "";
    static String tagDetailTargetClause = "";
    static String bodyColorSettings = " BGCOLOR=\"#FFFFCC\" TEXT=\"#660000\" LINK=\"#666633\" VLINK=\"#999966\" ALINK=\"#999966\" ";
    static String bodyInvertColorSettings = " BGCOLOR=\"#660000\" TEXT=\"#FFFFCC\" LINK=\"#FFFF33\" VLINK=\"#FFFF66\" ALINK=\"#FFFF66\" ";
    static String textStandoutOn = "<FONT COLOR=black><STRONG>";
    static String textStandoutOff = "</STRONG></FONT>";

    public static boolean processArgs(String[] stringArray) {
        String string = "Usage:  -f or --frame = activate frame usage\n        -c <DIR> or --confdir <DIR> = directory with configuration file (dictionary.properties)\n";
        if (stringArray.length < 1) {
            System.err.println(string);
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-f") || stringArray[i].equalsIgnoreCase("--frame")) {
                System.out.println("Frame page generation enabled.");
                frameFlg = true;
                framePrefix = "frame_";
                superGroupTarget = "superG";
                superGroupTargetClause = "TARGET=\"" + superGroupTarget + "\"";
                saveFrameTarget = "SaveFr";
                saveFrameTargetClause = "TARGET=\"" + saveFrameTarget + "\"";
                dbTableTarget = "dbTable";
                dbTableTargetClause = "TARGET=\"" + dbTableTarget + "\"";
                tagDetailTarget = "tagDetail";
                tagDetailTargetClause = "TARGET=\"" + tagDetailTarget + "\"";
                continue;
            }
            if (stringArray[i].startsWith("-c") || stringArray[i].equalsIgnoreCase("--confdir")) {
                if (++i >= stringArray.length) continue;
                confdir = stringArray[i];
                continue;
            }
            System.err.println(string);
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        String string = null;
        try {
            System.out.println("Version: $Id: DictionaryHTMLizer.java,v 1.1 2005/03/28 18:59:45 dmaziuk Exp $");
            if (!DictionaryHTMLizer.processArgs(stringArray)) {
                return;
            }
            Props props = new Props();
            if (!confdir.equals("")) {
                String string2 = confdir.charAt(confdir.length() - 1) != File.separatorChar ? confdir + File.separatorChar + "dictionary.properties" : confdir + "dictionary.properties";
                props.setPropFile(string2);
            }
            props.load();
            string = props.get("DB.Driver");
            if (string == null || string.equals("")) {
                return;
            }
            Class.forName(string).newInstance();
            sqlURL = props.get("DB.Url");
            if (sqlURL == null || sqlURL.equals("")) {
                return;
            }
            sqlLogin = props.get("DB.User");
            sqlPasswd = props.get("DB.Password");
            sqlCon = DriverManager.getConnection(sqlURL, sqlLogin, sqlPasswd);
            props = null;
            if (frameFlg) {
                DictionaryHTMLizer.frameIndexMaker();
            }
            System.out.print("Making Supercategory Page...");
            DictionaryHTMLizer.superGroupMaker();
            System.out.println("done.");
            System.out.print("Making Saveframe Page...");
            DictionaryHTMLizer.sfPageMaker();
            System.out.println("done.");
            System.out.print("Making Tables summary Page");
            DictionaryHTMLizer.dbTablePageMaker();
            System.out.println("done.");
            sqlCon.close();
        }
        catch (SQLException sQLException) {
            System.err.println();
            System.err.println("SQLException: " + sQLException.getMessage() + ":" + sQLException.getSQLState());
            System.err.println("Error occurred while attempting this SQL statement:");
            System.err.println(currentSQL);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File not found Exception on filename '" + mostRecentFName + "' " + ": " + fileNotFoundException.getMessage());
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception.getClass().getName() + "\n" + exception.getMessage());
        }
    }

    public static void frameIndexMaker() throws FileNotFoundException {
        mostRecentFName = new String(framePrefix + "index.html");
        PrintStream printStream = new PrintStream(new FileOutputStream(mostRecentFName));
        printStream.println("<html>");
        printStream.println("<head>");
        printStream.println("  <title>NMR-STAR dictionary</title>");
        printStream.println("</head>");
        printStream.println("<frameset cols=\"75%,*\">");
        printStream.println("  <frameset rows=\"40%,*\">");
        printStream.println("    <frameset cols=\"40%,*\">");
        printStream.println("      <frameset rows=\"28,*\">");
        printStream.println("        <frame src=\"SupergroupFrameTitle.html\">");
        printStream.println("        <frame src=\"" + framePrefix + superGroupPageName + "\"" + " name=\"" + superGroupTarget + "\">");
        printStream.println("      </frameset>");
        printStream.println("      <frameset rows=\"28,*\">");
        printStream.println("        <frame src=\"SaveframeFrameTitle.html\">");
        printStream.println("        <frame src=\"" + framePrefix + saveFramePageName + "#contact_persons\"" + " name=\"" + saveFrameTarget + "\">");
        printStream.println("      </frameset>");
        printStream.println("    </frameset>");
        printStream.println("    <frameset rows=\"28,*\">");
        printStream.println("      <frame src=\"TagCategoriesFrameTitle.html\">");
        printStream.println("       <frame src=\"" + framePrefix + dbTablePageName + "#ContactPerson\"" + " name=\"" + dbTableTarget + "\">");
        printStream.println("    </frameset>");
        printStream.println("  </frameset>");
        printStream.println(" <frameset rows=\"28,*\">");
        printStream.println("   <frame src=\"TagDetailsFrameTitle.html\">");
        printStream.println("   <frame src=\"frame_tagDetailFrameStub.html\" name=\"" + tagDetailTarget + "\">");
        printStream.println("  </frameset>");
        printStream.println("</frameset>");
        printStream.println("</html>");
        printStream.close();
        PrintStream printStream2 = new PrintStream(new FileOutputStream("frame_tagDetailFrameStub.html"));
        printStream2.println("<html>");
        printStream2.println("<head>");
        printStream2.println("  <title>stub page</title>");
        printStream2.println("</head>");
        printStream2.println("<body " + bodyColorSettings + ">");
        printStream2.println("   <BR>&nbsp;<BR>&nbsp;<BR>&nbsp;<BR>&nbsp;<h3>(Tag detail frame)</h3>");
        printStream2.println("</body>");
        printStream2.println("</html>");
        printStream2.close();
        mostRecentFName = new String("SupergroupFrameTitle.html");
        PrintStream printStream3 = new PrintStream(new FileOutputStream(mostRecentFName));
        printStream3.println("<html>");
        printStream3.println("<head><title>frame title</title></head>");
        printStream3.println("<body " + bodyInvertColorSettings + ">");
        printStream3.println("   <img src=\"SupergroupFrameTitle.jpg\">");
        printStream3.println("</body>");
        printStream3.close();
        mostRecentFName = new String("SaveframeFrameTitle.html");
        printStream3 = new PrintStream(new FileOutputStream(mostRecentFName));
        printStream3.println("<html>");
        printStream3.println("<head><title>frame title</title></head>");
        printStream3.println("<body " + bodyInvertColorSettings + ">");
        printStream3.println("   <img src=\"SaveframeFrameTitle.jpg\">");
        printStream3.println("</body>");
        printStream3.close();
        mostRecentFName = new String("TagCategoriesFrameTitle.html");
        printStream3 = new PrintStream(new FileOutputStream(mostRecentFName));
        printStream3.println("<html>");
        printStream3.println("<head><title>frame title</title></head>");
        printStream3.println("<body " + bodyInvertColorSettings + ">");
        printStream3.println("   <img src=\"TagCategoriesFrameTitle.jpg\">");
        printStream3.println("</body>");
        printStream3.close();
        mostRecentFName = new String("TagDetailsFrameTitle.html");
        printStream3 = new PrintStream(new FileOutputStream(mostRecentFName));
        printStream3.println("<html>");
        printStream3.println("<head><title>frame title</title></head>");
        printStream3.println("<body " + bodyInvertColorSettings + ">");
        printStream3.println("   <img src=\"TagDetailsFrameTitle.jpg\">");
        printStream3.println("</body>");
        printStream3.close();
    }

    public static void sfPageMaker() throws FileNotFoundException, SQLException {
        mostRecentFName = new String(framePrefix + saveFramePageName);
        PrintStream printStream = new PrintStream(new FileOutputStream(mostRecentFName));
        printStream.println("<html>");
        printStream.println("<head>");
        printStream.println("  <title>NMR-STAR dictionary: SaveFramePage</title>");
        printStream.println("</head>");
        printStream.println("<body " + bodyColorSettings + ">");
        printStream.println("<h2>NMR-STAR dictionary: Saveframes</h2>");
        Statement statement = sqlCon.createStatement();
        currentSQL = "select aditReplicable, allowUserFcode, catGrpViewHelp, catGrpViewName, groupId, mandatoryNumber, sfCategory, superGrpId, superGrpName\nfrom aditCatGrp\n order by UPPER(sfCategory)\n";
        boolean bl = statement.execute(currentSQL);
        ResultSet resultSet = statement.getResultSet();
        while (bl = resultSet.next()) {
            String string = DictionaryHTMLizer.resultAsString(resultSet, 1);
            String string2 = DictionaryHTMLizer.resultAsString(resultSet, 2);
            String string3 = DictionaryHTMLizer.resultAsString(resultSet, 3);
            String string4 = DictionaryHTMLizer.resultAsString(resultSet, 4);
            String string5 = DictionaryHTMLizer.resultAsString(resultSet, 5);
            String string6 = DictionaryHTMLizer.resultAsString(resultSet, 6);
            String string7 = DictionaryHTMLizer.resultAsString(resultSet, 7);
            String string8 = DictionaryHTMLizer.resultAsString(resultSet, 8);
            String string9 = DictionaryHTMLizer.resultAsString(resultSet, 9);
            printStream.println("  <A NAME=\"" + string7 + "\"></A>\n");
            printStream.println("  <H3>Saveframe category : " + string7 + "</H3>");
            printStream.println("  <TT>Name</TT>: " + string4 + "<BR>");
            printStream.println("  <TT>Belongs to superGroup " + string8 + " : </TT>" + "<A HREF=\"" + framePrefix + superGroupPageName + "#" + string8 + "\" " + superGroupTargetClause + ">\n " + "         " + string9 + "</A><BR>");
            printStream.println("  <TT>Mandatory Number: </TT>" + string6 + "<BR>");
            printStream.println("  <TT>Is Replicable?: </TT>" + (string.charAt(0) == 'Y' || string.charAt(0) == 'y' ? "yes" : "no") + "<BR>");
            printStream.println("  <BR>");
            printStream.println("  <TT>Saveframe Description: </TT>" + string3 + "<BR>");
            printStream.println("    <EM>Contains tag categories:</EM><BR>");
            printStream.println("      <UL>");
            Statement statement2 = sqlCon.createStatement();
            currentSQL = "select distinct \naditcatgrpid, aditcatviewname, dbtablemanual, originalcategory\n from dict\nwhere originalcategory = '" + string7 + "' \n";
            boolean bl2 = statement2.execute(currentSQL);
            ResultSet resultSet2 = statement2.getResultSet();
            while (bl2 = resultSet2.next()) {
                printStream.println("        <LI><A HREF='" + framePrefix + dbTablePageName + "#" + DictionaryHTMLizer.resultAsString(resultSet2, 3) + "' " + dbTableTargetClause + ">");
                printStream.println(DictionaryHTMLizer.resultAsString(resultSet2, 2) + " (" + DictionaryHTMLizer.resultAsString(resultSet2, 3) + ")</A></LI>");
            }
            statement2.close();
            printStream.println("      </UL>");
            printStream.println("  <P>");
        }
        printStream.println("</body>");
        printStream.println("</html>");
        printStream.close();
    }

    public static void superGroupMaker() throws FileNotFoundException, SQLException {
        mostRecentFName = new String(framePrefix + superGroupPageName);
        PrintStream printStream = new PrintStream(new FileOutputStream(mostRecentFName));
        printStream.println("<html>");
        printStream.println("<head>");
        printStream.println("  <title>NMR-STAR dictionary: SuperGroup</title>");
        printStream.println("</head>");
        printStream.println("<body " + bodyColorSettings + ">");
        printStream.println("<h2>NMR-STAR dictionary: Supergroups (collections of saveframes)</h2>");
        Statement statement = sqlCon.createStatement();
        currentSQL = "select superGrpId, superGrpName, ViewFlags, description from aditSuperGrp\n order by superGrpId\n";
        boolean bl = statement.execute(currentSQL);
        ResultSet resultSet = statement.getResultSet();
        while (bl = resultSet.next()) {
            String string = DictionaryHTMLizer.resultAsString(resultSet, 1);
            String string2 = DictionaryHTMLizer.resultAsString(resultSet, 2);
            String string3 = DictionaryHTMLizer.resultAsString(resultSet, 3);
            String string4 = DictionaryHTMLizer.resultAsString(resultSet, 4);
            printStream.println("  <A NAME=\"" + string + "\"></A>\n");
            printStream.println("  <A NAME=\"" + string2 + "\"></A>\n");
            printStream.println("  <H3>Supergroup " + string + " : " + string2 + "</H3>");
            printStream.println("  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; " + string4 + "<BR>");
            Statement statement2 = sqlCon.createStatement();
            boolean bl2 = statement2.execute("select groupId, superGrpId, sfCategory, catGrpViewName\nfrom aditCatGrp\nwhere superGrpID = '" + string + "'\n" + "order by UPPER(sfCategory)\n");
            ResultSet resultSet2 = statement2.getResultSet();
            printStream.println("  Contains these saveframe categories:\n");
            printStream.println("  <UL>\n");
            while (bl2 = resultSet2.next()) {
                String string5 = DictionaryHTMLizer.resultAsString(resultSet2, 1);
                String string6 = DictionaryHTMLizer.resultAsString(resultSet2, 3);
                String string7 = DictionaryHTMLizer.resultAsString(resultSet2, 4);
                printStream.println("     <LI><A HREF=\"" + framePrefix + saveFramePageName + "#" + string6 + "\" " + saveFrameTargetClause + ">\n");
                printStream.println("         " + string6 + " (" + string7 + ")\n");
                printStream.println("     </A></LI>\n");
            }
            resultSet2.close();
            statement2.close();
            printStream.println("  </UL>\n");
            printStream.println("  <P>");
        }
        resultSet.close();
        statement.close();
        printStream.println("</body>");
        printStream.println("</html>");
        printStream.close();
    }

    public static void oneTableMaker(PrintStream printStream, String string, String string2, String string3) throws FileNotFoundException, SQLException {
        printStream.println("  <TABLE BORDER=1>");
        printStream.println("    <TR>");
        printStream.println("      <TH>tag<BR>name</TH>");
        printStream.println("      <TH>database<BR>column name</TH>");
        printStream.println("      <TH>depositiion<br>mandatory<br>code</TH>");
        printStream.println("      <TH>data type</TH>");
        printStream.println("      <TH>indexed<BR>for<BR>searching</TH>");
        printStream.println("      <TH>internal<BR>use<BR>only</TH>");
        printStream.println("      <TH>part of<BR>the<BR>primary<BR>key</TH>");
        printStream.println("    </TR>");
        String string4 = DictionaryHTMLizer.convertTableNameToFName(string);
        mostRecentFName = new String(framePrefix + string4);
        PrintStream printStream2 = new PrintStream(new FileOutputStream(mostRecentFName));
        printStream2.println("<html>");
        printStream2.println("<head>");
        printStream2.println("  <title>NMR-STAR dictionary: detail of " + string + " table</title>");
        printStream2.println("</head>");
        printStream2.println("<body " + bodyColorSettings + ">");
        printStream2.println("<h2>NMR-STAR dictionary: database table: <A HREF='" + framePrefix + dbTablePageName + "#" + string + "' " + dbTableTargetClause + ">" + string + "</A></h2>");
        printStream2.println("<EM>Detailed description of the fields</EM>\n");
        Statement statement = sqlCon.createStatement();
        currentSQL = "select \n  dictionarySeq,\n  originalTag,\n  depMandatory,\n  dbColumnManual,\n  dbType,\n  indexFlag,\n  internalFlag,\n  primaryKey,\n  dbNullable,\n  enumeratedFlg,\n  itemEnumClosedFlg,\n  rowIndexFlg,\n  sfIdFlg,\n  foreignTable,\n  foreignColumn,\n  description,\n  aditItemViewName,\n  example,\n  help,\n  originalCategory\nfrom dict\nwhere dbTableManual = '" + string + "'\n" + "  and originalCategory = '" + string3 + "'\n" + "order by dictionarySeq\n";
        boolean bl = statement.execute(currentSQL);
        ResultSet resultSet = statement.getResultSet();
        while (bl = resultSet.next()) {
            String string5 = DictionaryHTMLizer.resultAsString(resultSet, 1);
            String string6 = DictionaryHTMLizer.resultAsString(resultSet, 2);
            String string7 = DictionaryHTMLizer.resultAsString(resultSet, 3);
            String string8 = DictionaryHTMLizer.resultAsString(resultSet, 4);
            String string9 = DictionaryHTMLizer.resultAsString(resultSet, 5);
            String string10 = DictionaryHTMLizer.resultAsString(resultSet, 6);
            boolean bl2 = string10.length() > 0 && (string10.charAt(0) == 'Y' || string10.charAt(0) == 'y');
            String string11 = DictionaryHTMLizer.resultAsString(resultSet, 7);
            boolean bl3 = string11.length() > 0 && (string11.charAt(0) == 'Y' || string11.charAt(0) == 'y');
            String string12 = DictionaryHTMLizer.resultAsString(resultSet, 8);
            boolean bl4 = string12.length() > 0 && (string12.charAt(0) == 'Y' || string12.charAt(0) == 'y');
            String string13 = DictionaryHTMLizer.resultAsString(resultSet, 9);
            boolean bl5 = string13.length() >= 8 && string13.substring(0, 8).equalsIgnoreCase("NOT NULL");
            String string14 = DictionaryHTMLizer.resultAsString(resultSet, 10);
            boolean bl6 = string14.length() > 0 && (string14.charAt(0) == 'y' || string14.charAt(0) == 'Y');
            String string15 = DictionaryHTMLizer.resultAsString(resultSet, 11);
            boolean bl7 = string15.length() > 0 && (string15.charAt(0) == 'y' || string15.charAt(0) == 'Y');
            String string16 = DictionaryHTMLizer.resultAsString(resultSet, 12);
            boolean bl8 = string16.length() > 0 && (string16.charAt(0) == 'y' || string16.charAt(0) == 'Y');
            String string17 = DictionaryHTMLizer.resultAsString(resultSet, 13);
            boolean bl9 = string17.length() > 0 && (string17.charAt(0) == 'y' || string17.charAt(0) == 'Y');
            String string18 = DictionaryHTMLizer.resultAsString(resultSet, 14);
            String string19 = DictionaryHTMLizer.resultAsString(resultSet, 15);
            String string20 = DictionaryHTMLizer.resultAsString(resultSet, 16);
            String string21 = DictionaryHTMLizer.resultAsString(resultSet, 17);
            String string22 = DictionaryHTMLizer.resultAsString(resultSet, 18);
            String string23 = DictionaryHTMLizer.resultAsString(resultSet, 19);
            String string24 = DictionaryHTMLizer.resultAsString(resultSet, 20);
            printStream.println("    <TR>");
            printStream.println("      <TD>\n");
            printStream.println("          " + (bl8 ? "[row index tag]<BR>\n" : ""));
            printStream.println("          " + (bl9 ? "[saveframe id tag]<BR>\n" : ""));
            printStream.println("      <A HREF='" + framePrefix + string4 + "#" + string6 + "' " + tagDetailTargetClause + ">" + string6 + "</A>&nbsp;</TD>");
            printStream.println("      <TD>" + string8 + "&nbsp;</TD>");
            printStream.println("      <TD>" + string7 + "&nbsp;</TD>");
            printStream.println("      <TD>" + string9 + "&nbsp;</TD>");
            printStream.println("      <TD>" + (bl2 ? "yes" : "no") + "&nbsp;</TD>");
            printStream.println("      <TD>" + (bl3 ? "yes" : "no") + "&nbsp;</TD>");
            printStream.println("      <TD>" + (bl4 ? "yes" : "no") + "&nbsp;</TD>");
            printStream.println("    </TR>");
            DictionaryHTMLizer.tagDetailTableMaker(string4, string24, string2, bl8, bl9, printStream2, string6, string, string8, string9, bl2, bl3, bl4, bl5, bl6, bl7, string18, string19, string20, string21, string22, string23);
        }
        printStream.println("  </TABLE>");
        printStream.println("  <H4>For a more detailed description of the tags in the ");
        printStream.println("      above table, <A HREF='" + string4 + "' " + tagDetailTargetClause + " >see this page</A>.</H4>");
        resultSet.close();
        statement.close();
        printStream2.println("</body>");
        printStream2.println("</head>");
        printStream2.close();
    }

    public static void tagDetailTableMaker(String string, String string2, String string3, boolean bl, boolean bl2, PrintStream printStream, String string4, String string5, String string6, String string7, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, String string8, String string9, String string10, String string11, String string12, String string13) throws FileNotFoundException, SQLException {
        printStream.println("<A NAME='" + string4 + "'></A>");
        printStream.println("<A NAME='" + string5 + "'></A>");
        printStream.println("<H3>" + string4 + " <EM>(" + string6 + ")</EM></H3>");
        printStream.println("<A HREF='" + framePrefix + dbTablePageName + "#" + string5 + "' " + dbTableTargetClause + ">" + "(go to parent tag category listing)</A>");
        printStream.println("<TABLE BORDER=1>");
        printStream.println("  <TR><TH>NMR-STAR tag name</TH><TD>" + string4 + "&nbsp;</TD></TR>");
        printStream.println("  <TR><TH>Description</TH><TD>" + string10 + "&nbsp;</TD></TR>");
        printStream.println("  <TR><TH>Database field name</TH><TD>" + string6 + "&nbsp;</TD></TR>");
        printStream.println("  <TR><TH>SQL Database type</TH><TD>" + string7 + "&nbsp;</TD></TR>");
        printStream.println("  <TR><TH>Part of primary Key</TH><TD>" + (bl5 ? "yes" : "no") + "&nbsp;</TD></TR>");
        printStream.println("  <TR><TH>Foreign Key on table, column</TH><TD><A HREF='" + framePrefix + DictionaryHTMLizer.convertTableNameToFName(string5) + "#" + string9 + "' " + tagDetailTargetClause + ">" + string8 + ", " + string9 + "</A>&nbsp;</TD></TR>");
        printStream.println("  <TR><TH>Saveframe ID </TH><TD>" + (bl ? "yes: This tag contains the identifier for this saveframe in the entry." : "no") + "&nbsp;</TD></TR>");
        printStream.println("  <TR><TH>Row Index</TH><TD>" + (bl ? "yes: This tag contains the index of this row in the loop, which is used when the data is loaded into a database which has a relational model in which ordering doesn't matter" : "no") + "&nbsp;</TD></TR>");
        printStream.println("  <TR><TH>Secondary Index</TH><TD>" + (bl3 ? "yes<BR>" + textStandoutOn + "This field is one that should be given a" + " secondary index in a database to aid in searches." + textStandoutOff : "no") + "&nbsp;</TD></TR>");
        printStream.println("  <TR><TH>Internal Flag</TH><TD>" + (bl4 ? "yes<BR>" + textStandoutOn + "This field's data is for internal" + " use only and should be hidden in public versiond of" + " the data." + textStandoutOff : "no") + "&nbsp;</TD></TR>");
        printStream.println("  <TR><TH>Nulls allowed in database?</TH><TD>" + (bl6 ? "yes" : "no") + "&nbsp;</TD></TR>");
        if (bl7) {
            printStream.println("  <TR><TH>Enumerations</TH><TD><A HREF=\"enum_" + string4 + ".html\" TARGET=\"enum_popup\">" + "[click for a list of enumerations]</A><BR><EM>" + (bl8 ? "This is a closed enumeration.  The list of values are the only ones allowed." : "This is an open enumeration.  The list of values are only suggestions.  They are not enforced.") + "</EM>&nbsp;</TD></TR>");
            mostRecentFName = "enum_" + DictionaryHTMLizer.convertTableNameToFName(string4);
            PrintStream printStream2 = new PrintStream(new FileOutputStream(mostRecentFName));
            String string14 = DictionaryHTMLizer.enumerationFetch(string4, string2);
            printStream2.println("<html>");
            printStream2.println("<head>");
            printStream2.println("  <title>Enumerations for " + string4 + "</title>");
            printStream2.println("</head>");
            printStream2.println("<body>");
            printStream2.println("<table border=0 cellspacing=2 cellpadding=1>");
            printStream2.println("  <TR><TH COLSPAN=2>Enumerations for " + string4 + " (" + (bl8 ? "A closed" : "An open") + " enumeration)" + "&nbsp;</TD></TR>");
            printStream2.println(string14);
            printStream2.println("</table>");
            printStream2.println("</body>");
            printStream2.println("<html>");
            printStream2.close();
        }
        printStream.println("  <TR><TH>Prompt</TH><TD>" + string11 + "&nbsp;</TD></TR>");
        printStream.println("  <TR><TH>Examples</TH><TD>" + string12 + "&nbsp;</TD></TR>");
        printStream.println("  <TR><TH>Help text</TH><TD>" + string13 + "&nbsp;</TD></TR>");
        printStream.println("</TABLE>");
        printStream.println("<P>");
    }

    public static String enumerationFetch(String string, String string2) throws FileNotFoundException, SQLException {
        String string3 = "";
        Statement statement = sqlCon.createStatement();
        currentSQL = "select\n   h.sfCategory, h.originalTag, h.enumId, d.value, d.detail from aditenumhdr h, aditenumdtl d\nwhere h.originalTag = '" + string + "'\n" + "  and h.sfCategory = '" + string2 + "'\n" + "  and h.enumId = d.enumId\n " + "order by UPPER(d.value)\n";
        boolean bl = statement.execute(currentSQL);
        ResultSet resultSet = statement.getResultSet();
        string3 = "";
        while (bl = resultSet.next()) {
            String string4 = DictionaryHTMLizer.resultAsString(resultSet, 5);
            String string5 = DictionaryHTMLizer.resultAsString(resultSet, 2);
            String string6 = DictionaryHTMLizer.resultAsString(resultSet, 4);
            string3 = string3.concat("  <TR><TD BGCOLOR=\"#CCCCCC\"><TT><FONT COLOR=black>" + string6 + "</FONT></TT>&nbsp;</TD><TD BGCOLOR=\"#BBDDDD\"><FONT COLOR=\"#660000\">" + (string4.length() > 0 ? string4 : "") + "</FONT>&nbsp;</TD></TR>\n");
        }
        resultSet.close();
        statement.close();
        return string3;
    }

    public static void dbTablePageMaker() throws FileNotFoundException, SQLException {
        mostRecentFName = new String(framePrefix + dbTablePageName);
        PrintStream printStream = new PrintStream(new FileOutputStream(mostRecentFName));
        printStream.println("<html>");
        printStream.println("<head>");
        printStream.println("  <title>NMR-STAR dictionary: database tag categories</title>");
        printStream.println("</head>");
        printStream.println("<body " + bodyColorSettings + ">");
        printStream.println("<h2>NMR-STAR dictionary: database tag categories</h2>");
        Statement statement = sqlCon.createStatement();
        currentSQL = "select distinct \naditcatgrpid, aditcatmanflg, aditcatviewname, aditcatviewtype, aditsupercatid, aditsupercatname, dbtablemanual, originalcategory, originalTag\nfrom dict\norder by UPPER(dbtablemanual), UPPER(originalcategory), UPPER(originalTag)\n";
        boolean bl = statement.execute(currentSQL);
        ResultSet resultSet = statement.getResultSet();
        int n = 0;
        System.out.println();
        String string = "";
        while (bl = resultSet.next()) {
            System.out.print(".");
            ++n;
            String string2 = DictionaryHTMLizer.resultAsString(resultSet, 1);
            String string3 = DictionaryHTMLizer.resultAsString(resultSet, 2);
            String string4 = DictionaryHTMLizer.resultAsString(resultSet, 3);
            String string5 = DictionaryHTMLizer.resultAsString(resultSet, 4);
            String string6 = DictionaryHTMLizer.resultAsString(resultSet, 5);
            String string7 = DictionaryHTMLizer.resultAsString(resultSet, 6);
            String string8 = DictionaryHTMLizer.resultAsString(resultSet, 7);
            String string9 = DictionaryHTMLizer.resultAsString(resultSet, 8);
            String string10 = DictionaryHTMLizer.resultAsString(resultSet, 9);
            int n2 = string10.indexOf(46);
            String string11 = string10.substring(0, n2 + 1);
            if (string11.charAt(0) == '_') {
                string11 = string11.substring(1);
            }
            if (string8.equals(string)) continue;
            System.out.println();
            System.out.print(string8);
            string = string8;
            printStream.println("<A NAME='" + string8 + "'></A>");
            printStream.println("  <H3>Tag Category: " + string11 + " (database table: " + string8 + ")\n" + " <BR>(part of saveframe category: " + DictionaryHTMLizer.sfCatForTblFetch(string8) + ")</H3>\n");
            printStream.println("  <TT>Human-readable name: </TT>: " + string4 + "<BR>");
            printStream.println("  <TT>Mandatory</TT>: " + (string3.charAt(0) == 'y' || string3.charAt(0) == 'Y' ? "yes" : "no") + "<BR>");
            DictionaryHTMLizer.oneTableMaker(printStream, string8, string11, string9);
            printStream.println("  <P>");
        }
        resultSet.close();
        statement.close();
        printStream.println("</body>");
        printStream.println("</html>");
        printStream.close();
    }

    public static String sfCatForTblFetch(String string) throws SQLException {
        String string2 = "";
        Statement statement = sqlCon.createStatement();
        currentSQL = "select distinct\n  originalCategory,\n  dbTableManual\nfrom dict\nwhere dbTableManual = '" + string + "'" + "order by originalCategory";
        boolean bl = statement.execute(currentSQL);
        ResultSet resultSet = statement.getResultSet();
        while (bl = resultSet.next()) {
            String string3 = DictionaryHTMLizer.resultAsString(resultSet, 1);
            if (string2.length() != 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + "<A HREF='" + framePrefix + saveFramePageName + "#" + string3 + "' " + saveFrameTargetClause + ">" + string3 + "</A>";
        }
        resultSet.close();
        statement.close();
        return string2;
    }

    public static String convertTableNameToFName(String string) {
        String string2 = string;
        string2 = string2.replace('/', '_');
        string2 = string2.replace('\\', '_');
        string2 = string2.replace(':', '_');
        string2 = string2.replace(';', '_');
        string2 = string2.concat(".html");
        return string2;
    }

    public static String resultAsString(ResultSet resultSet, int n) throws SQLException {
        Object object = resultSet.getObject(n);
        String string = null;
        string = object == null ? "" : object.toString();
        return string;
    }
}

