/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.nmrstar.dictionary;

import EDU.bmrb.lib.CreateDBSchema;
import gnu.getopt.Getopt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class Load {
    private static final boolean DEBUG = true;
    public static final String DEF_PROPFILE = "loader.properties";
    public static final String JDBC_DRIVER = "org.relique.jdbc.csv.CsvDriver";
    public static final String JDBC_URL = "jdbc:relique:csv:";
    public static final String KEY_FILEDIR = "CSV.dir";
    public static final String KEY_DRIVER = "DB.Driver";
    public static final String KEY_URL = "DB.Url";
    public static final String KEY_DBUSER = "DB.User";
    public static final String KEY_DBPASS = "DB.Password";
    public static final String KEY_SCRIPT = "Schema.pretables";
    public static final String KEY_MAPCOUNT = "Map.count";
    public static final String KEY_MAPNAME = "Map.file";
    public static final String VAL_DBINT = "integer";
    public static final String VAL_DBSTRING = "string";
    public static final int INTEGER = 0;
    public static final int STRING = 1;
    private Properties fProps = null;
    private Connection fSrcConn = null;
    private Connection fTgtConn = null;
    private StringBuffer fBuf = null;
    private StringBuffer fSql = null;

    public Load(Properties props) {
        this.fProps = props;
        this.fBuf = new StringBuffer();
        this.fSql = new StringBuffer();
    }

    public void connect() throws ClassNotFoundException, SQLException {
        if (this.fSrcConn == null || this.fSrcConn.isClosed()) {
            Class.forName(JDBC_DRIVER);
            this.fBuf.setLength(0);
            this.fBuf.append(JDBC_URL);
            this.fBuf.append(this.fProps.getProperty(KEY_FILEDIR));
            this.fSrcConn = DriverManager.getConnection(this.fBuf.toString());
        }
        if (this.fTgtConn == null || this.fTgtConn.isClosed()) {
            Class.forName(this.fProps.getProperty(KEY_DRIVER));
            this.fTgtConn = DriverManager.getConnection(this.fProps.getProperty(KEY_URL), this.fProps.getProperty(KEY_DBUSER), this.fProps.getProperty(KEY_DBPASS));
            this.fTgtConn.setAutoCommit(false);
        }
    }

    public Connection getDBConnection() {
        return this.fTgtConn;
    }

    public void close() throws SQLException {
        if (this.fSrcConn != null && !this.fSrcConn.isClosed()) {
            this.fSrcConn.close();
            this.fSrcConn = null;
        }
        if (this.fTgtConn != null && !this.fTgtConn.isClosed()) {
            this.fTgtConn.commit();
            this.fTgtConn.close();
            this.fTgtConn = null;
        }
    }

    public void load(boolean load, PrintWriter out) throws IOException, SQLException {
        if (out == null && !load) {
            return;
        }
        Properties props = new Properties();
        FileInputStream in = null;
        int numtables = Integer.parseInt(this.fProps.getProperty(KEY_MAPCOUNT));
        for (int i = 0; i < numtables; ++i) {
            this.fBuf.setLength(0);
            this.fBuf.append(KEY_MAPNAME);
            this.fBuf.append(i);
            System.err.println(this.fBuf);
            in = new FileInputStream(this.fProps.getProperty(this.fBuf.toString()));
            props.clear();
            props.load(in);
            in.close();
            in = null;
            this.loadTable(props, load, out);
        }
    }

    public void loadTable(Properties props, boolean load, PrintWriter out) throws SQLException {
        int i;
        if (out == null && !load) {
            return;
        }
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT ");
        this.fSql.setLength(0);
        this.fSql.append("INSERT INTO ");
        this.fSql.append(props.getProperty("DBTable.name"));
        this.fSql.append(" (");
        int colcount = Integer.parseInt(props.getProperty("CSVTable.numcols"));
        for (i = 0; i < colcount; ++i) {
            this.fBuf.append(props.getProperty("CSVTable.col" + i));
            if (i < colcount - 1) {
                this.fBuf.append(',');
            }
            this.fSql.append(props.getProperty("DBTable.col" + i));
            if (i >= colcount - 1) continue;
            this.fSql.append(',');
        }
        this.fBuf.append(" FROM ");
        this.fBuf.append(props.getProperty("CSV.table"));
        System.err.println(this.fBuf);
        this.fSql.append(") VALUES (");
        for (i = 0; i < colcount; ++i) {
            this.fSql.append('?');
            if (i >= colcount - 1) continue;
            this.fSql.append(',');
        }
        this.fSql.append(')');
        System.err.println(this.fSql);
        boolean isint = false;
        boolean indata = false;
        Statement query = this.fSrcConn.createStatement();
        PreparedStatement pstat = this.fTgtConn.prepareStatement(this.fSql.toString());
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        while (rs.next()) {
            String tmp = rs.getString(1);
            if (rs.wasNull()) continue;
            if (tmp.matches("TBL_.*")) {
                if (!indata) {
                    indata = true;
                    continue;
                }
                indata = false;
                continue;
            }
            if (!indata || tmp.matches("-+")) continue;
            for (i = 0; i < colcount; ++i) {
                isint = false;
                this.fBuf.setLength(0);
                this.fBuf.append("DBTable.type");
                this.fBuf.append(i);
                if (props.getProperty(this.fBuf.toString()).equals(VAL_DBINT)) {
                    isint = true;
                }
                tmp = rs.getString(i + 1);
                if (rs.wasNull()) {
                    if (isint) {
                        pstat.setNull(i + 1, 4);
                        continue;
                    }
                    pstat.setNull(i + 1, 12);
                    continue;
                }
                if (isint) {
                    pstat.setInt(i + 1, rs.getInt(i + 1));
                    continue;
                }
                pstat.setString(i + 1, tmp);
            }
            if (out != null) {
                out.println(pstat);
            }
            System.err.println(pstat);
            if (!load) continue;
            pstat.executeUpdate();
        }
        if (load) {
            pstat.getConnection().commit();
        }
        pstat.close();
        query.close();
    }

    public static void usage() {
        System.err.print("Usage: java EDU.bmrb.nmrstar.dictionary.Load [-h]");
        System.err.println(" [-n] [-c DIR] [-o FILE]");
        System.err.println("  -h: print this usage summary");
        System.err.print("  -n: do not load data into database (use with -o ");
        System.err.println("to generate SQL script)");
        System.err.print("  -o FILE: output SQL INSERT statements to FILE (use");
        System.err.println(" dash to print to stdout)");
        System.err.print("  -c DIR: use configuration (properties) files in ");
        System.err.println("directory DIR instead of user's home directory");
    }

    public static void main(String[] args) {
        try {
            int opt;
            boolean load = true;
            Getopt g = new Getopt("EDU.bmrb.nmrstar.dictionary.Load", args, "hnc:o:");
            String confdir = null;
            String outfile = null;
            block8: while ((opt = g.getopt()) != -1) {
                switch (opt) {
                    case 104: {
                        Load.usage();
                        return;
                    }
                    case 110: {
                        load = false;
                        continue block8;
                    }
                    case 99: {
                        confdir = g.getOptarg();
                        continue block8;
                    }
                    case 111: {
                        outfile = g.getOptarg();
                        continue block8;
                    }
                }
                Load.usage();
                System.exit(1);
            }
            if (confdir != null) {
                if (confdir.charAt(confdir.length() - 1) != File.separatorChar) {
                    confdir = confdir + File.separatorChar;
                }
            } else {
                confdir = System.getProperty("user.home") + File.separatorChar;
            }
            Properties props = new Properties();
            FileInputStream in = new FileInputStream(confdir + DEF_PROPFILE);
            props.load(in);
            in.close();
            System.err.println("Loaded properties from " + confdir);
            PrintWriter out = null;
            if (outfile != null) {
                out = outfile.equals("-") ? new PrintWriter(System.out) : new PrintWriter(new FileOutputStream(outfile));
            }
            Load l = new Load(props);
            l.connect();
            CreateDBSchema.runScript(l.getDBConnection(), props.getProperty(KEY_SCRIPT), out);
            l.load(load, out);
            l.close();
            if (out != null) {
                out.flush();
            }
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
        }
    }
}

