/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.nmrstar.dictionary;

import java.io.FileInputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class MakeConfig {
    public static final String DEF_PROPFILE = "makeconfig.properties";
    public static final String KEY_TBLCOUNT = "CSV.numtables";
    public static final String KEY_FILEDIR = "CSV.dir";
    public static final String KEY_TBLNAME = "CSV.table";
    public static final String JDBC_DRIVER = "org.relique.jdbc.csv.CsvDriver";
    public static final String JDBC_URL = "jdbc:relique:csv:";
    public static final String CSV_FILE = "CSVTable.filename";
    public static final String DB_TABLE = "DBTable.name";
    public static final String CSV_NUMCOLS = "CSVTable.numcols";
    public static final String CSV_COL = "CSVTable.col";
    public static final String DB_COL = "DBTable.col";
    public static final String DB_TYPE = "DBTable.type";
    private Connection fConn = null;
    private Properties fProps = null;
    private StringBuffer fBuf = null;

    public MakeConfig(Properties properties) {
        this.fProps = properties;
        this.fBuf = new StringBuffer();
    }

    public void connect() throws ClassNotFoundException, SQLException {
        if (this.fConn != null && !this.fConn.isClosed()) {
            return;
        }
        Class.forName(JDBC_DRIVER);
        this.fBuf.setLength(0);
        this.fBuf.append(JDBC_URL);
        this.fBuf.append(this.fProps.getProperty(KEY_FILEDIR));
        this.fConn = DriverManager.getConnection(this.fBuf.toString());
    }

    public void close() throws SQLException {
        if (this.fConn != null && !this.fConn.isClosed()) {
            this.fConn.close();
        }
        this.fConn = null;
    }

    public void makeTemplate(PrintWriter printWriter) throws SQLException {
        int n = Integer.parseInt(this.fProps.getProperty(KEY_TBLCOUNT));
        for (int i = 0; i < n; ++i) {
            this.fBuf.setLength(0);
            this.fBuf.append(KEY_TBLNAME);
            this.fBuf.append(i);
            this.printTable(this.fProps.getProperty(this.fBuf.toString()), printWriter);
        }
    }

    public void printTable(String string, PrintWriter printWriter) throws SQLException {
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT * FROM ");
        this.fBuf.append(string);
        Statement statement = this.fConn.createStatement();
        ResultSet resultSet = statement.executeQuery(this.fBuf.toString());
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        printWriter.print(CSV_FILE);
        printWriter.print('=');
        printWriter.print(this.fProps.getProperty(KEY_FILEDIR));
        printWriter.print('/');
        printWriter.print(string);
        printWriter.println(".csv");
        printWriter.print(KEY_TBLNAME);
        printWriter.print('=');
        printWriter.println(string);
        printWriter.print(DB_TABLE);
        printWriter.println('=');
        printWriter.print(CSV_NUMCOLS);
        printWriter.print('=');
        printWriter.println(n);
        printWriter.println();
        for (int i = 0; i < n; ++i) {
            printWriter.print(CSV_COL);
            printWriter.print(i);
            printWriter.print('=');
            printWriter.println(resultSetMetaData.getColumnName(i + 1));
            printWriter.print(DB_COL);
            printWriter.print(i);
            printWriter.println('=');
            printWriter.print(DB_TYPE);
            printWriter.print(i);
            printWriter.println('=');
            printWriter.println();
        }
        resultSet.close();
        statement.close();
        printWriter.println();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage: MakeConfig <conffile>");
            System.exit(1);
        }
        try {
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            properties.load(fileInputStream);
            fileInputStream.close();
            MakeConfig makeConfig = new MakeConfig(properties);
            makeConfig.connect();
            PrintWriter printWriter = new PrintWriter(System.out);
            makeConfig.makeTemplate(printWriter);
            makeConfig.close();
            printWriter.flush();
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
            exception.printStackTrace();
        }
    }
}

