/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.nmrstar.utils;

import EDU.bmrb.sansj.ContentHandler;
import EDU.bmrb.sansj.DataItemNode;
import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.STARLexer;
import EDU.bmrb.sansj.SansParser;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class GetTitle
implements ContentHandler,
ErrorHandler {
    public static final String BMRBNO_TAG = "_BMRB_accession_number";
    public static final String TITLE_TAG = "_Entry_title";
    private PrintWriter fOut = null;
    private String fBmrbId = null;
    private String fTitle = null;

    public void setOut(PrintWriter printWriter) {
        this.fOut = printWriter;
    }

    public static void usage() {
        System.out.print("Usage: java EDU.bmrb.nmrstar.utils.GetTitle");
        System.out.println(" [-i filename] [-o filename] [-h]");
        System.out.println("  -i filename: input file name (default: stdin)");
        System.out.println("  -o filename: output file name (default: stdout)");
        System.out.println("  -h: print this help message and exit");
    }

    public static void main(String[] stringArray) {
        int n;
        Getopt getopt = new Getopt("pdbmatch", stringArray, "bhd:i:o:");
        String string = null;
        String string2 = null;
        block8: while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 105: {
                    string = getopt.getOptarg();
                    continue block8;
                }
                case 111: {
                    string2 = getopt.getOptarg();
                    continue block8;
                }
            }
            GetTitle.usage();
            return;
        }
        BufferedReader bufferedReader = null;
        PrintWriter printWriter = null;
        try {
            bufferedReader = string == null || string.length() < 1 ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new InputStreamReader(new FileInputStream(string)));
        }
        catch (IOException iOException) {
            System.err.println("Cannot open input file");
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
            return;
        }
        try {
            printWriter = string2 == null || string2.length() < 1 ? new PrintWriter(System.out) : new PrintWriter(new FileOutputStream(string2));
        }
        catch (IOException iOException) {
            System.err.println("Cannot open output file");
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
            return;
        }
        GetTitle getTitle = new GetTitle();
        getTitle.setOut(printWriter);
        STARLexer sTARLexer = new STARLexer(bufferedReader);
        SansParser sansParser = new SansParser(sTARLexer);
        sansParser.setContentHandler(getTitle);
        sansParser.setErrorHandler(getTitle);
        sansParser.parse();
        printWriter.flush();
    }

    public void error(int n, int n2, String string) {
        System.err.print("Entry ");
        System.err.print(this.fBmrbId);
        System.err.print(": parse error in line ");
        System.err.print(n);
        System.err.print(", column ");
        System.err.print(n2);
        System.err.print(": ");
        System.err.println(string);
    }

    public boolean warning(int n, int n2, String string) {
        return false;
    }

    public boolean comment(int n, String string) {
        return false;
    }

    public boolean startData(int n, String string) {
        return false;
    }

    public void endData(int n, String string) {
    }

    public boolean startSaveFrame(int n, String string) {
        return false;
    }

    public boolean endSaveFrame(int n, String string) {
        if (this.fBmrbId != null && this.fTitle != null) {
            this.fOut.print(this.fBmrbId);
            this.fOut.print('\t');
            this.fOut.println(this.fTitle);
            return true;
        }
        return false;
    }

    public boolean startLoop(int n) {
        return false;
    }

    public boolean endLoop(int n) {
        return false;
    }

    public boolean data(DataItemNode dataItemNode) {
        if (dataItemNode.getName().equals(BMRBNO_TAG)) {
            this.fBmrbId = dataItemNode.getValue();
        } else if (dataItemNode.getName().equals(TITLE_TAG)) {
            this.fTitle = dataItemNode.getValue().replaceAll("\n", " ").replaceAll("\\s{2,}", " ").trim();
        }
        return false;
    }
}

